/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.classfile;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.classfile.ClassFileRecorder;
import org.modeshape.sequencer.classfile.DefaultClassFileRecorder;
import org.modeshape.sequencer.classfile.metadata.ClassFileMetadataReader;
import org.modeshape.sequencer.classfile.metadata.ClassMetadata;

@ThreadSafe
public class ClassFileSequencer
extends Sequencer {
    private static final ClassFileRecorder DEFAULT_CLASS_FILE_RECORDER = new DefaultClassFileRecorder();
    private ClassFileRecorder classFileRecorder = DEFAULT_CLASS_FILE_RECORDER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        InputStream stream = binaryValue.getStream();
        try {
            ClassMetadata classMetadata = ClassFileMetadataReader.instance(stream);
            this.classFileRecorder.recordClass(context, outputNode, classMetadata);
            boolean bl = true;
            return bl;
        }
        finally {
            stream.close();
        }
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("sequencer-classfile.cnd", nodeTypeManager, true);
    }

    public void setClassFileRecorderClassName(String classFileRecorderClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (classFileRecorderClassName == null) {
            this.classFileRecorder = DEFAULT_CLASS_FILE_RECORDER;
            return;
        }
        Class<?> classFileRecorderClass = Class.forName(classFileRecorderClassName);
        this.classFileRecorder = (ClassFileRecorder)classFileRecorderClass.newInstance();
    }

    public void setClassFileRecorder(ClassFileRecorder classFileRecorder) {
        this.classFileRecorder = classFileRecorder == null ? DEFAULT_CLASS_FILE_RECORDER : classFileRecorder;
    }
}

