/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.marshall.jboss.DefaultContextClassResolver;
import org.infinispan.marshall.jboss.ExternalizerTable;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ObjectTable;

public final class JBossMarshaller
extends AbstractJBossMarshaller
implements StreamingMarshaller {
    ExternalizerTable externalizerTable;

    public void inject(ExternalizerTable externalizerTable, ClassLoader cl, InvocationContextContainer icc) {
        log.debug((Object)"Using JBoss Marshalling");
        this.externalizerTable = externalizerTable;
        this.baseCfg.setObjectTable((ObjectTable)externalizerTable);
        this.baseCfg.setClassResolver((ClassResolver)new EmbeddedContextClassResolver(cl, icc));
    }

    @Override
    public void stop() {
        super.stop();
        this.baseCfg.setClassResolver(null);
    }

    @Override
    public boolean isMarshallableCandidate(Object o) {
        return super.isMarshallableCandidate(o) || this.externalizerTable.isMarshallableCandidate(o);
    }

    public static final class EmbeddedContextClassResolver
    extends DefaultContextClassResolver {
        private final InvocationContextContainer icc;

        public EmbeddedContextClassResolver(ClassLoader defaultClassLoader, InvocationContextContainer icc) {
            super(defaultClassLoader);
            this.icc = icc;
        }

        @Override
        protected ClassLoader getClassLoader() {
            ClassLoader cl;
            InvocationContext ctx;
            if (this.icc != null && (ctx = this.icc.getInvocationContext(true)) != null && (cl = ctx.getClassLoader()) != null) {
                return cl;
            }
            return super.getClassLoader();
        }
    }
}

