/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.spi;

import java.io.Reader;
import java.io.Serializable;
import org.apache.lucene.document.Field;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.serialization.impl.CopyTokenStream;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.spi.SerializableIndex;
import org.hibernate.search.indexes.serialization.spi.SerializableStore;
import org.hibernate.search.indexes.serialization.spi.SerializableTermVector;
import org.hibernate.search.indexes.serialization.spi.SerializableTokenStream;

public class LuceneFieldContext {
    private Field field;

    public LuceneFieldContext(Field field) {
        this.field = field;
    }

    public String getName() {
        return this.field.name();
    }

    public SerializableStore getStore() {
        return this.field.isStored() ? SerializableStore.YES : SerializableStore.NO;
    }

    public SerializableIndex getIndex() {
        Field.Index index = Field.Index.toIndex((boolean)this.field.isIndexed(), (boolean)this.field.isTokenized(), (boolean)this.field.getOmitNorms());
        switch (index) {
            case ANALYZED: {
                return SerializableIndex.ANALYZED;
            }
            case ANALYZED_NO_NORMS: {
                return SerializableIndex.ANALYZED_NO_NORMS;
            }
            case NO: {
                return SerializableIndex.NO;
            }
            case NOT_ANALYZED: {
                return SerializableIndex.NOT_ANALYZED;
            }
            case NOT_ANALYZED_NO_NORMS: {
                return SerializableIndex.NOT_ANALYZED_NO_NORMS;
            }
        }
        throw new SearchException("Unable to convert Field.Index value into serializable Index: " + index);
    }

    public SerializableTermVector getTermVector() {
        Field.TermVector vector = Field.TermVector.toTermVector((boolean)this.field.isTermVectorStored(), (boolean)this.field.isStoreOffsetWithTermVector(), (boolean)this.field.isStorePositionWithTermVector());
        switch (vector) {
            case NO: {
                return SerializableTermVector.NO;
            }
            case WITH_OFFSETS: {
                return SerializableTermVector.WITH_OFFSETS;
            }
            case WITH_POSITIONS: {
                return SerializableTermVector.WITH_POSITIONS;
            }
            case WITH_POSITIONS_OFFSETS: {
                return SerializableTermVector.WITH_POSITIONS_OFFSETS;
            }
            case YES: {
                return SerializableTermVector.YES;
            }
        }
        throw new SearchException("Unable to convert Field.TermVector value into serializable TermVector: " + vector);
    }

    public float getBoost() {
        return this.field.getBoost();
    }

    public boolean isOmitNorms() {
        return this.field.getOmitNorms();
    }

    public boolean isOmitTermFreqAndPositions() {
        return this.field.getOmitTermFreqAndPositions();
    }

    public String getStringValue() {
        return this.field.stringValue();
    }

    public byte[] getReaderValue() {
        Reader reader = this.field.readerValue();
        if (reader instanceof Serializable) {
            return SerializationHelper.toByteArray((Serializable)((Object)reader));
        }
        throw new AssertionFailure("Should not call getReaderValue for a non Serializable Reader");
    }

    public SerializableTokenStream getTokenStream() {
        return CopyTokenStream.buildSerializabletokenStream(this.field.tokenStreamValue());
    }

    public byte[] getBinaryValue() {
        return this.field.getBinaryValue();
    }

    public int getBinaryOffset() {
        return this.field.getBinaryOffset();
    }

    public int getBinaryLength() {
        return this.field.getBinaryLength();
    }
}

