/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.text;

import org.junit.Test;
import org.modeshape.sequencer.text.AbstractTextSequencerTest;

public class FixedWidthTextSequencerTest
extends AbstractTextSequencerTest {
    @Test
    public void shouldSequenceFixedWidthFileWithOneLine() throws Exception {
        String filename = "oneLineFixedWidthFile.txt";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertRows(filePath, 1, TEST_COLUMNS);
    }

    @Test
    public void shouldSequenceFixedWidthFileWithOneLineAndNoTrailingNewLine() throws Exception {
        String filename = "oneLineFixedWidthFileNoTrailingNewLine.txt";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertRows(filePath, 1, TEST_COLUMNS);
    }

    @Test
    public void shouldSequenceFixedWidthFileWithMultipleLines() throws Exception {
        String filename = "multiLineFixedWidthFile.txt";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertRows(filePath, 6, TEST_COLUMNS);
    }

    @Test
    public void shouldSequenceFixedWidthFileWithMultipleLinesAndMissingRecords() throws Exception {
        String filename = "multiLineFixedWidthFileMissingRecords.txt";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertFileWithMissingRecords(filePath);
    }

    @Test
    public void shouldSequenceFixedWidthFileWithCustomRowFactory() throws Exception {
        String filename = "multiLineFixedWidthFile.txt";
        this.createNodeWithContentFromFile("customrowfactory/" + filename, this.getTestFilePath(filename));
        String sequencedRootPath = "fixed/customrowfactory/" + filename;
        this.assertRowsWithCustomRowFactory(sequencedRootPath);
    }

    @Test
    public void shouldSequenceFixedWidthFileWithComments() throws Exception {
        String filename = "multiLineFixedWidthFileWithComments.txt";
        String filePath = this.getTestFilePath(filename);
        this.createNodeWithContentFromFile(filename, filePath);
        this.assertRows(filePath, 4, TEST_COLUMNS);
    }

    private String getTestFilePath(String filename) {
        return "fixed/" + filename;
    }
}

