/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class ClassBridge
implements TwoWayStringBridge {
    @Override
    public Object stringToObject(String stringValue) {
        if (StringHelper.isEmpty((String)stringValue)) {
            return null;
        }
        try {
            return ClassLoaderHelper.classForName(stringValue, ClassBridge.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to deserialize Class: " + stringValue, e);
        }
    }

    @Override
    public String objectToString(Object object) {
        return object == null ? null : ((Class)object).getName();
    }
}

