/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class DataSourceProvider
extends AbstractEntityProvider<DataSource> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSource readDataSource(InputStream in, MediaType mediaType) throws IOException {
        byte[] memoryBuffer = new byte[4096];
        int readCount = in.read(memoryBuffer, 0, memoryBuffer.length);
        File tempFile = null;
        if (in.available() > 0) {
            tempFile = File.createTempFile("resteasy-provider-datasource", null);
            FileOutputStream fos = new FileOutputStream(tempFile);
            try {
                ProviderHelper.writeTo(in, fos);
            }
            finally {
                fos.close();
            }
        }
        if (readCount == -1) {
            readCount = 0;
        }
        return new SequencedDataSource(memoryBuffer, 0, readCount, tempFile, mediaType.toString());
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    @Override
    public DataSource readFrom(Class<DataSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return DataSourceProvider.readDataSource(entityStream, mediaType);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(DataSource dataSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        InputStream in = dataSource.getInputStream();
        try {
            ProviderHelper.writeTo(in, entityStream);
        }
        finally {
            in.close();
        }
    }

    protected static class SequencedDataSource
    implements DataSource {
        private byte[] byteBuffer;
        private int byteBufferOffset;
        private int byteBufferLength;
        private File tempFile;
        private String type;

        public SequencedDataSource(byte[] byteBuffer, int byteBufferOffset, int byteBufferLength, File tempFile, String type) {
            this.byteBuffer = byteBuffer;
            this.byteBufferOffset = byteBufferOffset;
            this.byteBufferLength = byteBufferLength;
            this.tempFile = tempFile;
            this.type = type;
        }

        public String getContentType() {
            return this.type;
        }

        public InputStream getInputStream() throws IOException {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.byteBuffer, this.byteBufferOffset, this.byteBufferLength);
            if (this.tempFile == null) {
                return bis;
            }
            FileInputStream fis = new FileInputStream(this.tempFile);
            return new SequenceInputStream(bis, fis);
        }

        public String getName() {
            return "";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("No output stream allowed");
        }
    }
}

