/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.api.text;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.Logger;

public abstract class TextExtractor {
    private Logger logger;
    private String name;

    public abstract boolean supportsMimeType(String var1);

    public abstract void extractFrom(Binary var1, Output var2, Context var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T processStream(Binary binary, BinaryOperation<T> operation) throws Exception {
        InputStream stream = binary.getStream();
        if (stream == null) {
            throw new IllegalArgumentException("The binary value is empty");
        }
        try {
            T t = operation.execute(stream);
            return t;
        }
        finally {
            stream.close();
        }
    }

    public final void setLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Logger cannot be null");
        }
        this.logger = logger;
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static interface Output {
        public void recordText(String var1);
    }

    public static interface Context {
        public String mimeTypeOf(String var1, Binary var2) throws RepositoryException, IOException;
    }

    protected static interface BinaryOperation<T> {
        public T execute(InputStream var1) throws Exception;
    }
}

