/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.util.ArrayList;
import javax.jcr.Repository;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.web.jcr.RepositoryManager;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.model.RestRepositories;

public class RestServerHandler
extends AbstractHandler {
    public RestRepositories getRepositories(HttpServletRequest request) {
        RestRepositories repositories = new RestRepositories();
        for (String repositoryName : RepositoryManager.getJcrRepositoryNames()) {
            this.addRepository(request, repositories, repositoryName);
        }
        return repositories;
    }

    private void addRepository(HttpServletRequest request, RestRepositories repositories, String repositoryName) {
        RestRepositories.Repository repository = repositories.addRepository(repositoryName, RestHelper.urlFrom(request, repositoryName));
        try {
            Repository jcrRepository = RepositoryManager.getRepository((String)repositoryName);
            for (String metadataKey : jcrRepository.getDescriptorKeys()) {
                Value[] descriptorValues = jcrRepository.getDescriptorValues(metadataKey);
                if (descriptorValues == null) continue;
                ArrayList<String> values = new ArrayList<String>(descriptorValues.length);
                for (Value descriptorValue : descriptorValues) {
                    values.add(descriptorValue.getString());
                }
                repository.addMetadata(metadataKey, values);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, e.getMessage(), new Object[0]);
        }
    }
}

