/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.modeshape.jcr.query.process.DelegatingComponent;
import org.modeshape.jcr.query.process.ProcessingComponent;

public class SortLocationsComponent
extends DelegatingComponent {
    private Comparator<Object[]> sortingComparator;

    public SortLocationsComponent(ProcessingComponent delegate) {
        super(delegate);
        this.sortingComparator = this.createSortComparator(delegate.getContext(), delegate.getColumns());
    }

    public SortLocationsComponent(ProcessingComponent delegate, Comparator<Object[]> sortingComparator) {
        super(delegate);
        this.sortingComparator = sortingComparator;
    }

    @Override
    public List<Object[]> execute() {
        List<Object[]> tuples = this.delegate().execute();
        if (tuples.size() > 1) {
            Collections.sort(tuples, this.sortingComparator);
        }
        return tuples;
    }
}

