/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Principal;
import java.util.Calendar;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.util.IoUtil;
import org.modeshape.web.jcr.ModeShapeJcrDeployer;
import org.modeshape.web.jcr.RepositoryManager;
import org.modeshape.web.jcr.webdav.ContentMapper;
import org.modeshape.web.jcr.webdav.DefaultContentMapper;
import org.modeshape.web.jcr.webdav.ModeShapeWebdavStore;
import org.modeshape.web.jcr.webdav.RequestResolver;
import org.modeshape.web.jcr.webdav.SingleRepositoryRequestResolver;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;

public class ModeShapeWebdavStoreTest {
    private static final String TEST_ROOT = "testRoot";
    private static final String TEST_ROOT_PATH = "/testRoot";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String REPOSITORY_NAME = "repo";
    private static final String WORKSPACE_NAME = "default";
    private static ServletContextListener contextListener = new ModeShapeJcrDeployer();
    @Mock
    private static ServletContextEvent event;
    private IWebdavStore store;
    private ModeShapeWebdavStore.JcrSessionTransaction tx;
    private Session session;
    @Mock
    private Principal principal;
    @Mock
    private HttpServletRequest request;
    @Mock
    private ServletContext context;
    private Node testRoot;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.principal.getName()).thenReturn((Object)"testuser");
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)this.principal);
        Mockito.when((Object)this.request.isUserInRole("readwrite")).thenReturn((Object)true);
        Mockito.when((Object)this.context.getInitParameter("org.modeshape.jcr.URL")).thenReturn((Object)"file:///repository-config.json");
        Mockito.when((Object)this.context.getInitParameter("org.modeshape.web.jcr.webdav.SINGLE_REPOSITORY_RESOLVER_REPOSITORY_NAME")).thenReturn((Object)REPOSITORY_NAME);
        Mockito.when((Object)this.context.getInitParameter("org.modeshape.web.jcr.webdav.SINGLE_REPOSITORY_RESOLVER_WORKSPACE_NAME")).thenReturn((Object)WORKSPACE_NAME);
        Mockito.when((Object)event.getServletContext()).thenReturn((Object)this.context);
        SingleRepositoryRequestResolver uriResolver = new SingleRepositoryRequestResolver();
        uriResolver.initialize(this.context);
        DefaultContentMapper contentMapper = new DefaultContentMapper();
        contentMapper.initialize(this.context);
        this.store = new ModeShapeWebdavStore((RequestResolver)uriResolver, (ContentMapper)contentMapper);
        contextListener.contextInitialized(event);
        ModeShapeWebdavStore.setRequest((HttpServletRequest)this.request);
        this.session = RepositoryManager.getSession((HttpServletRequest)this.request, (String)REPOSITORY_NAME, (String)WORKSPACE_NAME);
        this.testRoot = this.session.getRootNode().addNode(TEST_ROOT);
        this.session.save();
        this.tx = (ModeShapeWebdavStore.JcrSessionTransaction)this.store.begin(this.principal);
        Assert.assertThat((Object)this.tx.owns(this.session), (Matcher)Is.is((Object)false));
    }

    @After
    public void afterEach() throws Exception {
        ModeShapeWebdavStore.setRequest(null);
        this.testRoot.remove();
        this.session.save();
        this.session.logout();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        contextListener.contextDestroyed(event);
    }

    @Test
    public void shouldBeginTransaction() throws Exception {
        Assert.assertThat((Object)this.tx, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCommitTransaction() throws Exception {
        this.store.commit((ITransaction)this.tx);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCommitNullTransaction() throws Exception {
        this.store.commit(null);
    }

    private void compareChildrenWithSession(String[] children, String path) throws Exception {
        LinkedList<String> sessChildren = new LinkedList<String>();
        Node node = (Node)this.session.getItem(path);
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            sessChildren.add(iter.nextNode().getName());
        }
        Assert.assertThat((Object)children, (Matcher)Is.is((Object)sessChildren.toArray(EMPTY_STRING_ARRAY)));
    }

    @Test
    public void shouldListFilesAtRoot() throws Exception {
        String[] children = this.store.getChildrenNames((ITransaction)this.tx, "/");
        this.compareChildrenWithSession(children, "/");
    }

    @Test
    public void shouldAddFolderAtRoot() throws Exception {
        String[] children = this.store.getChildrenNames((ITransaction)this.tx, "/");
        this.store.createFolder((ITransaction)this.tx, "/testRoot/newFolder");
        this.compareChildrenWithSession(children, "/");
        this.store.commit((ITransaction)this.tx);
        this.session.refresh(false);
        this.compareChildrenWithSession(this.store.getChildrenNames((ITransaction)this.tx, "/"), "/");
    }

    @Test
    public void shouldAddFileAtRoot() throws Exception {
        String[] children = this.store.getChildrenNames((ITransaction)this.tx, "/");
        this.store.createResource((ITransaction)this.tx, "/testRoot/newFile");
        this.compareChildrenWithSession(children, "/");
        this.store.commit((ITransaction)this.tx);
        this.session.refresh(false);
        this.compareChildrenWithSession(this.store.getChildrenNames((ITransaction)this.tx, "/"), "/");
    }

    @Test
    public void shouldReadFileLengthAndContent() throws Exception {
        String TEST_STRING = "This is my miraculous test string!";
        Node fileNode = this.testRoot.addNode("newFile", "nt:file");
        Node contentNode = fileNode.addNode("jcr:content", "mode:resource");
        contentNode.setProperty("jcr:data", "This is my miraculous test string!");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:encoding", "UTF-8");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/testRoot/newFile");
        Assert.assertThat((Object)((int)this.store.getResourceLength((ITransaction)this.tx, "/testRoot/newFile")), (Matcher)Is.is((Object)"This is my miraculous test string!".length()));
        InputStream is = this.store.getResourceContent((ITransaction)this.tx, "/testRoot/newFile");
        String webdavContent = IoUtil.read((InputStream)is);
        Assert.assertThat((Object)webdavContent, (Matcher)Is.is((Object)"This is my miraculous test string!"));
    }

    @Test
    public void shouldRemoveFile() throws Exception {
        String TEST_STRING = "This is my miraculous test string!";
        Node fileNode = this.testRoot.addNode("newFile", "nt:file");
        Node contentNode = fileNode.addNode("jcr:content", "mode:resource");
        contentNode.setProperty("jcr:data", "This is my miraculous test string!");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:encoding", "UTF-8");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/testRoot/newFile");
        this.store.removeObject((ITransaction)this.tx, "/testRoot/newFile");
        this.store.commit((ITransaction)this.tx);
        this.session.refresh(false);
        Assert.assertThat((Object)this.testRoot.hasNode("newFile"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSimulateAddingFileThroughWebdav() throws Exception {
        String TEST_STRING = "This is my miraculous test string!";
        String TEST_URI = "/testRoot/TestFile.rtf";
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"");
        this.store.getStoredObject((ITransaction)this.tx, "");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/testRoot/TestFile.rtf");
        this.store.getStoredObject((ITransaction)this.tx, "/testRoot/TestFile.rtf");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/");
        this.store.createResource((ITransaction)this.tx, "/testRoot/TestFile.rtf");
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/testRoot/TestFile.rtf");
        long length = this.store.setResourceContent((ITransaction)this.tx, "/testRoot/TestFile.rtf", (InputStream)new ByteArrayInputStream("This is my miraculous test string!".getBytes()), "text/plain", "UTF-8");
        Assert.assertThat((Object)((int)length), (Matcher)Is.is((Object)"This is my miraculous test string!".getBytes().length));
        StoredObject ob = this.store.getStoredObject((ITransaction)this.tx, "/testRoot/TestFile.rtf");
        Assert.assertThat((Object)ob, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }
}

