/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddFileSystemIndexStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddSlaveFileSystemIndexStorage
extends AbstractAddFileSystemIndexStorage {
    public static final AddSlaveFileSystemIndexStorage INSTANCE = new AddSlaveFileSystemIndexStorage();

    private AddSlaveFileSystemIndexStorage() {
    }

    @Override
    protected void writeIndexingBackendConfiguration(OperationContext context, ModelNode storage, EditableDocument backend) throws OperationFailedException {
        backend.set("type", (Object)"jms-slave");
        String connJndi = ModelAttributes.CONNECTION_FACTORY_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        String queueJndi = ModelAttributes.QUEUE_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        backend.set("connectionFactoryJndiName", (Object)connJndi);
        backend.set("queueJndiName", (Object)queueJndi);
    }

    @Override
    protected void writeIndexStorageConfiguration(OperationContext context, ModelNode storage, EditableDocument indexStorage) throws OperationFailedException {
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, storage).asString();
        String path = ModelAttributes.PATH.resolveModelAttribute(context, storage).asString();
        String accessType = ModelAttributes.ACCESS_TYPE.resolveModelAttribute(context, storage).asString();
        String locking = ModelAttributes.LOCKING_STRATEGY.resolveModelAttribute(context, storage).asString();
        String sourceRelativeTo = ModelAttributes.SOURCE_RELATIVE_TO.resolveModelAttribute(context, storage).asString();
        String sourcePath = ModelAttributes.SOURCE_PATH.resolveModelAttribute(context, storage).asString();
        int refresh = ModelAttributes.REFRESH_PERIOD.resolveModelAttribute(context, storage).asInt();
        int copyBufferSize = ModelAttributes.COPY_BUFFER_SIZE.resolveModelAttribute(context, storage).asInt();
        int retryLookup = ModelAttributes.RETRY_MARKER_LOOKUP.resolveModelAttribute(context, storage).asInt();
        int retryPeriod = ModelAttributes.RETRY_INITIALIZE_PERIOD.resolveModelAttribute(context, storage).asInt();
        if (storage.has("relative-to") && storage.get("relative-to").asString().contains("jboss.server.data.dir")) {
            this.setIndexStoragePathInDataDirectory(path);
        }
        if (storage.has("source-relative-to") && storage.get("source-relative-to").asString().contains("jboss.server.data.dir")) {
            this.setIndexSourcePathInDataDirectory(sourcePath);
        }
        path = relativeTo + path;
        sourcePath = sourceRelativeTo + sourcePath;
        indexStorage.set("type", (Object)"filesystem-slave");
        indexStorage.set("location", (Object)path);
        indexStorage.set("lockingStrategy", (Object)locking.toLowerCase());
        indexStorage.set("fileSystemAccessType", (Object)accessType.toLowerCase());
        indexStorage.set("refreshInSeconds", (Object)refresh);
        indexStorage.set("sourceLocation", (Object)sourcePath);
        indexStorage.set("copyBufferSizeInMegabytes", (Object)copyBufferSize);
        indexStorage.set("retryInitializePeriodInSeconds", (Object)retryPeriod);
        indexStorage.set("retryMarkerLookup", (Object)retryLookup);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddSlaveFileSystemIndexStorage.populate(operation, model, "slave-file-index-storage", ModelAttributes.SLAVE_FILE_INDEX_STORAGE_ATTRIBUTES);
    }
}

