/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

public class RemoveSource
extends AbstractRemoveStepHandler {
    static final RemoveSource INSTANCE = new RemoveSource();
    private static final Logger LOGGER = Logger.getLogger((String)RemoveSource.class.getPackage().getName());

    private RemoveSource() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress serviceAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String sourceName = serviceAddress.getLastElement().getValue();
        String repositoryName = serviceAddress.getElement(1).getValue();
        ServiceName serviceName = ModeShapeServiceNames.sourceServiceName(repositoryName, sourceName);
        context.removeService(serviceName);
        LOGGER.debugf("sequencer '%s' removed for repository '%s'", (Object)sourceName, (Object)repositoryName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

