/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.jcr.JcrConverter;
import org.apache.chemistry.opencmis.jcr.JcrDocument;
import org.apache.chemistry.opencmis.jcr.JcrFolder;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersionBase;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.PropertyHelper;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.apache.chemistry.opencmis.jcr.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JcrNode {
    private static final Log log = LogFactory.getLog(JcrNode.class);
    public static final String USER_UNKNOWN = "unknown";
    public static final GregorianCalendar DATE_UNKNOWN = new GregorianCalendar();
    private final Node node;
    protected final JcrTypeManager typeManager;
    protected final PathManager pathManager;
    protected final JcrTypeHandlerManager typeHandlerManager;

    protected JcrNode(Node node, JcrTypeManager typeManager, PathManager pathManager, JcrTypeHandlerManager typeHandlerManager) {
        this.node = node;
        this.typeManager = typeManager;
        this.pathManager = pathManager;
        this.typeHandlerManager = typeHandlerManager;
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() {
        try {
            return this.getNodeName();
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public String getId() {
        try {
            return this.getObjectId();
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public String getTypeId() {
        return this.getTypeIdInternal();
    }

    public boolean isRoot() {
        return this.pathManager.isRoot(this.node);
    }

    public boolean isDocument() {
        return BaseTypeId.CMIS_DOCUMENT == this.getBaseTypeId();
    }

    public boolean isFolder() {
        return BaseTypeId.CMIS_FOLDER == this.getBaseTypeId();
    }

    public boolean isVersionable() {
        TypeDefinition typeDef = this.typeManager.getType(this.getTypeIdInternal());
        return typeDef instanceof DocumentTypeDefinition ? ((DocumentTypeDefinition)typeDef).isVersionable() : false;
    }

    public JcrDocument asDocument() {
        if (this.isDocument()) {
            return (JcrDocument)this;
        }
        throw new CmisConstraintException("Not a document: " + this);
    }

    public JcrFolder asFolder() {
        if (this.isFolder()) {
            return (JcrFolder)this;
        }
        throw new CmisObjectNotFoundException("Not a folder: " + this);
    }

    public JcrVersionBase asVersion() {
        if (this.isVersionable()) {
            return (JcrVersionBase)this;
        }
        throw new CmisObjectNotFoundException("Not a version: " + this);
    }

    public JcrNode getNode(String path) {
        try {
            return this.create(this.node.getNode(path));
        }
        catch (PathNotFoundException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public ObjectData compileObjectType(Set<String> filter, Boolean includeAllowableActions, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        try {
            ObjectDataImpl result = new ObjectDataImpl();
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            PropertiesImpl properties = new PropertiesImpl();
            filter = filter == null ? null : new HashSet<String>(filter);
            this.compileProperties(properties, filter, objectInfo);
            result.setProperties((Properties)properties);
            if (filter != null && !filter.isEmpty()) {
                log.debug((Object)("Unknown filter properties: " + ((Object)filter).toString()));
            }
            if (Boolean.TRUE.equals(includeAllowableActions)) {
                result.setAllowableActions(this.getAllowableActions());
            }
            if (requiresObjectInfo) {
                objectInfo.setObject((ObjectData)result);
                objectInfos.addObjectInfo((ObjectInfo)objectInfo);
            }
            return result;
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public AllowableActions getAllowableActions() {
        AllowableActionsImpl aas = new AllowableActionsImpl();
        aas.setAllowableActions(this.compileAllowableActions(new HashSet<Action>()));
        return aas;
    }

    public JcrFolder getParent() {
        try {
            return this.create(this.node.getParent()).asFolder();
        }
        catch (ItemNotFoundException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrNode updateProperties(Properties properties) {
        boolean rename;
        String newName = PropertyHelper.getStringProperty(properties, "cmis:name");
        boolean bl = rename = newName != null && !this.getName().equals(newName);
        if (rename && !JcrConverter.isValidJcrName(newName)) {
            throw new CmisNameConstraintViolationException("Name is not valid: " + newName);
        }
        if (rename && this.isRoot()) {
            throw new CmisUpdateConflictException("Cannot rename root node");
        }
        try {
            Node newNode;
            Session session = this.getNode().getSession();
            if (rename) {
                String destPath = PathManager.createCmisPath(this.node.getParent().getPath(), newName);
                session.move(this.node.getPath(), destPath);
                newNode = session.getNode(destPath);
            } else {
                newNode = this.node;
            }
            PropertyUpdater propertyUpdater = PropertyUpdater.create(this.typeManager, this.getTypeId(), properties);
            JcrVersionBase jcrVersion = this.isVersionable() ? this.asVersion() : null;
            boolean autoCheckout = false;
            if (!propertyUpdater.isEmpty()) {
                boolean bl2 = autoCheckout = jcrVersion != null && !jcrVersion.isCheckedOut();
                if (autoCheckout) {
                    jcrVersion.checkout();
                }
                propertyUpdater.apply(this.node);
            }
            session.save();
            if (autoCheckout) {
                return jcrVersion.checkin(null, null, "auto checkout");
            }
            if (jcrVersion != null && jcrVersion.isCheckedOut()) {
                JcrVersionBase jcrNewVersion = this.create(newNode).asVersion();
                return jcrNewVersion.getPwc();
            }
            return this.create(newNode);
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(boolean allVersions, boolean isPwc) {
        try {
            Session session = this.getNode().getSession();
            this.getNode().remove();
            session.save();
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrNode move(JcrFolder parent) {
        try {
            Node newNode;
            String destPath = PathManager.createCmisPath(parent.getNode().getPath(), this.node.getName());
            String srcPath = this.node.getPath();
            if (srcPath.equals(destPath)) {
                newNode = this.node;
            } else {
                Session session = this.getNode().getSession();
                session.move(srcPath, destPath);
                newNode = session.getNode(destPath);
                session.save();
            }
            return this.create(newNode);
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    protected abstract Node getContextNode() throws RepositoryException;

    protected abstract BaseTypeId getBaseTypeId();

    protected abstract String getTypeIdInternal();

    protected void compileProperties(PropertiesImpl properties, Set<String> filter, ObjectInfoImpl objectInfo) throws RepositoryException {
        String typeId = this.getTypeIdInternal();
        BaseTypeId baseTypeId = this.getBaseTypeId();
        objectInfo.setBaseType(baseTypeId);
        objectInfo.setTypeId(typeId);
        objectInfo.setHasAcl(false);
        objectInfo.setVersionSeriesId(this.getVersionSeriesId());
        objectInfo.setRelationshipSourceIds(null);
        objectInfo.setRelationshipTargetIds(null);
        objectInfo.setRenditionInfos(null);
        objectInfo.setSupportsPolicies(false);
        objectInfo.setSupportsRelationships(false);
        String objectId = this.getObjectId();
        this.addPropertyId(properties, typeId, filter, "cmis:objectId", objectId);
        objectInfo.setId(objectId);
        String name = this.getNodeName();
        this.addPropertyString(properties, typeId, filter, "cmis:name", name);
        objectInfo.setName(name);
        this.addPropertyId(properties, typeId, filter, "cmis:baseTypeId", baseTypeId.value());
        this.addPropertyId(properties, typeId, filter, "cmis:objectTypeId", typeId);
        String createdBy = this.getCreatedBy();
        this.addPropertyString(properties, typeId, filter, "cmis:createdBy", createdBy);
        objectInfo.setCreatedBy(createdBy);
        this.addPropertyString(properties, typeId, filter, "cmis:lastModifiedBy", this.getLastModifiedBy());
        GregorianCalendar created = this.getCreated();
        this.addPropertyDateTime(properties, typeId, filter, "cmis:creationDate", created);
        objectInfo.setCreationDate(created);
        GregorianCalendar lastModified = this.getLastModified();
        this.addPropertyDateTime(properties, typeId, filter, "cmis:lastModificationDate", lastModified);
        objectInfo.setLastModificationDate(lastModified);
        this.addPropertyString(properties, typeId, filter, "cmis:changeToken", this.getChangeToken());
    }

    protected Set<Action> compileAllowableActions(Set<Action> aas) {
        JcrNode.setAction(aas, Action.CAN_GET_OBJECT_PARENTS, true);
        JcrNode.setAction(aas, Action.CAN_GET_PROPERTIES, true);
        JcrNode.setAction(aas, Action.CAN_UPDATE_PROPERTIES, true);
        JcrNode.setAction(aas, Action.CAN_MOVE_OBJECT, true);
        JcrNode.setAction(aas, Action.CAN_DELETE_OBJECT, true);
        JcrNode.setAction(aas, Action.CAN_GET_ACL, false);
        JcrNode.setAction(aas, Action.CAN_APPLY_ACL, false);
        JcrNode.setAction(aas, Action.CAN_GET_OBJECT_RELATIONSHIPS, false);
        JcrNode.setAction(aas, Action.CAN_ADD_OBJECT_TO_FOLDER, false);
        JcrNode.setAction(aas, Action.CAN_REMOVE_OBJECT_FROM_FOLDER, false);
        JcrNode.setAction(aas, Action.CAN_APPLY_POLICY, false);
        JcrNode.setAction(aas, Action.CAN_GET_APPLIED_POLICIES, false);
        JcrNode.setAction(aas, Action.CAN_REMOVE_POLICY, false);
        JcrNode.setAction(aas, Action.CAN_CREATE_RELATIONSHIP, false);
        return aas;
    }

    protected String getChangeToken() throws RepositoryException {
        return null;
    }

    protected String getLastModifiedBy() throws RepositoryException {
        return JcrNode.getPropertyOrElse(this.getContextNode(), "{http://www.jcp.org/jcr/1.0}lastModifiedBy", USER_UNKNOWN);
    }

    protected GregorianCalendar getLastModified() throws RepositoryException {
        return JcrNode.getPropertyOrElse(this.getContextNode(), "{http://www.jcp.org/jcr/1.0}lastModified", DATE_UNKNOWN);
    }

    protected GregorianCalendar getCreated() throws RepositoryException {
        return JcrNode.getPropertyOrElse(this.getContextNode(), "{http://www.jcp.org/jcr/1.0}created", DATE_UNKNOWN);
    }

    protected String getCreatedBy() throws RepositoryException {
        return JcrNode.getPropertyOrElse(this.getContextNode(), "{http://www.jcp.org/jcr/1.0}createdBy", USER_UNKNOWN);
    }

    protected String getNodeName() throws RepositoryException {
        return this.node.getName();
    }

    protected String getObjectId() throws RepositoryException {
        return this.getVersionSeriesId();
    }

    protected String getVersionSeriesId() throws RepositoryException {
        return this.node.getIdentifier();
    }

    protected final JcrNode create(Node node) {
        return this.typeHandlerManager.create(node);
    }

    protected final void addPropertyId(PropertiesImpl props, String typeId, Set<String> filter, String id, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null!");
        }
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        PropertyIdImpl prop = new PropertyIdImpl(id, value);
        prop.setQueryName(id);
        props.addProperty((PropertyData)prop);
    }

    protected final void addPropertyString(PropertiesImpl props, String typeId, Set<String> filter, String id, String value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        PropertyStringImpl prop = new PropertyStringImpl(id, value);
        prop.setQueryName(id);
        props.addProperty((PropertyData)prop);
    }

    protected final void addPropertyInteger(PropertiesImpl props, String typeId, Set<String> filter, String id, long value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        PropertyIntegerImpl prop = new PropertyIntegerImpl(id, BigInteger.valueOf(value));
        prop.setQueryName(id);
        props.addProperty((PropertyData)prop);
    }

    protected final void addPropertyBoolean(PropertiesImpl props, String typeId, Set<String> filter, String id, boolean value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        PropertyBooleanImpl prop = new PropertyBooleanImpl(id, Boolean.valueOf(value));
        prop.setQueryName(id);
        props.addProperty((PropertyData)prop);
    }

    protected final void addPropertyDateTime(PropertiesImpl props, String typeId, Set<String> filter, String id, GregorianCalendar value) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id)) {
            return;
        }
        PropertyDateTimeImpl prop = new PropertyDateTimeImpl(id, value);
        prop.setQueryName(id);
        props.addProperty((PropertyData)prop);
    }

    protected final boolean checkAddProperty(Properties properties, String typeId, Set<String> filter, String id) {
        if (properties == null || properties.getProperties() == null) {
            throw new IllegalArgumentException("Properties must not be null!");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null!");
        }
        TypeDefinition type = this.typeManager.getType(typeId);
        if (type == null) {
            throw new IllegalArgumentException("Unknown type: " + typeId);
        }
        if (!type.getPropertyDefinitions().containsKey(id)) {
            throw new IllegalArgumentException("Unknown property: " + id);
        }
        String queryName = ((PropertyDefinition)type.getPropertyDefinitions().get(id)).getQueryName();
        if (queryName != null && filter != null) {
            if (filter.contains(queryName)) {
                filter.remove(queryName);
            } else {
                return false;
            }
        }
        return true;
    }

    protected final void updateProperties(Node node, String typeId, Properties properties) {
        PropertyUpdater.create(this.typeManager, typeId, properties).apply(node);
    }

    protected static VersionHistory getVersionHistory(Node node) throws RepositoryException {
        return JcrNode.getVersionManager(node).getVersionHistory(node.getPath());
    }

    protected static VersionManager getVersionManager(Node node) throws RepositoryException {
        return node.getSession().getWorkspace().getVersionManager();
    }

    protected static Version getBaseVersion(Node node) throws RepositoryException {
        return JcrNode.getVersionManager(node).getBaseVersion(node.getPath());
    }

    protected static long getPropertyLength(Node node, String propertyName) throws RepositoryException {
        return node.hasProperty(propertyName) ? node.getProperty(propertyName).getLength() : -1L;
    }

    protected static String getPropertyOrElse(Node node, String propertyName, String defaultValue) throws RepositoryException {
        return node.hasProperty(propertyName) ? node.getProperty(propertyName).getString() : defaultValue;
    }

    protected static GregorianCalendar getPropertyOrElse(Node node, String propertyName, GregorianCalendar defaultValue) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            Calendar date = node.getProperty(propertyName).getDate();
            return Util.toCalendar(date);
        }
        return defaultValue;
    }

    protected static void setAction(Set<Action> actions, Action action, boolean condition) {
        if (condition) {
            actions.add(action);
        } else {
            actions.remove(action);
        }
    }

    static {
        DATE_UNKNOWN.setTimeInMillis(0L);
    }

    protected static final class PropertyUpdater {
        private final List<PropertyData<?>> removeProperties = new ArrayList();
        private final List<PropertyData<?>> updateProperties = new ArrayList();

        private PropertyUpdater() {
        }

        public static PropertyUpdater create(JcrTypeManager typeManager, String typeId, Properties properties) {
            if (properties == null) {
                throw new CmisConstraintException("No properties!");
            }
            TypeDefinition type = typeManager.getType(typeId);
            if (type == null) {
                throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
            }
            PropertyUpdater propertyUpdater = new PropertyUpdater();
            for (PropertyData<?> prop : properties.getProperties().values()) {
                PropertyData<?> newProp;
                PropertyDefinition propDef = (PropertyDefinition)type.getPropertyDefinitions().get(prop.getId());
                if (propDef == null) {
                    throw new CmisInvalidArgumentException("Property '" + prop.getId() + "' is unknown!");
                }
                if (propDef.getId().equals("cmis:contentStreamFileName")) {
                    log.warn((Object)"Cannot set cmis:contentStreamFileName. Ignoring");
                    continue;
                }
                if (propDef.getId().equals("cmis:name")) continue;
                if (propDef.getUpdatability() == Updatability.READONLY) {
                    throw new CmisConstraintException("Property '" + prop.getId() + "' is readonly!");
                }
                if (propDef.getUpdatability() == Updatability.ONCREATE) {
                    throw new CmisConstraintException("Property '" + prop.getId() + "' can only be set on create!");
                }
                PropertyData<?> propertyData = newProp = PropertyHelper.isPropertyEmpty(prop) ? PropertyHelper.getDefaultValue(propDef) : prop;
                if (newProp == null) {
                    propertyUpdater.removeProperties.add(prop);
                    continue;
                }
                propertyUpdater.updateProperties.add(newProp);
            }
            return propertyUpdater;
        }

        public boolean isEmpty() {
            return this.removeProperties.isEmpty() && this.updateProperties.isEmpty();
        }

        public void apply(Node node) {
            try {
                for (PropertyData<?> prop : this.removeProperties) {
                    JcrConverter.removeProperty(node, prop);
                }
                for (PropertyData<?> prop : this.updateProperties) {
                    JcrConverter.setProperty(node, prop);
                }
            }
            catch (RepositoryException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                throw new CmisStorageException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

