/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersionBase;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JcrPrivateWorkingCopy
extends JcrVersionBase {
    private static final Log log = LogFactory.getLog(JcrPrivateWorkingCopy.class);
    public static final String PWC_NAME = "pwc";

    public JcrPrivateWorkingCopy(Node node, JcrTypeManager typeManager, PathManager pathManager, JcrTypeHandlerManager typeHandlerManager) {
        super(node, typeManager, pathManager, typeHandlerManager);
    }

    public static boolean denotesPwc(String versionName) {
        return PWC_NAME.equals(versionName);
    }

    public static boolean isPwc(String objectId) {
        return objectId.endsWith("/pwc");
    }

    protected Node getContextNode() {
        try {
            return this.getNode().getNode("{http://www.jcp.org/jcr/1.0}content");
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getPwcId() throws RepositoryException {
        return this.getObjectId();
    }

    protected String getObjectId() throws RepositoryException {
        return this.getVersionSeriesId() + '/' + PWC_NAME;
    }

    protected String getVersionLabel() throws RepositoryException {
        return PWC_NAME;
    }

    protected boolean isLatestVersion() throws RepositoryException {
        return false;
    }

    protected boolean isMajorVersion() throws RepositoryException {
        return false;
    }

    protected boolean isLatestMajorVersion() throws RepositoryException {
        return false;
    }

    protected String getCheckInComment() {
        return "";
    }
}

