/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrTypeManager
implements TypeManager {
    private static final Log log = LogFactory.getLog(JcrTypeManager.class);
    public static final String DOCUMENT_TYPE_ID = "cmis:document";
    public static final String FOLDER_TYPE_ID = "cmis:folder";
    public static final String RELATIONSHIP_TYPE_ID = "cmis:relationship";
    public static final String POLICY_TYPE_ID = "cmis:policy";
    public static final String NAMESPACE = "http://opencmis.org/jcr";
    private final Map<String, TypeDefinitionContainerImpl> fTypes = new HashMap<String, TypeDefinitionContainerImpl>();

    public boolean addType(TypeDefinition type) {
        if (type == null) {
            return false;
        }
        if (this.fTypes.containsKey(type.getId())) {
            return false;
        }
        AbstractTypeDefinition newType = (AbstractTypeDefinition)JcrTypeManager.copyTypeDefinition(type);
        if (!newType.getBaseTypeId().value().equals(newType.getId())) {
            TypeDefinition baseType;
            if (newType.getBaseTypeId() == BaseTypeId.CMIS_DOCUMENT) {
                baseType = JcrTypeManager.copyTypeDefinition(this.fTypes.get(DOCUMENT_TYPE_ID).getTypeDefinition());
            } else if (newType.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
                baseType = JcrTypeManager.copyTypeDefinition(this.fTypes.get(FOLDER_TYPE_ID).getTypeDefinition());
            } else if (newType.getBaseTypeId() == BaseTypeId.CMIS_RELATIONSHIP) {
                baseType = JcrTypeManager.copyTypeDefinition(this.fTypes.get(RELATIONSHIP_TYPE_ID).getTypeDefinition());
            } else if (newType.getBaseTypeId() == BaseTypeId.CMIS_POLICY) {
                baseType = JcrTypeManager.copyTypeDefinition(this.fTypes.get(POLICY_TYPE_ID).getTypeDefinition());
            } else {
                return false;
            }
            for (PropertyDefinition propDef : baseType.getPropertyDefinitions().values()) {
                ((AbstractPropertyDefinition)propDef).setIsInherited(Boolean.valueOf(true));
                newType.addPropertyDefinition(propDef);
            }
        }
        this.addTypeInternal(newType);
        log.info((Object)("Added type '" + newType.getId() + "'."));
        return true;
    }

    public TypeDefinition getType(String typeId) {
        TypeDefinitionContainer tc = (TypeDefinitionContainer)this.fTypes.get(typeId);
        return tc == null ? null : tc.getTypeDefinition();
    }

    public static boolean isVersionable(TypeDefinition typeDef) {
        return typeDef instanceof DocumentTypeDefinition ? ((DocumentTypeDefinition)typeDef).isVersionable() : false;
    }

    public static TypeDefinition copyTypeDefinition(TypeDefinition type) {
        return Converter.convert((CmisTypeDefinitionType)Converter.convert((TypeDefinition)type));
    }

    public TypeDefinitionList getTypeChildren(String typeId, boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        int max;
        int skip;
        TypeDefinitionListImpl result = new TypeDefinitionListImpl(new ArrayList());
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (max < 1) {
            return result;
        }
        if (typeId == null) {
            if (skip < 1) {
                result.getList().add(JcrTypeManager.copyTypeDefinition(this.fTypes.get(FOLDER_TYPE_ID).getTypeDefinition()));
                --max;
            }
            if (skip < 2 && max > 0) {
                result.getList().add(JcrTypeManager.copyTypeDefinition(this.fTypes.get(DOCUMENT_TYPE_ID).getTypeDefinition()));
            }
            result.setHasMoreItems(Boolean.valueOf(result.getList().size() + skip < 2));
            result.setNumItems(BigInteger.valueOf(2L));
        } else {
            TypeDefinitionContainer tc = (TypeDefinitionContainer)this.fTypes.get(typeId);
            if (tc == null || tc.getChildren() == null) {
                return result;
            }
            for (TypeDefinitionContainer child : tc.getChildren()) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                result.getList().add(JcrTypeManager.copyTypeDefinition(child.getTypeDefinition()));
                if (--max != 0) continue;
                break;
            }
            result.setHasMoreItems(Boolean.valueOf(result.getList().size() + skip < tc.getChildren().size()));
            result.setNumItems(BigInteger.valueOf(tc.getChildren().size()));
        }
        if (!includePropertyDefinitions) {
            for (TypeDefinition type : result.getList()) {
                type.getPropertyDefinitions().clear();
            }
        }
        return result;
    }

    public List<TypeDefinitionContainer> getTypesDescendants(String typeId, BigInteger depth, Boolean includePropertyDefinitions) {
        int d;
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>();
        int n = d = depth == null ? -1 : depth.intValue();
        if (d == 0) {
            throw new CmisInvalidArgumentException("Depth must not be 0!");
        }
        boolean ipd = Boolean.TRUE.equals(includePropertyDefinitions);
        if (typeId == null) {
            result.add(JcrTypeManager.getTypesDescendants(d, (TypeDefinitionContainer)this.fTypes.get(FOLDER_TYPE_ID), ipd));
            result.add(JcrTypeManager.getTypesDescendants(d, (TypeDefinitionContainer)this.fTypes.get(DOCUMENT_TYPE_ID), ipd));
        } else {
            TypeDefinitionContainer tc = (TypeDefinitionContainer)this.fTypes.get(typeId);
            if (tc != null) {
                result.add(JcrTypeManager.getTypesDescendants(d, tc, ipd));
            }
        }
        return result;
    }

    public TypeDefinitionContainer getTypeById(String typeId) {
        return (TypeDefinitionContainer)this.fTypes.get(typeId);
    }

    public TypeDefinition getTypeByQueryName(String typeQueryName) {
        for (TypeDefinitionContainerImpl type : this.fTypes.values()) {
            TypeDefinition typeDef = type.getTypeDefinition();
            if (!typeDef.getQueryName().equals(typeQueryName)) continue;
            return typeDef;
        }
        return null;
    }

    public Collection<TypeDefinitionContainer> getTypeDefinitionList() {
        ArrayList<TypeDefinitionContainer> types = new ArrayList<TypeDefinitionContainer>(this.fTypes.size());
        types.addAll(this.fTypes.values());
        return types;
    }

    public List<TypeDefinitionContainer> getRootTypes() {
        ArrayList<TypeDefinitionContainer> types = new ArrayList<TypeDefinitionContainer>(2);
        types.add((TypeDefinitionContainer)this.fTypes.get(FOLDER_TYPE_ID));
        types.add((TypeDefinitionContainer)this.fTypes.get(DOCUMENT_TYPE_ID));
        return types;
    }

    public String getPropertyIdForQueryName(TypeDefinition typeDefinition, String propQueryName) {
        for (PropertyDefinition pd : typeDefinition.getPropertyDefinitions().values()) {
            if (!pd.getQueryName().equals(propQueryName)) continue;
            return pd.getId();
        }
        return null;
    }

    public static void addBasePropertyDefinitions(AbstractTypeDefinition type) {
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:baseTypeId", "Base Type Id", "Base Type Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:objectId", "Object Id", "Object Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:objectTypeId", "Type Id", "Type Id", PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:name", "Name", "Name", PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:createdBy", "Created By", "Created By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:creationDate", "Creation Date", "Creation Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:lastModifiedBy", "Last Modified By", "Last Modified By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:lastModificationDate", "Last Modification Date", "Last Modification Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:changeToken", "Change Token", "Change Token", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    public static void addFolderPropertyDefinitions(FolderTypeDefinitionImpl type) {
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:parentId", "Parent Id", "Parent Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:allowedChildObjectTypeIds", "Allowed Child Object Type Ids", "Allowed Child Object Type Ids", PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:path", "Path", "Path", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    public static void addDocumentPropertyDefinitions(DocumentTypeDefinitionImpl type) {
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:isImmutable", "Is Immutable", "Is Immutable", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:isLatestVersion", "Is Latest Version", "Is Latest Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:isMajorVersion", "Is Major Version", "Is Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:isLatestMajorVersion", "Is Latest Major Version", "Is Latest Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:versionLabel", "Version Label", "Version Label", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:versionSeriesId", "Version Series Id", "Version Series Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:isVersionSeriesCheckedOut", "Is Version Series Checked Out", "Is Version Series Checked Out", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:versionSeriesCheckedOutId", "Version Series Checked Out Id", "Version Series Checked Out Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:versionSeriesCheckedOutBy", "Version Series Checked Out By", "Version Series Checked Out By", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:checkinComment", "Checkin Comment", "Checkin Comment", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:contentStreamLength", "Content Stream Length", "Content Stream Length", PropertyType.INTEGER, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:contentStreamMimeType", "MIME Type", "MIME Type", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:contentStreamFileName", "Filename", "Filename", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(JcrTypeManager.createPropDef("cmis:contentStreamId", "Content Stream Id", "Content Stream Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    public static PropertyDefinition<?> createPropDef(String id, String displayName, String description, PropertyType datatype, Cardinality cardinality, Updatability updateability, boolean inherited, boolean required) {
        PropertyBooleanDefinitionImpl result;
        switch (datatype) {
            case BOOLEAN: {
                result = new PropertyBooleanDefinitionImpl();
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeDefinitionImpl();
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalDefinitionImpl();
                break;
            }
            case HTML: {
                result = new PropertyHtmlDefinitionImpl();
                break;
            }
            case ID: {
                result = new PropertyIdDefinitionImpl();
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerDefinitionImpl();
                break;
            }
            case STRING: {
                result = new PropertyStringDefinitionImpl();
                break;
            }
            case URI: {
                result = new PropertyUriDefinitionImpl();
                break;
            }
            default: {
                throw new RuntimeException("Unknown datatype! Spec change?");
            }
        }
        result.setId(id);
        result.setLocalName(id);
        result.setDisplayName(displayName);
        result.setDescription(description);
        result.setPropertyType(datatype);
        result.setCardinality(cardinality);
        result.setUpdatability(updateability);
        result.setIsInherited(Boolean.valueOf(inherited));
        result.setIsRequired(Boolean.valueOf(required));
        result.setIsQueryable(Boolean.valueOf(false));
        result.setQueryName(id);
        return result;
    }

    private void addTypeInternal(AbstractTypeDefinition type) {
        TypeDefinitionContainerImpl tdc;
        if (type == null) {
            return;
        }
        TypeDefinitionContainerImpl tc = new TypeDefinitionContainerImpl();
        tc.setTypeDefinition((TypeDefinition)type);
        if (type.getParentTypeId() != null && (tdc = this.fTypes.get(type.getParentTypeId())) != null) {
            if (tdc.getChildren() == null) {
                tdc.setChildren(new ArrayList());
            }
            tdc.getChildren().add(tc);
        }
        this.fTypes.put(type.getId(), tc);
    }

    private static TypeDefinitionContainer getTypesDescendants(int depth, TypeDefinitionContainer tc, boolean includePropertyDefinitions) {
        TypeDefinitionContainerImpl result = new TypeDefinitionContainerImpl();
        TypeDefinition type = JcrTypeManager.copyTypeDefinition(tc.getTypeDefinition());
        if (!includePropertyDefinitions) {
            type.getPropertyDefinitions().clear();
        }
        result.setTypeDefinition(type);
        if (depth != 0 && tc.getChildren() != null) {
            result.setChildren(new ArrayList());
            for (TypeDefinitionContainer tdc : tc.getChildren()) {
                result.getChildren().add(JcrTypeManager.getTypesDescendants(depth < 0 ? -1 : depth - 1, tdc, includePropertyDefinitions));
            }
        }
        return result;
    }
}

