/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersionBase;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;

public class JcrVersion
extends JcrVersionBase {
    private static final Pattern VERSION_LABEL_PATTERN = Pattern.compile("(\\d+)(\\.(\\d+))?.*");
    private static final int GROUP_MAJOR = 1;
    private static final int GROUP_MINOR = 3;
    private final Version version;

    public JcrVersion(Node node, Version version, JcrTypeManager typeManager, PathManager pathManager, JcrTypeHandlerManager typeHandlerManager) {
        super(node, typeManager, pathManager, typeHandlerManager);
        this.version = version;
    }

    protected Node getContextNode() throws RepositoryException {
        Node frozen = this.version.getFrozenNode();
        if (frozen.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            return frozen.getNode("{http://www.jcp.org/jcr/1.0}content");
        }
        return this.getNode().getNode("{http://www.jcp.org/jcr/1.0}content");
    }

    protected String getObjectId() throws RepositoryException {
        return this.getVersionSeriesId() + '/' + this.version.getName();
    }

    protected boolean isLatestVersion() throws RepositoryException {
        Version baseVersion = JcrVersion.getBaseVersion(this.getNode());
        return baseVersion.isSame((Item)this.version);
    }

    protected boolean isMajorVersion() {
        return true;
    }

    protected boolean isLatestMajorVersion() throws RepositoryException {
        return this.isLatestVersion();
    }

    protected String getVersionLabel() throws RepositoryException {
        String name = this.version.getName();
        String major = JcrVersion.parseVersion(name, 3);
        return major == null ? name : Integer.parseInt(major) + 1 + ".0";
    }

    protected String getCheckInComment() throws RepositoryException {
        return "";
    }

    private static String parseVersion(String name, int group) {
        Matcher matcher = VERSION_LABEL_PATTERN.matcher(name);
        return matcher.matches() ? matcher.group(group) : null;
    }
}

