/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.query;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.jcr.query.Evaluator;
import org.apache.chemistry.opencmis.server.support.query.CalendarHelper;
import org.apache.chemistry.opencmis.server.support.query.PredicateWalkerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTreeWalker<T>
implements PredicateWalkerBase {
    private final Evaluator<T> evaluator;
    private T result;

    public ParseTreeWalker(Evaluator<T> evaluator) {
        this.evaluator = evaluator;
    }

    public T getResult() {
        return this.result;
    }

    public Boolean walkPredicate(Tree node) {
        this.result = null;
        this.result = this.walkPredicate(this.evaluator, node);
        return false;
    }

    protected T walkOtherExpr(Evaluator<?> evaluator, Tree node) {
        throw new CmisRuntimeException("Unknown node type: " + node.getType() + " (" + node.getText() + ")");
    }

    protected T walkOtherPredicate(Evaluator<?> evaluator, Tree node) {
        throw new CmisRuntimeException("Unknown node type: " + node.getType() + " (" + node.getText() + ")");
    }

    private T walkPredicate(Evaluator<T> evaluator, Tree node) {
        switch (node.getType()) {
            case 34: {
                return evaluator.not(this.walkPredicate(evaluator.op(), node.getChild(0)));
            }
            case 32: {
                return evaluator.and(this.walkPredicate(evaluator.op(), node.getChild(0)), this.walkPredicate(evaluator.op(), node.getChild(1)));
            }
            case 33: {
                return evaluator.or(this.walkPredicate(evaluator.op(), node.getChild(0)), this.walkPredicate(evaluator.op(), node.getChild(1)));
            }
            case 48: {
                return evaluator.eq(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 49: {
                return evaluator.neq(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 51: {
                return evaluator.gt(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 53: {
                return evaluator.gteq(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 50: {
                return evaluator.lt(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 52: {
                return evaluator.lteq(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 35: {
                return evaluator.in(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 11: {
                return evaluator.notIn(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 8: {
                return evaluator.inAny(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 9: {
                return evaluator.notInAny(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 10: {
                return evaluator.eqAny(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 13: {
                return evaluator.isNull(this.walkExpr(evaluator.op(), node.getChild(0)));
            }
            case 14: {
                return evaluator.notIsNull(this.walkExpr(evaluator.op(), node.getChild(0)));
            }
            case 36: {
                return evaluator.like(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 12: {
                return evaluator.notLike(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 38: {
                if (node.getChildCount() == 1) {
                    return evaluator.contains(null, this.walkExprTextSearch(evaluator.op(), node.getChild(0)));
                }
                return evaluator.contains(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 40: {
                if (node.getChildCount() == 1) {
                    return evaluator.inFolder(null, this.walkExpr(evaluator.op(), node.getChild(0)));
                }
                return evaluator.inFolder(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
            case 41: {
                if (node.getChildCount() == 1) {
                    return evaluator.inTree(null, this.walkExpr(evaluator.op(), node.getChild(0)));
                }
                return evaluator.inTree(this.walkExpr(evaluator.op(), node.getChild(0)), this.walkExpr(evaluator.op(), node.getChild(1)));
            }
        }
        return this.walkOtherPredicate(evaluator, node);
    }

    private T walkExpr(Evaluator<T> evaluator, Tree node) {
        switch (node.getType()) {
            case 54: {
                return this.walkBoolean(evaluator, node);
            }
            case 59: {
                return this.walkNumber(evaluator, node);
            }
            case 65: {
                return this.walkString(evaluator, node);
            }
            case 67: {
                return this.walkTimestamp(evaluator, node);
            }
            case 7: {
                return evaluator.list(this.walkList(evaluator, node));
            }
            case 5: {
                return this.walkCol(evaluator, node);
            }
        }
        return this.walkOtherExpr(evaluator, node);
    }

    private T walkExprTextSearch(Evaluator<T> evaluator, Tree node) {
        switch (node.getType()) {
            case 4: {
                return this.walkTextAnd(evaluator, node);
            }
            case 5: {
                return this.walkTextOr(evaluator, node);
            }
            case 6: {
                return this.walkTextMinus(evaluator, node);
            }
            case 15: {
                return this.walkTextWord(evaluator, node);
            }
            case 14: {
                return this.walkTextPhrase(evaluator, node);
            }
        }
        return this.walkOtherExpr(evaluator, node);
    }

    private List<T> walkList(Evaluator<T> evaluator, Tree node) {
        int n = node.getChildCount();
        ArrayList<T> result = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            result.add(this.walkExpr(evaluator.op(), node.getChild(i)));
        }
        return result;
    }

    private T walkBoolean(Evaluator<T> evaluator, Tree node) {
        String s = node.getText();
        if ("true".equalsIgnoreCase(s)) {
            return evaluator.value(true);
        }
        if ("false".equalsIgnoreCase(s)) {
            return evaluator.value(false);
        }
        throw new CmisInvalidArgumentException("Not a boolean: " + s);
    }

    private T walkNumber(Evaluator<T> evaluator, Tree node) {
        String s = node.getText();
        try {
            return s.contains(".") || s.contains("e") || s.contains("E") ? evaluator.value(Double.valueOf(s)) : evaluator.value(Long.valueOf(s));
        }
        catch (NumberFormatException e) {
            throw new CmisInvalidArgumentException("Not a number: " + s);
        }
    }

    private T walkString(Evaluator<T> evaluator, Tree node) {
        String s = node.getText();
        s = s.substring(1, s.length() - 1);
        return evaluator.value(s.replace("''", "'"));
    }

    private T walkTimestamp(Evaluator<T> evaluator, Tree node) {
        String s = node.getText();
        s = s.substring(s.indexOf(39) + 1, s.length() - 1);
        try {
            return evaluator.value(CalendarHelper.fromString((String)s));
        }
        catch (IllegalArgumentException e) {
            throw new CmisInvalidArgumentException("Not a date time value: " + s);
        }
    }

    private T walkCol(Evaluator<T> evaluator, Tree node) {
        return evaluator.col(node.getChild(0).getText());
    }

    private T walkTextAnd(Evaluator<T> evaluator, Tree node) {
        ArrayList<T> terms = new ArrayList<T>();
        for (Tree term : ParseTreeWalker.getChildrenAsList(node)) {
            terms.add(this.walkExprTextSearch(evaluator, term));
        }
        return evaluator.textAnd(terms);
    }

    private T walkTextOr(Evaluator<T> evaluator, Tree node) {
        ArrayList<T> terms = new ArrayList<T>();
        for (Tree term : ParseTreeWalker.getChildrenAsList(node)) {
            terms.add(this.walkExprTextSearch(evaluator, term));
        }
        return evaluator.textOr(terms);
    }

    private T walkTextMinus(Evaluator<T> evaluator, Tree node) {
        return evaluator.textMinus(node.getChild(0).getText());
    }

    private T walkTextWord(Evaluator<T> evaluator, Tree node) {
        return evaluator.textWord(node.getText());
    }

    private T walkTextPhrase(Evaluator<T> evaluator, Tree node) {
        return evaluator.textPhrase(node.getText());
    }

    private static List<Tree> getChildrenAsList(Tree node) {
        ArrayList<Tree> res = new ArrayList<Tree>(node.getChildCount());
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree childNode = node.getChild(i);
            res.add(childNode);
        }
        return res;
    }
}

