/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.RenditionInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AtomPubUtils {
    public static final String RESOURCE_CHILDREN = "children";
    public static final String RESOURCE_DESCENDANTS = "descendants";
    public static final String RESOURCE_FOLDERTREE = "foldertree";
    public static final String RESOURCE_TYPE = "type";
    public static final String RESOURCE_TYPES = "types";
    public static final String RESOURCE_TYPESDESC = "typedesc";
    public static final String RESOURCE_ENTRY = "entry";
    public static final String RESOURCE_PARENTS = "parents";
    public static final String RESOURCE_VERSIONS = "versions";
    public static final String RESOURCE_ALLOWABLEACIONS = "allowableactions";
    public static final String RESOURCE_ACL = "acl";
    public static final String RESOURCE_POLICIES = "policies";
    public static final String RESOURCE_RELATIONSHIPS = "relationships";
    public static final String RESOURCE_OBJECTBYID = "id";
    public static final String RESOURCE_OBJECTBYPATH = "path";
    public static final String RESOURCE_QUERY = "query";
    public static final String RESOURCE_CHECKEDOUT = "checkedout";
    public static final String RESOURCE_UNFILED = "unfiled";
    public static final String RESOURCE_CHANGES = "changes";
    public static final String RESOURCE_CONTENT = "content";
    public static final BigInteger PAGE_SIZE = BigInteger.valueOf(100L);
    public static final String TYPE_AUTHOR = "unknown";

    private AtomPubUtils() {
    }

    public static UrlBuilder compileBaseUrl(HttpServletRequest request, String repositoryId) {
        UrlBuilder url = new UrlBuilder(request.getScheme(), request.getServerName(), request.getServerPort(), null);
        url.addPath(request.getContextPath());
        url.addPath(request.getServletPath());
        if (repositoryId != null) {
            url.addPathSegment(repositoryId);
        }
        return url;
    }

    public static String compileUrl(UrlBuilder baseUrl, String resource, String id) {
        return AtomPubUtils.compileUrlBuilder(baseUrl, resource, id).toString();
    }

    public static UrlBuilder compileUrlBuilder(UrlBuilder baseUrl, String resource, String id) {
        UrlBuilder url = new UrlBuilder(baseUrl);
        url.addPathSegment(resource);
        if (id != null) {
            url.addParameter(RESOURCE_OBJECTBYID, (Object)id);
        }
        return url;
    }

    public static void writeObjectEntry(CmisService service, AtomEntry entry, ObjectData object, List<ObjectInFolderContainer> children, String repositoryId, String pathSegment, String relativePathSegment, UrlBuilder baseUrl, boolean isRoot) throws XMLStreamException, JAXBException {
        if (object == null) {
            throw new CmisRuntimeException("Object not set!");
        }
        ObjectInfo info = service.getObjectInfo(repositoryId, object.getId());
        if (info == null) {
            throw new CmisRuntimeException("Object Info not found for: " + object.getId());
        }
        entry.startEntry(isRoot);
        String contentSrc = null;
        if (info.hasContent()) {
            UrlBuilder contentSrcBuilder = AtomPubUtils.compileUrlBuilder(baseUrl, RESOURCE_CONTENT, info.getId());
            if (info.getFileName() != null) {
                contentSrcBuilder.addPathSegment(info.getFileName());
            }
            contentSrc = contentSrcBuilder.toString();
        }
        entry.writeObject(object, info, contentSrc, info.getContentType(), pathSegment, relativePathSegment);
        entry.writeServiceLink(baseUrl.toString(), repositoryId);
        entry.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ENTRY, info.getId()), info.getId());
        entry.writeEnclosureLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ENTRY, info.getId()));
        entry.writeEditLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ENTRY, info.getId()));
        entry.writeDescribedByLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_TYPE, info.getTypeId()));
        entry.writeAllowableActionsLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ALLOWABLEACIONS, info.getId()));
        if (info.hasParent()) {
            entry.writeUpLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_PARENTS, info.getId()), "application/atom+xml;type=feed");
        }
        if (info.getBaseType() == BaseTypeId.CMIS_FOLDER) {
            entry.writeDownLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_CHILDREN, info.getId()), "application/atom+xml;type=feed");
            if (info.supportsDescendants()) {
                entry.writeDownLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_DESCENDANTS, info.getId()), "application/cmistree+xml");
            }
            if (info.supportsFolderTree()) {
                entry.writeFolderTreeLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_FOLDERTREE, info.getId()));
            }
        }
        if (info.getVersionSeriesId() != null) {
            UrlBuilder vsUrl = AtomPubUtils.compileUrlBuilder(baseUrl, RESOURCE_VERSIONS, info.getId());
            vsUrl.addParameter("versionSeries", (Object)info.getVersionSeriesId());
            entry.writeVersionHistoryLink(vsUrl.toString());
        }
        if (!info.isCurrentVersion()) {
            UrlBuilder cvUrl = AtomPubUtils.compileUrlBuilder(baseUrl, RESOURCE_ENTRY, info.getId());
            cvUrl.addParameter("returnVersion", (Object)ReturnVersion.LATEST);
            entry.writeEditLink(cvUrl.toString());
        }
        if (info.getBaseType() == BaseTypeId.CMIS_DOCUMENT) {
            entry.writeEditMediaLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_CONTENT, info.getId()), info.getContentType());
        }
        if (info.getWorkingCopyId() != null) {
            entry.writeWorkingCopyLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ENTRY, info.getWorkingCopyId()));
        }
        if (info.getWorkingCopyOriginalId() != null) {
            entry.writeViaLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ENTRY, info.getWorkingCopyOriginalId()));
        }
        if (info.getRenditionInfos() != null) {
            for (RenditionInfo ri : info.getRenditionInfos()) {
                UrlBuilder rurl = AtomPubUtils.compileUrlBuilder(baseUrl, RESOURCE_CONTENT, info.getId());
                rurl.addParameter("streamId", (Object)ri.getId());
                entry.writeAlternateLink(rurl.toString(), ri.getContenType(), ri.getKind(), ri.getTitle(), ri.getLength());
            }
        }
        if (info.hasAcl()) {
            entry.writeAclLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ACL, info.getId()));
        }
        if (info.supportsPolicies()) {
            entry.writePoliciesLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_POLICIES, info.getId()));
        }
        if (info.supportsRelationships()) {
            entry.writeRelationshipsLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_RELATIONSHIPS, info.getId()));
        }
        if (info.getRelationshipSourceIds() != null) {
            for (String id : info.getRelationshipSourceIds()) {
                entry.writeRelationshipSourceLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ENTRY, id));
            }
        }
        if (info.getRelationshipTargetIds() != null) {
            for (String id : info.getRelationshipTargetIds()) {
                entry.writeRelationshipTargetLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ENTRY, id));
            }
        }
        if (children != null && children.size() > 0) {
            AtomPubUtils.writeObjectChildren(service, entry, info, children, repositoryId, baseUrl);
        }
        entry.endEntry();
    }

    public static void writeContentChangesObjectEntry(CmisService service, AtomEntry entry, ObjectData object, List<ObjectInFolderContainer> children, String repositoryId, String pathSegment, String relativePathSegment, UrlBuilder baseUrl, boolean isRoot) throws XMLStreamException, JAXBException {
        if (object == null) {
            throw new CmisRuntimeException("Object not set!");
        }
        ObjectInfo info = null;
        try {
            info = service.getObjectInfo(repositoryId, object.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (info != null) {
            AtomPubUtils.writeObjectEntry(service, entry, object, children, repositoryId, pathSegment, relativePathSegment, baseUrl, isRoot);
            return;
        }
        entry.startEntry(isRoot);
        entry.writeDeletedObject(object);
        entry.writeServiceLink(baseUrl.toString(), repositoryId);
        entry.endEntry();
    }

    public static void writeObjectChildren(CmisService service, AtomEntry entry, ObjectInfo folderInfo, List<ObjectInFolderContainer> children, String repositoryId, UrlBuilder baseUrl) throws XMLStreamException, JAXBException {
        AtomFeed feed = new AtomFeed(entry.getWriter());
        feed.startChildren();
        feed.startFeed(false);
        feed.writeFeedElements(folderInfo.getId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, null);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_DESCENDANTS, folderInfo.getId()), null);
        feed.writeViaLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_ENTRY, folderInfo.getId()));
        feed.writeDownLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_CHILDREN, folderInfo.getId()), "application/atom+xml;type=feed");
        feed.writeDownLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_FOLDERTREE, folderInfo.getId()), "application/cmistree+xml");
        feed.writeUpLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_PARENTS, folderInfo.getId()), "application/atom+xml;type=feed");
        for (ObjectInFolderContainer container : children) {
            if (container == null || container.getObject() == null) continue;
            AtomPubUtils.writeObjectEntry(service, entry, container.getObject().getObject(), container.getChildren(), repositoryId, container.getObject().getPathSegment(), null, baseUrl, false);
        }
        feed.endFeed();
        feed.endChildren();
    }

    public static void writeTypeEntry(AtomEntry entry, TypeDefinition type, List<TypeDefinitionContainer> children, String repositoryId, UrlBuilder baseUrl, boolean isRoot) throws XMLStreamException, JAXBException {
        entry.startEntry(isRoot);
        entry.writeType(type);
        entry.writeServiceLink(baseUrl.toString(), repositoryId);
        entry.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_TYPE, type.getId()), type.getId());
        entry.writeEnclosureLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_TYPE, type.getId()));
        if (type.getParentTypeId() != null) {
            entry.writeUpLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_TYPE, type.getParentTypeId()), "application/atom+xml;type=entry");
        }
        UrlBuilder downLink = AtomPubUtils.compileUrlBuilder(baseUrl, RESOURCE_TYPES, null);
        downLink.addParameter("typeId", (Object)type.getId());
        entry.writeDownLink(downLink.toString(), "application/atom+xml;type=feed");
        UrlBuilder downLink2 = AtomPubUtils.compileUrlBuilder(baseUrl, RESOURCE_TYPESDESC, null);
        downLink2.addParameter("typeId", (Object)type.getId());
        entry.writeDownLink(downLink2.toString(), "application/cmistree+xml");
        entry.writeDescribedByLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_TYPE, type.getBaseTypeId().value()));
        if (children != null && children.size() > 0) {
            AtomPubUtils.writeTypeChildren(entry, type, children, repositoryId, baseUrl);
        }
        entry.endEntry();
    }

    private static void writeTypeChildren(AtomEntry entry, TypeDefinition type, List<TypeDefinitionContainer> children, String repositoryId, UrlBuilder baseUrl) throws XMLStreamException, JAXBException {
        AtomFeed feed = new AtomFeed(entry.getWriter());
        feed.startChildren();
        feed.startFeed(false);
        feed.writeFeedElements(type.getId(), TYPE_AUTHOR, type.getDisplayName(), new GregorianCalendar(), null, null);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        UrlBuilder selfLink = AtomPubUtils.compileUrlBuilder(baseUrl, RESOURCE_TYPESDESC, null);
        selfLink.addParameter("typeId", (Object)type.getId());
        feed.writeSelfLink(selfLink.toString(), type.getId());
        feed.writeViaLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_TYPE, type.getId()));
        UrlBuilder downLink = AtomPubUtils.compileUrlBuilder(baseUrl, RESOURCE_TYPES, null);
        downLink.addParameter("typeId", (Object)type.getId());
        feed.writeDownLink(downLink.toString(), "application/atom+xml;type=feed");
        if (type.getParentTypeId() != null) {
            feed.writeUpLink(AtomPubUtils.compileUrl(baseUrl, RESOURCE_TYPE, type.getParentTypeId()), "application/atom+xml;type=entry");
        }
        for (TypeDefinitionContainer container : children) {
            if (container == null || container.getTypeDefinition() == null) continue;
            AtomPubUtils.writeTypeEntry(entry, container.getTypeDefinition(), container.getChildren(), repositoryId, baseUrl, false);
        }
        feed.endFeed();
        feed.endChildren();
    }
}

