/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisFaultType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumServiceException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.impl.ServerVersion;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.w3c.dom.Node;

public abstract class AbstractService {
    public static final String CALL_CONTEXT_MAP = "org.apache.chemistry.opencmis.callcontext";

    protected CmisServiceFactory getServiceFactory(WebServiceContext wsContext) {
        ServletContext servletContext = (ServletContext)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
        CmisServiceFactory factory = (CmisServiceFactory)servletContext.getAttribute("org.apache.chemistry.opencmis.servicesfactory");
        if (factory == null) {
            throw new CmisRuntimeException("Service factory not available! Configuration problem?");
        }
        HttpServletResponse httpResp = (HttpServletResponse)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.response");
        httpResp.setHeader("Server", ServerVersion.OPENCMIS_SERVER);
        return factory;
    }

    protected CallContext createContext(WebServiceContext wsContext, String repositoryId) {
        CallContextImpl context = new CallContextImpl("webservices", repositoryId, false);
        MessageContext mc = wsContext.getMessageContext();
        Map callContextMap = (Map)mc.get((Object)CALL_CONTEXT_MAP);
        if (callContextMap != null) {
            for (Map.Entry e : callContextMap.entrySet()) {
                context.put((String)e.getKey(), e.getValue());
            }
        }
        ServletContext servletContext = (ServletContext)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
        context.put("servletContext", servletContext);
        HttpServletRequest request = (HttpServletRequest)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.request");
        context.put("httpServletRequest", request);
        HttpServletResponse response = (HttpServletResponse)wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.response");
        context.put("httpServletResponse", response);
        Map headers = (Map)wsContext.getMessageContext().get((Object)"javax.xml.ws.http.request.headers");
        if (headers != null) {
            for (Map.Entry header : headers.entrySet()) {
                if (!((String)header.getKey()).equalsIgnoreCase("Accept-Language") || header.getValue() == null) continue;
                String acceptLanguage = (String)((List)header.getValue()).get(0);
                if (acceptLanguage == null) break;
                String[] locale = acceptLanguage.split("-");
                context.put("language", locale[0].trim());
                if (locale.length <= 1) break;
                int x = locale[1].indexOf(44);
                if (x == -1) {
                    context.put("country", locale[1].trim());
                    break;
                }
                context.put("country", locale[1].substring(0, x).trim());
                break;
            }
        }
        return context;
    }

    protected CmisService getService(WebServiceContext wsContext, String repositoryId) {
        CmisServiceFactory factory = this.getServiceFactory(wsContext);
        CallContext context = this.createContext(wsContext, repositoryId);
        return factory.getService(context);
    }

    protected void closeService(CmisService service) {
        if (service != null) {
            service.close();
        }
    }

    protected CmisException convertException(Exception ex) {
        CmisFaultType fault = new CmisFaultType();
        fault.setMessage("Unknown exception");
        fault.setCode(BigInteger.ZERO);
        fault.setType(EnumServiceException.RUNTIME);
        if (ex != null) {
            fault.setMessage(ex.getMessage());
            if (ex instanceof CmisBaseException) {
                fault.setCode(((CmisBaseException)ex).getCode());
            }
            if (ex instanceof CmisConstraintException) {
                fault.setType(EnumServiceException.CONSTRAINT);
            } else if (ex instanceof CmisContentAlreadyExistsException) {
                fault.setType(EnumServiceException.CONTENT_ALREADY_EXISTS);
            } else if (ex instanceof CmisFilterNotValidException) {
                fault.setType(EnumServiceException.FILTER_NOT_VALID);
            } else if (ex instanceof CmisInvalidArgumentException) {
                fault.setType(EnumServiceException.INVALID_ARGUMENT);
            } else if (ex instanceof CmisNameConstraintViolationException) {
                fault.setType(EnumServiceException.NAME_CONSTRAINT_VIOLATION);
            } else if (ex instanceof CmisNotSupportedException) {
                fault.setType(EnumServiceException.NOT_SUPPORTED);
            } else if (ex instanceof CmisObjectNotFoundException) {
                fault.setType(EnumServiceException.OBJECT_NOT_FOUND);
            } else if (ex instanceof CmisPermissionDeniedException) {
                fault.setType(EnumServiceException.PERMISSION_DENIED);
            } else if (ex instanceof CmisStorageException) {
                fault.setType(EnumServiceException.STORAGE);
            } else if (ex instanceof CmisStreamNotSupportedException) {
                fault.setType(EnumServiceException.STREAM_NOT_SUPPORTED);
            } else if (ex instanceof CmisUpdateConflictException) {
                fault.setType(EnumServiceException.UPDATE_CONFLICT);
            } else if (ex instanceof CmisVersioningException) {
                fault.setType(EnumServiceException.VERSIONING);
            }
            Node node = ExceptionHelper.getStacktraceAsNode(ex);
            if (node != null) {
                fault.getAny().add(node);
            }
        }
        return new CmisException(fault.getMessage(), fault, (Throwable)ex);
    }
}

