/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.xmi;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.teiid.xmi.XmiAttribute;
import org.modeshape.sequencer.teiid.xmi.XmiElement;

public class XmiElementTest {
    private static final String INITIAL_NAME = "partName";
    private static final String UUID = "1e40dcf2-8113-4c0b-81de-5a9dbf8bede0";
    private static final String UUID_ATTR_NAME = "uuid";
    private static final String UUID_ATTR_NAMESPACE_PREFIX = "xmi";
    private static final String UUID_ATTR_NAMESPACE_URI = "http://www.omg.org/XMI";
    private static final XmiAttribute UUID_ATTRIBUTE = new XmiAttribute("uuid");
    private static final String CHILD_NAME = "childName";
    private static final String CHILD_NAMESPACE_PREFIX = "prefix";
    private static final String CHILD_NAMESPACE_URI = "uri";
    private XmiElement element;

    private XmiElement createChild() {
        XmiElement child = new XmiElement(CHILD_NAME);
        child.setNamespacePrefix(CHILD_NAMESPACE_PREFIX);
        child.setNamespaceUri(CHILD_NAMESPACE_URI);
        this.element.addChild(child);
        return child;
    }

    @Before
    public void beforeEach() {
        this.element = new XmiElement(INITIAL_NAME){};
    }

    @Test
    public void shouldHaveEmptyAttributesAfterConstruction() {
        Assert.assertNotNull((Object)this.element.getAttributes());
        Assert.assertTrue((boolean)this.element.getAttributes().isEmpty());
    }

    @Test
    public void shouldHaveEmptyChildrenAfterConstruction() {
        Assert.assertNotNull((Object)this.element.getChildren());
        Assert.assertTrue((boolean)this.element.getChildren().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowAddingNullAttribute() {
        this.element.addAttribute(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowAddingNullChild() {
        this.element.addChild(null);
    }

    @Test
    public void shouldAddAttribute() {
        this.element.addAttribute(UUID_ATTRIBUTE);
        Assert.assertThat((Object)this.element.getAttributes().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(this.element.getAttributes().iterator().next(), (Matcher)Is.is((Object)UUID_ATTRIBUTE));
    }

    @Test
    public void shouldSetUuud() {
        this.element.addAttribute(UUID_ATTRIBUTE);
        Assert.assertThat((Object)this.element.getUuid(), (Matcher)Is.is((Object)UUID));
    }

    @Test
    public void shouldFindAttribute() {
        this.element.addAttribute(UUID_ATTRIBUTE);
        Assert.assertThat((Object)this.element.getAttribute(UUID_ATTR_NAME, UUID_ATTR_NAMESPACE_URI), (Matcher)Is.is((Object)UUID_ATTRIBUTE));
    }

    @Test
    public void shouldNotFindAttributeIfIncorrectUri() {
        this.element.addAttribute(UUID_ATTRIBUTE);
        Assert.assertNull((Object)this.element.getAttribute(UUID_ATTR_NAME, "http://www.metamatrix.com/metamodels/Relational"));
    }

    @Test
    public void shouldAddChild() {
        XmiElement child = this.createChild();
        Assert.assertThat((Object)this.element.getChildren().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(this.element.getChildren().iterator().next(), (Matcher)Is.is((Object)child));
        Assert.assertThat((Object)child.getParent(), (Matcher)Is.is((Object)this.element));
    }

    @Test
    public void shouldFindChild() {
        XmiElement child = this.createChild();
        XmiElement kid = this.element.findChild(CHILD_NAME, CHILD_NAMESPACE_URI);
        Assert.assertNotNull((Object)kid);
        Assert.assertThat((Object)kid, (Matcher)Is.is((Object)child));
    }

    @Test
    public void shouldBeEqualIfStateIsTheSame() {
        XmiElement thisChild = this.createChild();
        XmiElement thatChild = new XmiElement(thisChild.getName());
        thatChild.setNamespacePrefix(thisChild.getNamespacePrefix());
        thatChild.setNamespaceUri(thisChild.getNamespaceUri());
        thisChild.getParent().addChild(thatChild);
        Assert.assertThat((Object)thatChild, (Matcher)Is.is((Object)thisChild));
    }

    static {
        UUID_ATTRIBUTE.setValue(UUID);
        UUID_ATTRIBUTE.setNamespacePrefix(UUID_ATTR_NAMESPACE_PREFIX);
        UUID_ATTRIBUTE.setNamespaceUri(UUID_ATTR_NAMESPACE_URI);
    }
}

