/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.util.concurrent.TimeoutException;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.AllPathsCache;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.DocumentAlreadyExistsException;
import org.modeshape.jcr.cache.DocumentNotFoundException;
import org.modeshape.jcr.cache.LockFailureException;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundException;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.ReferentialIntegrityException;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.document.AbstractSessionCache;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.MutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

@ThreadSafe
public class WritableSessionCache
extends AbstractSessionCache {
    private static final Logger LOGGER = Logger.getLogger(WritableSessionCache.class);
    private static final NodeKey REMOVED_KEY = new NodeKey("REMOVED_NODE_SHOULD_NEVER_BE_PERSISTED");
    private static final SessionNode REMOVED = new SessionNode(REMOVED_KEY, false);
    private static final int MAX_REPEAT_FOR_LOCK_ACQUISITION_TIMEOUT = 4;
    private static final long PAUSE_TIME_BEFORE_REPEAT_FOR_LOCK_ACQUISITION_TIMEOUT = 50L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<NodeKey, SessionNode> changedNodes = new HashMap<NodeKey, SessionNode>();
    private Set<NodeKey> replacedNodes;
    private LinkedHashSet<NodeKey> changedNodesInOrder = new LinkedHashSet();
    private Map<NodeKey, SessionNode.ReferrerChanges> referrerChangesForRemovedNodes = new HashMap<NodeKey, SessionNode.ReferrerChanges>();
    private final Transactions txns;

    public WritableSessionCache(ExecutionContext context, WorkspaceCache workspaceCache, SessionEnvironment sessionContext) {
        super(context, workspaceCache, sessionContext);
        this.txns = sessionContext.getTransactions();
    }

    protected final void assertInSession(SessionNode node) {
        assert (this.changedNodes.get(node.getKey()) == node) : "Node " + node.getKey() + " is not in this session";
    }

    @Override
    protected Logger logger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedNode getNode(NodeKey key) {
        CachedNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == REMOVED) {
            return null;
        }
        return sessionNode != null ? sessionNode : super.getNode(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SessionNode mutable(NodeKey key) {
        SessionNode sessionNode = null;
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            sessionNode = this.changedNodes.get(key);
        }
        finally {
            lock.unlock();
        }
        if (sessionNode == null || sessionNode == REMOVED) {
            sessionNode = new SessionNode(key, false);
            lock = this.lock.writeLock();
            try {
                lock.lock();
                sessionNode = this.changedNodes.get(key);
                if (sessionNode != null) return sessionNode;
                sessionNode = new SessionNode(key, false);
                this.changedNodes.put(key, sessionNode);
                this.changedNodesInOrder.add(key);
                return sessionNode;
            }
            finally {
                lock.unlock();
            }
        } else {
            if (this.changedNodesInOrder.contains(key)) return sessionNode;
            this.changedNodesInOrder.add(key);
        }
        return sessionNode;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClear() {
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            this.changedNodes.clear();
            this.changedNodesInOrder.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClear(CachedNode node) {
        Path nodePath = node.getPath(this);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            List<SessionNode> nodesToRemoveInOrder = this.getChangedNodesAtOrBelowChildrenFirst(nodePath);
            for (SessionNode nodeToRemove : nodesToRemoveInOrder) {
                NodeKey key = nodeToRemove.getKey();
                this.changedNodes.remove(key);
                this.changedNodesInOrder.remove(key);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private List<SessionNode> getChangedNodesAtOrBelowChildrenFirst(Path nodePath) {
        ArrayList<SessionNode> changedNodesChildrenFirst = new ArrayList<SessionNode>();
        for (NodeKey key : this.changedNodes.keySet()) {
            SessionNode changedNode = this.changedNodes.get(key);
            if (!changedNode.isAtOrBelow(this, nodePath)) continue;
            int insertIndex = changedNodesChildrenFirst.size();
            Path changedNodePath = changedNode.getPath(this);
            for (int i = 0; i < changedNodesChildrenFirst.size(); ++i) {
                if (!((SessionNode)changedNodesChildrenFirst.get(i)).getPath(this).isAncestorOf(changedNodePath)) continue;
                insertIndex = i;
                break;
            }
            changedNodesChildrenFirst.add(insertIndex, changedNode);
        }
        return changedNodesChildrenFirst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeys() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashSet<NodeKey> hashSet = new HashSet<NodeKey>(this.changedNodes.keySet());
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeKey> getChangedNodeKeysAtOrBelow(CachedNode srcNode) {
        CheckArg.isNotNull((Object)srcNode, (String)"srcNode");
        Path sourcePath = srcNode.getPath(this);
        WorkspaceCache workspaceCache = this.workspaceCache();
        AllPathsCache allPathsCache = new AllPathsCache(this, workspaceCache, this.context()){

            @Override
            protected Set<NodeKey> getAdditionalParentKeys(CachedNode node, NodeCache cache) {
                SessionNode sessionNode;
                SessionNode.ChangedAdditionalParents changed;
                Set<NodeKey> keys = super.getAdditionalParentKeys(node, cache);
                if (node instanceof SessionNode && (changed = (sessionNode = (SessionNode)node).additionalParents()) != null) {
                    keys = new HashSet<NodeKey>(keys);
                    keys.addAll(sessionNode.additionalParents().getRemovals());
                }
                return keys;
            }
        };
        Lock readLock = this.lock.readLock();
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        try {
            readLock.lock();
            block3: for (Map.Entry<NodeKey, SessionNode> entry : this.changedNodes.entrySet()) {
                SessionNode changedNodeThisSession = entry.getValue();
                NodeKey changedNodeKey = entry.getKey();
                CachedNode changedNode = null;
                if (changedNodeThisSession == REMOVED) {
                    CachedNode persistentRemovedNode = workspaceCache.getNode(changedNodeKey);
                    if (persistentRemovedNode == null) {
                        result.add(changedNodeKey);
                        continue;
                    }
                    changedNode = persistentRemovedNode;
                } else {
                    changedNode = changedNodeThisSession;
                }
                for (Path validPath : allPathsCache.getPaths(changedNode)) {
                    if (!validPath.isAtOrBelow(sourcePath)) continue;
                    result.add(changedNodeKey);
                    continue block3;
                }
            }
            HashSet<NodeKey> hashSet = result;
            return hashSet;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChanges() {
        Lock lock = this.lock.readLock();
        try {
            lock.lock();
            boolean bl = !this.changedNodesInOrder.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void save() {
        this.save(null);
    }

    /*
     * Exception decompiling
     */
    protected void save(SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runPreSaveBeforeTransaction(SessionCache.PreSave preSaveOperation) throws Exception {
        if (preSaveOperation != null) {
            AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
            for (SessionNode node : this.changedNodes.values()) {
                if (node == REMOVED) continue;
                this.checkNodeNotRemovedByAnotherTransaction(node);
                preSaveOperation.process(node, saveContext);
            }
        }
    }

    private void runPreSaveAfterLocking(SessionCache.PreSave preSaveOperation) throws Exception {
        if (preSaveOperation != null) {
            AbstractSessionCache.BasicSaveContext saveContext = new AbstractSessionCache.BasicSaveContext(this.context());
            for (SessionNode node : this.changedNodes.values()) {
                if (node == REMOVED || node.isNew()) continue;
                preSaveOperation.processAfterLocking(node, saveContext, this.workspaceCache());
            }
        }
    }

    protected void clearState() {
        this.changedNodes = new HashMap<NodeKey, SessionNode>();
        this.referrerChangesForRemovedNodes.clear();
        this.changedNodesInOrder.clear();
        this.replacedNodes = null;
        this.checkForTransaction();
    }

    protected void clearState(Iterable<NodeKey> savedNodesInOrder) {
        for (NodeKey savedNode : savedNodesInOrder) {
            this.changedNodes.remove(savedNode);
            this.changedNodesInOrder.remove(savedNode);
            if (this.replacedNodes == null) continue;
            this.replacedNodes.remove(savedNode);
        }
        this.checkForTransaction();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void save(SessionCache other, SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkNodeNotRemovedByAnotherTransaction(MutableCachedNode node) {
        String keyString = node.getKey().toString();
        if (!node.isNew() && !this.workspaceCache().documentStore().containsKey(keyString)) {
            throw new DocumentNotFoundException(keyString);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void save(Set<NodeKey> toBeSaved, SessionCache other, SessionCache.PreSave preSaveOperation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ChangeSet persistChanges(Iterable<NodeKey> changedNodesInOrder, SessionEnvironment.Monitor monitor) {
        ExecutionContext context = this.context();
        String userId = context.getSecurityContext().getUserName();
        Map<String, String> userData = context.getData();
        DateTime timestamp = context.getValueFactories().getDateFactory().create();
        String workspaceName = this.workspaceCache().getWorkspaceName();
        String repositoryKey = this.workspaceCache().getRepositoryKey();
        String processKey = this.workspaceCache().getProcessKey();
        RecordingChanges changes = new RecordingChanges(processKey, repositoryKey, workspaceName);
        WorkspaceCache workspaceCache = this.workspaceCache();
        DocumentStore documentStore = workspaceCache.documentStore();
        DocumentTranslator translator = workspaceCache.translator();
        PathCache sessionPaths = new PathCache(this);
        PathCache workspacePaths = new PathCache(workspaceCache);
        HashSet<NodeKey> removedNodes = null;
        HashSet<BinaryKey> unusedBinaryKeys = new HashSet<BinaryKey>();
        for (NodeKey nodeKey : changedNodesInOrder) {
            Path childPath;
            Path parentPath;
            boolean queryable;
            EditableDocument doc;
            CachedNode persisted;
            SessionNode node = this.changedNodes.get(nodeKey);
            String keyStr = nodeKey.toString();
            if (node == REMOVED) {
                persisted = workspaceCache.getNode(nodeKey);
                if (persisted == null) continue;
                if (removedNodes == null) {
                    removedNodes = new HashSet<NodeKey>();
                }
                Path path = workspacePaths.getPath(persisted);
                changes.nodeRemoved(nodeKey, persisted.getParentKey(workspaceCache), path);
                removedNodes.add(nodeKey);
                SessionNode.ReferrerChanges referrerChanges = this.referrerChangesForRemovedNodes.get(nodeKey);
                if (referrerChanges == null) continue;
                doc = documentStore.get(keyStr).editDocumentContent();
                translator.changeReferrers(doc, referrerChanges);
                continue;
            }
            persisted = null;
            Path newPath = sessionPaths.getPath(node);
            NodeKey newParent = node.newParent();
            doc = null;
            SessionNode.ChangedAdditionalParents additionalParents = node.additionalParents();
            if (node.isNew()) {
                doc = Schematic.newDocument();
                translator.setKey(doc, nodeKey);
                translator.setParents(doc, newParent, null, additionalParents);
                changes.nodeCreated(nodeKey, newParent, newPath, node.changedProperties());
            } else {
                SchematicEntry nodeEntry = documentStore.get(keyStr);
                if (nodeEntry == null) {
                    throw new DocumentNotFoundException(keyStr);
                }
                doc = nodeEntry.editDocumentContent();
                if (newParent != null) {
                    persisted = workspaceCache.getNode(nodeKey);
                    Path oldPath = workspacePaths.getPath(persisted);
                    NodeKey oldParentKey = persisted.getParentKey(workspaceCache);
                    if (!oldParentKey.equals(newParent) || additionalParents != null && !additionalParents.isEmpty()) {
                        translator.setParents(doc, node.newParent(), oldParentKey, additionalParents);
                    }
                    changes.nodeMoved(nodeKey, newParent, oldParentKey, newPath, oldPath);
                } else if (additionalParents != null) {
                    translator.setParents(doc, null, null, additionalParents);
                }
                SessionNode.MixinChanges mixinChanges = node.mixinChanges(false);
                if (mixinChanges != null && !mixinChanges.isEmpty()) {
                    Property oldProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    translator.addPropertyValues(doc, JcrLexicon.MIXIN_TYPES, true, mixinChanges.getAdded(), unusedBinaryKeys);
                    translator.removePropertyValues(doc, JcrLexicon.MIXIN_TYPES, mixinChanges.getRemoved(), unusedBinaryKeys);
                    Property newProperty = translator.getProperty((Document)doc, JcrLexicon.MIXIN_TYPES);
                    if (oldProperty == null) {
                        changes.propertyAdded(nodeKey, newPath, newProperty);
                    } else if (newProperty == null) {
                        changes.propertyRemoved(nodeKey, newPath, oldProperty);
                    } else {
                        changes.propertyChanged(nodeKey, newPath, newProperty, oldProperty);
                    }
                }
            }
            SessionNode.LockChange lockChange = node.getLockChange();
            if (lockChange != null) {
                switch (lockChange) {
                    case LOCK_FOR_SESSION: 
                    case LOCK_FOR_NON_SESSION: {
                        if (!translator.isLocked(doc)) break;
                        throw new LockFailureException(nodeKey);
                    }
                }
            }
            boolean hasPropertyChanges = false;
            Set<Name> removedProperties = node.removedProperties();
            if (!removedProperties.isEmpty()) {
                assert (!node.isNew());
                if (persisted == null) {
                    persisted = workspaceCache.getNode(nodeKey);
                }
                for (Name name : removedProperties) {
                    Property oldProperty = translator.removeProperty(doc, name, unusedBinaryKeys);
                    if (oldProperty == null) continue;
                    changes.propertyRemoved(nodeKey, newPath, oldProperty);
                    hasPropertyChanges = true;
                }
            }
            if (!node.changedProperties().isEmpty()) {
                if (!node.isNew() && persisted == null) {
                    persisted = workspaceCache.getNode(nodeKey);
                }
                for (Map.Entry entry : node.changedProperties().entrySet()) {
                    Name name = (Name)entry.getKey();
                    Property prop = (Property)entry.getValue();
                    Property oldProperty = persisted != null ? persisted.getProperty(name, workspaceCache) : null;
                    translator.setProperty(doc, prop, unusedBinaryKeys);
                    if (oldProperty == null) {
                        changes.propertyAdded(nodeKey, newPath, prop);
                        hasPropertyChanges = true;
                        continue;
                    }
                    if (!hasPropertyChanges && oldProperty.equals(prop)) continue;
                    changes.propertyChanged(nodeKey, newPath, prop, oldProperty);
                    hasPropertyChanges = true;
                }
            }
            SessionNode.ChangedChildren changedChildren = node.changedChildren();
            MutableChildReferences mutableChildReferences = node.appended(false);
            if ((changedChildren == null || changedChildren.isEmpty()) && mutableChildReferences != null && !mutableChildReferences.isEmpty()) {
                translator.changeChildren(doc, changedChildren, mutableChildReferences);
            } else if (changedChildren != null && !changedChildren.isEmpty()) {
                if (!changedChildren.getRemovals().isEmpty()) {
                    for (NodeKey removed : changedChildren.getRemovals()) {
                        CachedNode persistent = workspaceCache.getNode(removed);
                        if (persistent == null) continue;
                        Path oldPath = workspacePaths.getPath(persistent);
                        if (mutableChildReferences == null || !mutableChildReferences.hasChild(persistent.getKey())) continue;
                        ChildReference appendedChildRef = node.getChildReferences(this).getChild(persistent.getKey());
                        newPath = this.pathFactory().create(sessionPaths.getPath(node), appendedChildRef.getSegment());
                        changes.nodeReordered(persistent.getKey(), node.getKey(), newPath, oldPath, null);
                    }
                }
                translator.changeChildren(doc, changedChildren, mutableChildReferences);
                Map<NodeKey, Name> newNames = changedChildren.getNewNames();
                if (!newNames.isEmpty()) {
                    for (Map.Entry<NodeKey, Name> renameEntry : newNames.entrySet()) {
                        NodeKey renamedKey = renameEntry.getKey();
                        CachedNode oldRenamedNode = workspaceCache.getNode(renamedKey);
                        if (oldRenamedNode == null) continue;
                        CachedNode renamedNode = this.getNode(renamedKey);
                        Path renamedFromPath = workspacePaths.getPath(oldRenamedNode);
                        Path renamedToPath = sessionPaths.getPath(renamedNode);
                        changes.nodeRenamed(renamedKey, renamedToPath, renamedFromPath.getLastSegment());
                    }
                }
                Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey = changedChildren.getInsertionsByBeforeKey();
                for (SessionNode.Insertions insertion : insertionsByBeforeKey.values()) {
                    for (ChildReference insertedRef : insertion.inserted()) {
                        boolean isSnsReordering;
                        CachedNode insertedNodePersistent = workspaceCache.getNode(insertedRef);
                        Path nodeOldPath = insertedNodePersistent != null ? workspacePaths.getPath(insertedNodePersistent) : null;
                        CachedNode insertedBeforeNode = workspaceCache.getNode(insertion.insertedBefore());
                        Path insertedBeforePath = workspacePaths.getPath(insertedBeforeNode);
                        Path nodeNewPath = null;
                        nodeNewPath = nodeOldPath != null ? ((isSnsReordering = nodeOldPath.getLastSegment().getName().equals(insertedBeforePath.getLastSegment().getName())) ? insertedBeforePath : nodeOldPath) : sessionPaths.getPath(this.changedNodes.get(insertedRef.getKey()));
                        changes.nodeReordered(insertedRef.getKey(), node.getKey(), nodeNewPath, nodeOldPath, insertedBeforePath);
                    }
                }
            }
            SessionNode.ReferrerChanges referrerChanges = node.getReferrerChanges();
            if (referrerChanges != null && !referrerChanges.isEmpty()) {
                translator.changeReferrers(doc, referrerChanges);
                changes.nodeChanged(nodeKey, newPath);
            }
            if (!(queryable = node.isQueryable(this))) {
                translator.setQueryable(doc, false);
            }
            if (node.isNew()) {
                if (documentStore.storeDocument(keyStr, (Document)doc) != null) {
                    if (this.replacedNodes != null && this.replacedNodes.contains(nodeKey)) {
                        documentStore.localStore().put(keyStr, (Document)doc);
                    } else if (removedNodes != null && removedNodes.contains(nodeKey)) {
                        documentStore.localStore().put(keyStr, (Document)doc);
                        removedNodes.remove(nodeKey);
                    } else {
                        throw new DocumentAlreadyExistsException(keyStr);
                    }
                }
                if (monitor != null && queryable) {
                    Name primaryType = node.getPrimaryType(this);
                    Set<Name> mixinTypes = node.getMixinTypes(this);
                    monitor.recordAdd(workspaceName, nodeKey, newPath, primaryType, mixinTypes, node.changedProperties().values());
                }
            } else {
                boolean isSameWorkspace;
                boolean shouldUpdateIndexes;
                boolean externalNodeChanged;
                boolean isExternal = !this.workspaceCache().getRootKey().getSourceKey().equalsIgnoreCase(node.getKey().getSourceKey());
                boolean bl = externalNodeChanged = isExternal && (hasPropertyChanges || node.hasNonPropertyChanges());
                if (externalNodeChanged) {
                    documentStore.updateDocument(keyStr, (Document)doc, node);
                }
                boolean bl2 = shouldUpdateIndexes = (isSameWorkspace = this.workspaceCache().getWorkspaceKey().equalsIgnoreCase(node.getKey().getWorkspaceKey())) && (hasPropertyChanges || node.hasIndexRelatedChanges()) || externalNodeChanged;
                if (monitor != null && queryable && shouldUpdateIndexes) {
                    Name primaryType = node.getPrimaryType(this);
                    Set<Name> mixinTypes = node.getMixinTypes(this);
                    monitor.recordUpdate(workspaceName, nodeKey, newPath, primaryType, mixinTypes, node.getProperties(this));
                }
            }
            if (additionalParents == null) continue;
            for (NodeKey parentKey : additionalParents.getAdditions()) {
                SessionNode parent = this.changedNodes.get(parentKey);
                if (parent == null) continue;
                ChildReference ref = parent.getChildReferences(this).getChild(nodeKey);
                parentPath = sessionPaths.getPath(parent);
                childPath = this.pathFactory().create(parentPath, ref.getSegment());
                changes.nodeCreated(nodeKey, parentKey, childPath, null);
            }
            for (NodeKey parentKey : additionalParents.getRemovals()) {
                ChildReference ref;
                CachedNode persistedParent = workspaceCache.getNode(parentKey);
                if (persistedParent == null || (ref = persistedParent.getChildReferences(this).getChild(nodeKey)) == null) continue;
                parentPath = workspacePaths.getPath(persistedParent);
                childPath = this.pathFactory().create(parentPath, ref.getSegment());
                changes.nodeRemoved(nodeKey, parentKey, childPath);
            }
        }
        if (removedNodes != null) {
            assert (!removedNodes.isEmpty());
            HashSet<NodeKey> referrers = new HashSet<NodeKey>();
            for (NodeKey removedKey : removedNodes) {
                SchematicEntry entry = documentStore.get(removedKey.toString());
                if (entry == null) continue;
                Document doc = documentStore.get(removedKey.toString()).getContentAsDocument();
                referrers.addAll(translator.getReferrers(doc, CachedNode.ReferenceType.STRONG));
            }
            referrers.removeAll(removedNodes);
            if (!referrers.isEmpty()) {
                throw new ReferentialIntegrityException((Set<NodeKey>)removedNodes, referrers);
            }
            for (NodeKey removedKey : removedNodes) {
                documentStore.remove(removedKey.toString());
            }
            if (monitor != null) {
                monitor.recordRemove(workspaceName, removedNodes);
            }
        }
        if (!unusedBinaryKeys.isEmpty()) {
            for (BinaryKey binaryKey : unusedBinaryKeys) {
                changes.binaryValueNoLongerUsed(binaryKey);
            }
        }
        changes.setChangedNodes(this.changedNodes.keySet());
        changes.freeze(userId, userData, timestamp);
        return changes;
    }

    private void lockAndPurgeCache(Iterable<NodeKey> changedNodesInOrder) {
        DocumentStore documentStore = this.workspaceCache().documentStore();
        if (documentStore.updatesRequirePreparing()) {
            LOGGER.debug("Locking nodes in Infinispan", new Object[0]);
            HashSet<String> keysToLock = new HashSet<String>();
            for (NodeKey key : changedNodesInOrder) {
                SessionNode node = this.changedNodes.get(key);
                if (node == REMOVED || node.isNew()) continue;
                String keyStr = key.toString();
                keysToLock.add(keyStr);
            }
            if (!documentStore.prepareDocumentsForUpdate(keysToLock) && !documentStore.prepareDocumentsForUpdate(keysToLock)) {
                throw new TimeoutException("Unable to acquire storage locks: " + keysToLock);
            }
            this.workspaceCache().purge(changedNodesInOrder);
        } else {
            LOGGER.debug("Infinispan is not configured with pessimistic locks, no nodes will be locked", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionNode add(SessionNode newNode) {
        assert (newNode != REMOVED);
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            NodeKey key = newNode.getKey();
            SessionNode node = this.changedNodes.put(key, newNode);
            if (node != null) {
                if (node != REMOVED) {
                    this.changedNodes.put(key, node);
                    SessionNode sessionNode = node;
                    return sessionNode;
                }
                if (this.replacedNodes == null) {
                    this.replacedNodes = new HashSet<NodeKey>();
                }
                this.replacedNodes.add(key);
            }
            this.changedNodesInOrder.add(key);
            SessionNode sessionNode = newNode;
            return sessionNode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(NodeKey key) {
        assert (key != null);
        WorkspaceCache workspace = this.workspaceCache();
        CachedNode topNode = this.getNode(key);
        if (topNode == null) {
            throw new NodeNotFoundException(key);
        }
        HashMap<NodeKey, SessionNode> removed = new HashMap<NodeKey, SessionNode>();
        LinkedHashSet<NodeKey> addToChangedNodes = new LinkedHashSet<NodeKey>();
        Lock lock = this.lock.writeLock();
        try {
            lock.lock();
            LinkedList<NodeKey> keys = new LinkedList<NodeKey>();
            keys.add(key);
            while (!keys.isEmpty()) {
                NodeKey nodeKey = (NodeKey)keys.remove();
                SessionNode node = this.changedNodes.put(nodeKey, REMOVED);
                boolean cleanupReferences = false;
                ChildReferences children = null;
                if (node != null) {
                    if (node == REMOVED) continue;
                    children = node.getChildReferences(this);
                    removed.put(nodeKey, node);
                    this.referrerChangesForRemovedNodes.put(nodeKey, node.getReferrerChanges());
                    cleanupReferences = true;
                } else {
                    addToChangedNodes.add(nodeKey);
                    CachedNode persisted = workspace.getNode(nodeKey);
                    if (persisted == null) continue;
                    children = persisted.getChildReferences(workspace);
                    Iterator<Property> it = persisted.getProperties(workspace);
                    while (it.hasNext()) {
                        Property property = it.next();
                        if (property == null || !property.isReference()) continue;
                        this.changedNodes.remove(nodeKey);
                        node = this.mutable(nodeKey);
                        if (node != null) {
                            cleanupReferences = true;
                        }
                        this.changedNodes.put(nodeKey, REMOVED);
                    }
                }
                if (cleanupReferences) {
                    assert (node != null);
                    node.removeAllReferences(this);
                }
                assert (children != null);
                for (ChildReference child : children) {
                    NodeKey childKey = child.getKey();
                    if (!childKey.getSourceKey().equalsIgnoreCase(key.getSourceKey())) continue;
                    keys.add(childKey);
                }
            }
            this.changedNodesInOrder.addAll(addToChangedNodes);
        }
        catch (RuntimeException e) {
            try {
                this.changedNodes.putAll(removed);
            }
            catch (RuntimeException e2) {
                I18n msg = JcrI18n.failedWhileRollingBackDestroyToRuntimeError;
                LOGGER.error((Throwable)e2, (I18nResource)msg, new Object[]{e2.getMessage(), e.getMessage()});
            }
            finally {
                throw e;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isDestroyed(NodeKey key) {
        return this.changedNodes.get(key) == REMOVED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NamespaceRegistry reg = this.context().getNamespaceRegistry();
        sb.append("Session ").append(this.context().getId()).append(" to workspace '").append(this.workspaceName());
        for (NodeKey key : this.changedNodesInOrder) {
            SessionNode changes = this.changedNodes.get(key);
            if (changes == null) continue;
            sb.append("\n ");
            sb.append(changes.getString(reg));
        }
        return sb.toString();
    }

    public void createProjection(NodeKey nodeKey, String sourceName, String externalPath, String alias) {
        SessionNode node = this.mutable(nodeKey);
        try {
            Transactions.Transaction txn = this.txns.begin();
            DocumentStore documentStore = this.workspaceCache().documentStore();
            EditableDocument document = documentStore.get(nodeKey.toString()).editDocumentContent();
            DocumentTranslator translator = this.workspaceCache().translator();
            translator.addFederatedSegment(document, nodeKey.toString(), sourceName, externalPath, alias);
            txn.commit();
        }
        catch (Exception err) {
            throw new SystemFailureException(JcrI18n.errorStoringProjection.text(new Object[]{this.workspaceName(), node.getPath(this), sourceName, externalPath, alias, err.getMessage()}), (Throwable)err);
        }
    }

    public void removeProjection(NodeKey federatedNodeKey, NodeKey externalNodeKey) {
        SessionNode node = this.mutable(federatedNodeKey);
        try {
            Transactions.Transaction txn = this.txns.begin();
            DocumentStore documentStore = this.workspaceCache().documentStore();
            EditableDocument federatedDocument = documentStore.get(federatedNodeKey.toString()).editDocumentContent();
            DocumentTranslator translator = this.workspaceCache().translator();
            translator.removeFederatedSegments(federatedDocument, externalNodeKey.toString());
            txn.commit();
        }
        catch (Exception err) {
            throw new SystemFailureException(JcrI18n.errorRemovingProjection.text(new Object[]{this.workspaceName(), node.getPath(this), externalNodeKey, err.getMessage()}), (Throwable)err);
        }
    }
}

