/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.RepositoryManager;
import org.modeshape.web.jcr.webdav.ContentMapper;
import org.modeshape.web.jcr.webdav.RequestResolver;
import org.modeshape.web.jcr.webdav.ResolvedRequest;
import org.modeshape.web.jcr.webdav.WebdavI18n;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.ObjectNotFoundException;
import org.modeshape.webdav.exceptions.WebdavException;

public class ModeShapeWebdavStore
implements IWebdavStore {
    private static final String DS_STORE_SUFFIX = ".DS_Store";
    private static final ThreadLocal<HttpServletRequest> THREAD_LOCAL_REQUEST = new ThreadLocal();
    private static final Map<String, byte[]> OSX_DOUBLE_DATA = Collections.synchronizedMap(new WeakHashMap());
    private static final String CREATED_PROP_NAME = "jcr:created";
    private final RequestResolver requestResolver;
    private final ContentMapper contentMapper;
    private final Logger logger = Logger.getLogger(this.getClass());

    public ModeShapeWebdavStore(RequestResolver requestResolver, ContentMapper contentMapper) {
        this.requestResolver = requestResolver;
        this.contentMapper = contentMapper;
    }

    static void setRequest(HttpServletRequest request) {
        THREAD_LOCAL_REQUEST.set(request);
    }

    public ITransaction begin(Principal principal) {
        return new JcrSessionTransaction(principal);
    }

    public void commit(ITransaction transaction) {
        CheckArg.isNotNull((Object)transaction, (String)"transaction");
        assert (transaction instanceof JcrSessionTransaction);
        ((JcrSessionTransaction)transaction).commit();
    }

    public void rollback(ITransaction transaction) {
    }

    public void checkAuthentication(ITransaction transaction) {
    }

    public void destroy() {
    }

    public void createFolder(ITransaction transaction, String folderUri) {
        folderUri = this.removeTrailingSlash(folderUri);
        int ind = folderUri.lastIndexOf(47);
        String parentUri = folderUri.substring(0, ind + 1);
        String resourceName = folderUri.substring(ind + 1);
        try {
            this.logger.debug("WebDAV create folder at: " + parentUri, new Object[0]);
            ResolvedRequest resolvedParent = this.resolveRequest(transaction, parentUri);
            this.logger.debug("WebDAV create folder at: " + resolvedParent, new Object[0]);
            if (resolvedParent.getPath() == null) {
                if (resolvedParent.getRepositoryName() == null) {
                    throw new WebdavException(WebdavI18n.cannotCreateRepository.text(new Object[]{resourceName}));
                }
                if (resolvedParent.getWorkspaceName() != null) {
                    resolvedParent = resolvedParent.withPath("/");
                } else {
                    I18n msg = WebdavI18n.cannotCreateWorkspaceInRepository;
                    throw new WebdavException(msg.text(new Object[]{resourceName, resolvedParent.getRepositoryName()}));
                }
            }
            Node parentNode = this.nodeFor(transaction, resolvedParent);
            this.contentMapper.createFolder(parentNode, resourceName);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    public void createResource(ITransaction transaction, String resourceUri) {
        if ((resourceUri = this.removeTrailingSlash(resourceUri)).endsWith(DS_STORE_SUFFIX)) {
            return;
        }
        int ind = resourceUri.lastIndexOf(47);
        String parentUri = resourceUri.substring(0, ind + 1);
        String resourceName = resourceUri.substring(ind + 1);
        if (resourceName.startsWith("._")) {
            OSX_DOUBLE_DATA.put(resourceUri, null);
            return;
        }
        try {
            ResolvedRequest resolvedParent = this.resolveRequest(transaction, parentUri);
            if (resolvedParent.getPath() == null) {
                if (resolvedParent.getRepositoryName() == null) {
                    throw new WebdavException(WebdavI18n.cannotCreateRepository.text(new Object[]{resourceName}));
                }
                if (resolvedParent.getWorkspaceName() != null) {
                    resolvedParent = resolvedParent.withPath("/");
                } else {
                    I18n msg = WebdavI18n.cannotCreateWorkspaceInRepository;
                    throw new WebdavException(msg.text(new Object[]{resourceName, resolvedParent.getRepositoryName()}));
                }
            }
            Node parentNode = this.nodeFor(transaction, resolvedParent);
            this.contentMapper.createFile(parentNode, resourceName);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    private String removeTrailingSlash(String uri) {
        if (!StringUtil.isBlank((String)uri) && uri.length() > 1 && uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public String[] getChildrenNames(ITransaction transaction, String folderUri) {
        try {
            this.logger.trace("WebDAV getChildrenNames(txn,\"" + folderUri + "\")", new Object[0]);
            ResolvedRequest resolved = this.resolveRequest(transaction, folderUri);
            this.logger.trace("WebDAV -> resolves to: " + resolved, new Object[0]);
            if (resolved.getPath() == null) {
                return this.childrenFor(transaction, resolved);
            }
            Node node = this.nodeFor(transaction, resolved);
            this.logger.trace("WebDAV -> node: " + node, new Object[0]);
            if (!this.isFolder(node)) {
                return null;
            }
            List<String> children = ModeShapeWebdavStore.namesOfChildren(node);
            this.logger.trace("WebDAV -> children: " + children, new Object[0]);
            return children.toArray(new String[children.size()]);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    protected static List<String> namesOfChildren(Node node) throws RepositoryException {
        LinkedList<String> children = new LinkedList<String>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            String name = child.getIndex() == 1 ? child.getName() : child.getName() + "[" + child.getIndex() + "]";
            children.add(name);
        }
        return children;
    }

    public InputStream getResourceContent(ITransaction transaction, String resourceUri) {
        try {
            ResolvedRequest resolved = this.resolveRequest(transaction, resourceUri);
            if (resolved.getPath() == null) {
                return null;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (!this.isFile(node)) {
                return null;
            }
            return this.contentMapper.getResourceContent(node);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    public long getResourceLength(ITransaction transaction, String resourceUri) {
        try {
            ResolvedRequest resolved = this.resolveRequest(transaction, resourceUri);
            if (resolved.getPath() == null) {
                return -1L;
            }
            Node node = this.nodeFor(transaction, resolved);
            return this.contentMapper.getResourceLength(node);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        if (uri.length() == 0) {
            uri = "/";
        }
        StoredObject ob = new StoredObject();
        try {
            this.logger.trace("WebDAV getStoredObject at \"" + uri + "\"", new Object[0]);
            ResolvedRequest resolved = this.resolveRequest(transaction, uri);
            this.logger.debug("WebDAV getStoredObject at \"" + uri + "\" resolved to \"" + resolved + "\"", new Object[0]);
            String path = resolved.getPath();
            if (path == null) {
                if (this.repositoryAndWorkspaceExist(transaction, resolved)) {
                    ob.setFolder(true);
                    Date now = new Date();
                    ob.setCreationDate(now);
                    ob.setLastModified(now);
                    ob.setResourceLength(0L);
                    return ob;
                }
                return null;
            }
            int ind = path.lastIndexOf(47);
            String resourceName = path.substring(ind + 1);
            if (resourceName.startsWith("._")) {
                return null;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (this.isFolder(node)) {
                ob.setFolder(true);
                Date createDate = null;
                createDate = node.hasProperty(CREATED_PROP_NAME) ? node.getProperty(CREATED_PROP_NAME).getDate().getTime() : new Date();
                ob.setCreationDate(createDate);
                ob.setLastModified(new Date());
                ob.setResourceLength(0L);
            } else if (this.isFile(node)) {
                ob.setFolder(false);
                Date createDate = null;
                createDate = node.hasProperty(CREATED_PROP_NAME) ? node.getProperty(CREATED_PROP_NAME).getDate().getTime() : new Date();
                ob.setCreationDate(createDate);
                ob.setLastModified(this.contentMapper.getLastModified(node));
                ob.setResourceLength(this.contentMapper.getResourceLength(node));
            } else {
                ob.setNullResource(true);
            }
        }
        catch (PathNotFoundException pnfe) {
            return null;
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
        return ob;
    }

    public void removeObject(ITransaction transaction, String uri) {
        String resourceName = this.resourceNameFromResourcePath(uri);
        if (resourceName.startsWith("._")) {
            OSX_DOUBLE_DATA.put(uri, null);
            return;
        }
        try {
            ResolvedRequest resolved = this.resolveRequest(transaction, uri);
            if (resolved.getPath() != null) {
                Node node = this.nodeFor(transaction, resolved);
                node.remove();
            }
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    protected String resourceNameFromResourcePath(String path) {
        int ind = path.lastIndexOf(47);
        return path.substring(ind + 1);
    }

    public long setResourceContent(ITransaction transaction, String resourceUri, InputStream content, String contentType, String characterEncoding) {
        if (resourceUri.endsWith(DS_STORE_SUFFIX)) {
            return 0L;
        }
        String resourceName = this.resourceNameFromResourcePath(resourceUri);
        if (resourceName.startsWith("._")) {
            try {
                OSX_DOUBLE_DATA.put(resourceUri, IoUtil.readBytes((InputStream)content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 0L;
        }
        try {
            ResolvedRequest resolved = this.resolveRequest(transaction, resourceUri);
            if (resolved.getPath() == null) {
                return -1L;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (!this.isFile(node)) {
                return -1L;
            }
            return this.contentMapper.setContent(node, resourceName, content, contentType, characterEncoding);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RuntimeException t) {
            throw t;
        }
    }

    private boolean isFile(Node node) throws RepositoryException {
        return this.contentMapper.isFile(node);
    }

    private boolean isFolder(Node node) throws RepositoryException {
        return this.contentMapper.isFolder(node);
    }

    private final ResolvedRequest resolveRequest(ITransaction transaction, String uri) throws WebdavException {
        HttpServletRequest request = THREAD_LOCAL_REQUEST.get();
        return this.requestResolver.resolve(request, uri);
    }

    private Node nodeFor(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).nodeFor(request);
    }

    private boolean repositoryAndWorkspaceExist(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).repositoryAndWorkspaceExist(request);
    }

    private String[] childrenFor(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).childrenFor(request);
    }

    protected final RequestResolver requestResolver() {
        return this.requestResolver;
    }

    protected final Logger logger() {
        return this.logger;
    }

    private WebdavException translate(RepositoryException exception) {
        if (exception instanceof AccessDeniedException) {
            return new org.modeshape.webdav.exceptions.AccessDeniedException((Throwable)exception);
        }
        if (exception instanceof LoginException) {
            return new org.modeshape.webdav.exceptions.AccessDeniedException((Throwable)exception);
        }
        if (exception instanceof PathNotFoundException) {
            return new ObjectNotFoundException((Throwable)exception);
        }
        return new WebdavException((Throwable)exception);
    }

    protected static final class SessionKey {
        protected final String repositoryName;
        protected final String workspaceName;

        protected SessionKey(String repositoryName, String workspaceName) {
            this.repositoryName = repositoryName;
            this.workspaceName = workspaceName;
            assert (this.repositoryName != null);
            assert (this.workspaceName != null);
        }

        public int hashCode() {
            return this.repositoryName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SessionKey) {
                SessionKey that = (SessionKey)obj;
                return this.repositoryName.equals(that.repositoryName) && this.workspaceName.equals(that.workspaceName);
            }
            return false;
        }

        public String toString() {
            return this.repositoryName + "/" + this.workspaceName;
        }
    }

    class JcrSessionTransaction
    implements ITransaction {
        private final Map<SessionKey, Session> sessions = new HashMap<SessionKey, Session>();
        private final Principal principal;

        JcrSessionTransaction(Principal principal) {
            this.principal = principal;
        }

        protected boolean owns(Session session) {
            return this.sessions.containsValue(session);
        }

        Session session(ResolvedRequest request) throws RepositoryException {
            String repositoryName = request.getRepositoryName();
            String workspaceName = request.getWorkspaceName();
            assert (repositoryName != null);
            assert (workspaceName != null);
            SessionKey key = new SessionKey(repositoryName, workspaceName);
            Session result = this.sessions.get(key);
            if (result == null) {
                try {
                    result = RepositoryManager.getSession((HttpServletRequest)request.getRequest(), (String)repositoryName, (String)workspaceName);
                }
                catch (RepositoryException e) {
                    ModeShapeWebdavStore.this.logger().error((Throwable)e, (I18nResource)WebdavI18n.cannotGetRepositorySession, new Object[]{repositoryName});
                    throw e;
                }
                this.sessions.put(key, result);
            }
            return result;
        }

        Node nodeFor(ResolvedRequest request) throws RepositoryException {
            Session session = this.session(request);
            Item item = session.getItem(request.getPath());
            if (item instanceof Property) {
                throw new WebdavException();
            }
            return (Node)item;
        }

        boolean repositoryAndWorkspaceExist(ResolvedRequest request) throws RepositoryException {
            assert (request != null);
            if (request.getRepositoryName() != null) {
                if (request.getWorkspaceName() != null) {
                    try {
                        this.session(request);
                        return true;
                    }
                    catch (NoSuchWorkspaceException e) {
                        return false;
                    }
                }
                return RepositoryManager.getJcrRepositoryNames().contains(request.getRepositoryName());
            }
            return true;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String[] childrenFor(ResolvedRequest request) throws RepositoryException {
            Iterator<Map.Entry<SessionKey, Session>> i$;
            String repositoryName;
            assert (request != null);
            Object var2_2 = null;
            if (request.getRepositoryName() != null) {
                if (request.getWorkspaceName() != null) {
                    try {
                        Session session = this.session(request);
                        List<String> list = ModeShapeWebdavStore.namesOfChildren(session.getRootNode());
                    }
                    catch (NoSuchWorkspaceException e) {
                        return null;
                    }
                }
                repositoryName = request.getRepositoryName();
                i$ = this.sessions.entrySet().iterator();
            } else {
                void var2_5;
                Set set = RepositoryManager.getJcrRepositoryNames();
                if (var2_5 == null) {
                    return null;
                }
                String[] stringArray = var2_5.toArray(new String[var2_5.size()]);
                return stringArray;
            }
            while (i$.hasNext()) {
                Map.Entry<SessionKey, Session> entry = i$.next();
                SessionKey key = entry.getKey();
                if (!repositoryName.equals(key.repositoryName)) continue;
                Session session = entry.getValue();
                try {
                    return session.getWorkspace().getAccessibleWorkspaceNames();
                }
                catch (RepositoryException e) {
                }
            }
            Session session = null;
            try {
                session = RepositoryManager.getSession((HttpServletRequest)request.getRequest(), (String)repositoryName, null);
                String[] stringArray = session.getWorkspace().getAccessibleWorkspaceNames();
                return stringArray;
            }
            catch (RepositoryException repositoryException) {
                ModeShapeWebdavStore.this.logger().error((Throwable)repositoryException, (I18nResource)WebdavI18n.cannotGetRepositorySession, new Object[]{repositoryName});
                throw repositoryException;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        void commit() {
            try {
                for (Session session : this.sessions.values()) {
                    session.save();
                }
            }
            catch (RepositoryException re) {
                throw new WebdavException((Throwable)re);
            }
            finally {
                for (Session session : this.sessions.values()) {
                    try {
                        session.logout();
                    }
                    catch (Throwable t) {}
                }
                this.sessions.clear();
            }
        }
    }
}

