/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoOptions;

public class DoOptionsTest
extends AbstractWebDAVTest {
    @Test
    public void testOptionsOnExistingNode() throws IOException, LockFailedException {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoOptionsTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.one(DoOptionsTest.this.mockReq)).getPathInfo();
                this.will(1.returnValue((Object)"/index.html"));
                ((HttpServletResponse)this.one(DoOptionsTest.this.mockRes)).addHeader("DAV", "1, 2");
                StoredObject indexSo = DoOptionsTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoOptionsTest.this.mockStore)).getStoredObject(DoOptionsTest.this.mockTransaction, "/index.html");
                this.will(1.returnValue((Object)indexSo));
                ((HttpServletResponse)this.one(DoOptionsTest.this.mockRes)).addHeader("Allow", "OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPPATCH, COPY, MOVE, LOCK, UNLOCK, PROPFIND");
                ((HttpServletResponse)this.one(DoOptionsTest.this.mockRes)).addHeader("MS-Author-Via", "DAV");
            }
        });
        DoOptions doOptions = new DoOptions(this.mockStore, new ResourceLocks());
        doOptions.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testOptionsOnNonExistingNode() throws IOException, LockFailedException {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoOptionsTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(DoOptionsTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/index.html"));
                ((HttpServletResponse)this.one(DoOptionsTest.this.mockRes)).addHeader("DAV", "1, 2");
                Object indexSo = null;
                ((IWebdavStore)this.one(DoOptionsTest.this.mockStore)).getStoredObject(DoOptionsTest.this.mockTransaction, "/index.html");
                this.will(2.returnValue(indexSo));
                ((HttpServletResponse)this.one(DoOptionsTest.this.mockRes)).addHeader("Allow", "OPTIONS, MKCOL, PUT");
                ((HttpServletResponse)this.one(DoOptionsTest.this.mockRes)).addHeader("MS-Author-Via", "DAV");
            }
        });
        DoOptions doOptions = new DoOptions(this.mockStore, new ResourceLocks());
        doOptions.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

