/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.collector.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.hibernate.search.query.collector.impl.FieldCacheCollector;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;
import org.hibernate.search.util.impl.CollectionHelper;

final class MapFieldCacheCollectorImpl
extends FieldCacheCollector {
    private final FieldLoadingStrategy collectorStrategy;
    private final Map<Integer, Object> valuePerDocumentId = CollectionHelper.newHashMap();
    private int currentDocBase;

    public MapFieldCacheCollectorImpl(Collector delegate, FieldLoadingStrategy collectorStrategy) {
        super(delegate);
        this.collectorStrategy = collectorStrategy;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        Object collected = this.collectorStrategy.collect(doc);
        this.valuePerDocumentId.put(this.currentDocBase + doc, collected);
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.currentDocBase = docBase;
        this.collectorStrategy.loadNewCacheValues(reader);
        this.delegate.setNextReader(reader, docBase);
    }

    @Override
    public Object getValue(int docId) {
        return this.valuePerDocumentId.get(docId);
    }
}

