/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;

public class TeiidDdlParserTest
extends DdlParserTestHelper
implements TeiidDdlConstants {
    @Before
    public void beforeEach() {
        this.parser = new TeiidDdlParser();
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
        this.scorer = new DdlParserScorer();
    }

    @Test
    public void shouldParseDuplicateFunctions() {
        String functionName = "SourceFunc";
        String content = "CREATE FUNCTION SourceFunc() RETURNS string; CREATE FUNCTION SourceFunc(param string) RETURNS string";
        this.assertScoreAndParse("CREATE FUNCTION SourceFunc() RETURNS string; CREATE FUNCTION SourceFunc(param string) RETURNS string", null, 2);
        List kids = this.rootNode.getChildren();
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createFunction");
        this.assertMixinType((AstNode)kids.get(1), "teiidddl:createFunction");
    }

    @Test
    public void shouldParseDuplicateFunctions1() {
        String content = "CREATE FUNCTION SourceFunc() RETURNS string OPTIONS (UUID 'a'); CREATE FUNCTION SourceFunc1() RETURNS string OPTIONS (UUID 'a')";
        this.assertScoreAndParse("CREATE FUNCTION SourceFunc() RETURNS string OPTIONS (UUID 'a'); CREATE FUNCTION SourceFunc1() RETURNS string OPTIONS (UUID 'a')", null, 2);
        List kids = this.rootNode.childrenWithName("SourceFunc");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createFunction");
        kids = this.rootNode.childrenWithName("SourceFunc1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createFunction");
    }

    @Test
    public void shouldParseMultipleCommands() {
        String content = "CREATE VIEW V1 AS SELECT * FROM PM1.G1 CREATE PROCEDURE FOO(P1 integer) RETURNS (e1 integer, e2 varchar) AS SELECT * FROM PM1.G1;";
        this.assertScoreAndParse("CREATE VIEW V1 AS SELECT * FROM PM1.G1 CREATE PROCEDURE FOO(P1 integer) RETURNS (e1 integer, e2 varchar) AS SELECT * FROM PM1.G1;", null, 2);
        List kids = this.rootNode.childrenWithName("V1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createView");
        kids = this.rootNode.childrenWithName("FOO");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createProcedure");
    }

    @Test
    public void shouldParseMultipleCommands2() {
        String content = "CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140)) AS select tweet.* from (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns created_on string PATH 'created_at', from_user string PATH 'from_user', to_user string PATH 'to_user', profile_image_url string PATH 'profile_image_url', source string PATH 'source', text string PATH 'text') tweet;CREATE VIEW Tweet AS select * FROM twitterview.getTweets;";
        this.assertScoreAndParse("CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140)) AS select tweet.* from (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns created_on string PATH 'created_at', from_user string PATH 'from_user', to_user string PATH 'to_user', profile_image_url string PATH 'profile_image_url', source string PATH 'source', text string PATH 'text') tweet;CREATE VIEW Tweet AS select * FROM twitterview.getTweets;", null, 2);
        List kids = this.rootNode.childrenWithName("getTweets");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createProcedure");
        kids = this.rootNode.childrenWithName("Tweet");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createView");
    }

    @Test
    public void shouldParseInsteadOfTrigger() {
        String content = "CREATE VIEW G1( e1 integer, e2 varchar) AS select * from foo;CREATE TRIGGER ON G1 INSTEAD OF INSERT AS FOR EACH ROW BEGIN ATOMIC insert into g1 (e1, e2) values (1, 'trig');END;CREATE View G2( e1 integer, e2 varchar) AS select * from foo;";
        this.assertScoreAndParse("CREATE VIEW G1( e1 integer, e2 varchar) AS select * from foo;CREATE TRIGGER ON G1 INSTEAD OF INSERT AS FOR EACH ROW BEGIN ATOMIC insert into g1 (e1, e2) values (1, 'trig');END;CREATE View G2( e1 integer, e2 varchar) AS select * from foo;", null, 3);
        List kids = this.rootNode.childrenWithName("G1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)2));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createView");
        this.assertMixinType((AstNode)kids.get(1), "teiidddl:createTrigger");
        kids = this.rootNode.childrenWithName("G2");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createView");
    }

    @Test
    public void shouldParseForeignKey() {
        String content = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));CREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, FOREIGN KEY (g2e1, g2e2) REFERENCES G1 (g1e1, g1e2))";
        this.assertScoreAndParse("CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));CREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, FOREIGN KEY (g2e1, g2e2) REFERENCES G1 (g1e1, g1e2))", null, 2);
        List kids = this.rootNode.childrenWithName("G1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createTable");
        kids = this.rootNode.childrenWithName("G2");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createTable");
    }

    @Test
    public void shouldParseOptionalForeignKey() {
        String content = "CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));CREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, PRIMARY KEY(g2e1, g2e2), FOREIGN KEY (g2e1, g2e2) REFERENCES G1)";
        this.assertScoreAndParse("CREATE FOREIGN TABLE G1(g1e1 integer, g1e2 varchar, PRIMARY KEY(g1e1, g1e2));CREATE FOREIGN TABLE G2( g2e1 integer, g2e2 varchar, PRIMARY KEY(g2e1, g2e2), FOREIGN KEY (g2e1, g2e2) REFERENCES G1)", null, 2);
        List kids = this.rootNode.childrenWithName("G1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createTable");
        kids = this.rootNode.childrenWithName("G2");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createTable");
    }

    @Test
    public void shouldParseAccountsDdl() {
        String content = "CREATE FOREIGN TABLE \"accounts.ACCOUNT\" (  ACCOUNT_ID long NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '`ACCOUNT_ID`', NATIVE_TYPE 'INT'),  SSN string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`SSN`', NATIVE_TYPE 'CHAR'),  STATUS string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`STATUS`', NATIVE_TYPE 'CHAR'),  TYPE string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`TYPE`', NATIVE_TYPE 'CHAR'),  DATEOPENED timestamp NOT NULL DEFAULT 'CURRENT_TIMESTAMP' OPTIONS (ANNOTATION '', NAMEINSOURCE '`DATEOPENED`', NATIVE_TYPE 'TIMESTAMP'),  DATECLOSED timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' OPTIONS (ANNOTATION '', NAMEINSOURCE '`DATECLOSED`', NATIVE_TYPE 'TIMESTAMP')  ) OPTIONS (ANNOTATION '', NAMEINSOURCE '`accounts`.`ACCOUNT`', UPDATABLE TRUE);";
        this.assertScoreAndParse("CREATE FOREIGN TABLE \"accounts.ACCOUNT\" (  ACCOUNT_ID long NOT NULL DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '`ACCOUNT_ID`', NATIVE_TYPE 'INT'),  SSN string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`SSN`', NATIVE_TYPE 'CHAR'),  STATUS string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`STATUS`', NATIVE_TYPE 'CHAR'),  TYPE string(10) OPTIONS (ANNOTATION '', NAMEINSOURCE '`TYPE`', NATIVE_TYPE 'CHAR'),  DATEOPENED timestamp NOT NULL DEFAULT 'CURRENT_TIMESTAMP' OPTIONS (ANNOTATION '', NAMEINSOURCE '`DATEOPENED`', NATIVE_TYPE 'TIMESTAMP'),  DATECLOSED timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' OPTIONS (ANNOTATION '', NAMEINSOURCE '`DATECLOSED`', NATIVE_TYPE 'TIMESTAMP')  ) OPTIONS (ANNOTATION '', NAMEINSOURCE '`accounts`.`ACCOUNT`', UPDATABLE TRUE);", null, 1);
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
    }

    @Test
    public void shouldParsePortfolioBR() {
        String content = "CREATE VIRTUAL FUNCTION performRuleOnData(className string, returnMethodName string, returnIfNull string, VARIADIC z object )RETURNS string OPTIONS (JAVA_CLASS 'org.jboss.teiid.businessrules.udf.RulesUDF',  JAVA_METHOD 'performRuleOnData', VARARGS 'true');CREATE VIEW StockPrices (  symbol string,  price bigdecimal  )  AS     SELECT StockPrices.symbol, StockPrices.price      FROM (EXEC MarketData.getTextFiles('*.txt')) AS f,        TEXTTABLE(f.file COLUMNS symbol string, price bigdecimal HEADER) AS StockPrices;CREATE VIEW Stock (  symbol string,  price bigdecimal,  company_name   varchar(256)  )  AS    SELECT  S.symbol, S.price, A.COMPANY_NAME      FROM StockPrices AS S, Accounts.PRODUCT AS A      WHERE S.symbol = A.SYMBOL;CREATE VIRTUAL PROCEDURE StockValidation() RETURNS (companyname varchar(256), symbol string(10), price bigdecimal, message varchar(256) )  AS    BEGIN      DECLARE String VARIABLES.msg;      CREATE LOCAL TEMPORARY TABLE TEMP (companyname string, symbol string, price bigdecimal, message string);      LOOP ON (SELECT Stock.symbol, Stock.price, Stock.company_name FROM Stock) AS txncursor      BEGIN        VARIABLES.msg = Stocks.performRuleOnData('org.jboss.teiid.quickstart.data.MarketData', 'getInvalidMessage', 'noMsg', txncursor.company_name, txncursor.symbol, txncursor.price);        IF(VARIABLES.msg <> 'NoMsg')          BEGIN            INSERT INTO TEMP (TEMP.companyname, TEMP.symbol, TEMP.price, TEMP.message) VALUES (txncursor.COMPANY_NAME, txncursor.symbol, txncursor.price, VARIABLES.msg);          END      END      SELECT TEMP.companyname, TEMP.symbol, TEMP.price, TEMP.message FROM TEMP;    END";
        this.assertScoreAndParse("CREATE VIRTUAL FUNCTION performRuleOnData(className string, returnMethodName string, returnIfNull string, VARIADIC z object )RETURNS string OPTIONS (JAVA_CLASS 'org.jboss.teiid.businessrules.udf.RulesUDF',  JAVA_METHOD 'performRuleOnData', VARARGS 'true');CREATE VIEW StockPrices (  symbol string,  price bigdecimal  )  AS     SELECT StockPrices.symbol, StockPrices.price      FROM (EXEC MarketData.getTextFiles('*.txt')) AS f,        TEXTTABLE(f.file COLUMNS symbol string, price bigdecimal HEADER) AS StockPrices;CREATE VIEW Stock (  symbol string,  price bigdecimal,  company_name   varchar(256)  )  AS    SELECT  S.symbol, S.price, A.COMPANY_NAME      FROM StockPrices AS S, Accounts.PRODUCT AS A      WHERE S.symbol = A.SYMBOL;CREATE VIRTUAL PROCEDURE StockValidation() RETURNS (companyname varchar(256), symbol string(10), price bigdecimal, message varchar(256) )  AS    BEGIN      DECLARE String VARIABLES.msg;      CREATE LOCAL TEMPORARY TABLE TEMP (companyname string, symbol string, price bigdecimal, message string);      LOOP ON (SELECT Stock.symbol, Stock.price, Stock.company_name FROM Stock) AS txncursor      BEGIN        VARIABLES.msg = Stocks.performRuleOnData('org.jboss.teiid.quickstart.data.MarketData', 'getInvalidMessage', 'noMsg', txncursor.company_name, txncursor.symbol, txncursor.price);        IF(VARIABLES.msg <> 'NoMsg')          BEGIN            INSERT INTO TEMP (TEMP.companyname, TEMP.symbol, TEMP.price, TEMP.message) VALUES (txncursor.COMPANY_NAME, txncursor.symbol, txncursor.price, VARIABLES.msg);          END      END      SELECT TEMP.companyname, TEMP.symbol, TEMP.price, TEMP.message FROM TEMP;    END", null, 4);
        List kids = this.rootNode.childrenWithName("performRuleOnData");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createFunction");
        kids = this.rootNode.childrenWithName("StockPrices");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createView");
        kids = this.rootNode.childrenWithName("Stock");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createView");
        kids = this.rootNode.childrenWithName("StockValidation");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        this.assertMixinType((AstNode)kids.get(0), "teiidddl:createProcedure");
    }
}

