/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.ddl.AbstractDdlSequencerTest;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;

public class TeiidDdlSequencerTest
extends AbstractDdlSequencerTest {
    private Node statementsNode;

    @After
    public void verifyStatementsNode() throws Exception {
        this.verifyPrimaryType(this.statementsNode, "nt:unstructured");
        this.verifyProperty(this.statementsNode, "ddl:parserId", "TEIID");
    }

    @Test
    public void shouldSequenceOptionNamespace() throws Exception {
        this.statementsNode = this.sequenceDdl("ddl/dialect/teiid/optionNamespace.ddl");
        Assert.assertThat((Object)this.statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
        Node optionNamespaceNode = this.statementsNode.getNode("REST");
        this.verifyMixinType(optionNamespaceNode, "teiidddl:optionNamespace");
        this.verifyProperty(optionNamespaceNode, "teiidddl:uri", "http://teiid.org/rest");
        optionNamespaceNode = this.statementsNode.getNode("g1Table");
        this.verifyMixinType(optionNamespaceNode, "teiidddl:createProcedure");
        this.verifyProperty(optionNamespaceNode, "teiidddl:statement", "BEGIN\nSELECT XMLELEMENT(NAME \"all\", XMLAGG(XMLELEMENT(NAME \"row\", XMLFOREST(e1, e2)))) AS xml_out FROM Txns.G1;\nEND");
        Node optionNode = optionNamespaceNode.getNode("{http://teiid.org/rest}METHOD");
        this.verifyMixinType(optionNode, "ddl:statementOption");
        this.verifyProperty(optionNode, "ddl:value", "GET");
        optionNode = optionNamespaceNode.getNode("{http://teiid.org/rest}URI");
        this.verifyMixinType(optionNode, "ddl:statementOption");
        this.verifyProperty(optionNode, "ddl:value", "g1");
    }

    @Test
    public void shouldSequenceFlatFileDdl() throws Exception {
        this.statementsNode = this.sequenceDdl("ddl/dialect/teiid/flatFile.ddl");
        Assert.assertThat((Object)this.statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        Node procedureNode = this.statementsNode.getNode("getFiles");
        this.verifyMixinType(procedureNode, "teiidddl:createProcedure");
        this.verifyProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        Node paramNode = procedureNode.getNode("pathAndPattern");
        this.verifyMixinType(paramNode, "teiidddl:procedureParameter");
        this.verifyProperty(paramNode, "teiidddl:parameterType", "IN");
        this.verifyProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.verifyProperty(paramNode, "teiidddl:result", "false");
        Assert.assertThat((Object)paramNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node optionNode = paramNode.getNode("ANNOTATION");
        this.verifyMixinType(optionNode, "ddl:statementOption");
        this.verifyProperty(optionNode, "ddl:value", "The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.");
        Node resultNode = procedureNode.getNode("resultSet");
        this.verifyMixinType(resultNode, "teiidddl:resultColumns");
        this.verifyProperty(resultNode, "teiidddl:table", "true");
        Assert.assertThat((Object)resultNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
        Node resultColumnNode = resultNode.getNode("file");
        this.verifyMixinType(resultColumnNode, "teiidddl:resultColumn");
        this.verifyProperty(resultColumnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BLOB.toDdl());
        resultColumnNode = resultNode.getNode("filePath");
        this.verifyMixinType(resultColumnNode, "teiidddl:resultColumn");
        this.verifyProperty(resultColumnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        Node optionNode2 = procedureNode.getNode("ANNOTATION");
        this.verifyMixinType(optionNode2, "ddl:statementOption");
        this.verifyProperty(optionNode2, "ddl:value", "Returns files that match the given path and pattern as BLOBs");
        procedureNode = this.statementsNode.getNode("getTextFiles");
        this.verifyMixinType(procedureNode, "teiidddl:createProcedure");
        this.verifyProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        paramNode = procedureNode.getNode("pathAndPattern");
        this.verifyMixinType(paramNode, "teiidddl:procedureParameter");
        this.verifyProperty(paramNode, "teiidddl:parameterType", "IN");
        this.verifyProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.verifyProperty(paramNode, "teiidddl:result", "false");
        Assert.assertThat((Object)paramNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        optionNode = paramNode.getNode("ANNOTATION");
        this.verifyMixinType(optionNode, "ddl:statementOption");
        this.verifyProperty(optionNode, "ddl:value", "The path and pattern of what files to return.  Currently the only pattern supported is *.<ext>, which returns only the files matching the given extension at the given path.");
        resultNode = procedureNode.getNode("resultSet");
        this.verifyMixinType(resultNode, "teiidddl:resultColumns");
        this.verifyProperty(resultNode, "teiidddl:table", "true");
        Assert.assertThat((Object)resultNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
        resultColumnNode = resultNode.getNode("file");
        this.verifyMixinType(resultColumnNode, "teiidddl:resultColumn");
        this.verifyProperty(resultColumnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.CLOB.toDdl());
        resultColumnNode = resultNode.getNode("filePath");
        this.verifyMixinType(resultColumnNode, "teiidddl:resultColumn");
        this.verifyProperty(resultColumnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        optionNode2 = procedureNode.getNode("ANNOTATION");
        this.verifyMixinType(optionNode2, "ddl:statementOption");
        this.verifyProperty(optionNode2, "ddl:value", "Returns text files that match the given path and pattern as CLOBs");
        procedureNode = this.statementsNode.getNode("saveFile");
        this.verifyMixinType(procedureNode, "teiidddl:createProcedure");
        this.verifyProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        paramNode = procedureNode.getNode("filePath");
        this.verifyMixinType(paramNode, "teiidddl:procedureParameter");
        this.verifyProperty(paramNode, "teiidddl:parameterType", "IN");
        this.verifyProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.verifyProperty(paramNode, "teiidddl:result", "false");
        Assert.assertThat((Object)paramNode.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        paramNode = procedureNode.getNode("file");
        this.verifyMixinType(paramNode, "teiidddl:procedureParameter");
        this.verifyProperty(paramNode, "teiidddl:parameterType", "IN");
        this.verifyProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.OBJECT.toDdl());
        this.verifyProperty(paramNode, "teiidddl:result", "false");
        Assert.assertThat((Object)paramNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        optionNode = paramNode.getNode("ANNOTATION");
        this.verifyMixinType(optionNode, "ddl:statementOption");
        this.verifyProperty(optionNode, "ddl:value", "The contents to save.  Can be one of CLOB, BLOB, or XML");
        optionNode2 = procedureNode.getNode("ANNOTATION");
        this.verifyMixinType(optionNode2, "ddl:statementOption");
        this.verifyProperty(optionNode2, "ddl:value", "Saves the given value to the given path.  Any existing file will be overriden.");
    }

    @Test
    public void shouldSequenceTwitterWebServiceDdl() throws Exception {
        this.statementsNode = this.sequenceDdl("ddl/dialect/teiid/twitterWebService.ddl");
        Assert.assertThat((Object)this.statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
        Node procedureNode = this.statementsNode.getNode("invoke");
        this.verifyMixinType(procedureNode, "teiidddl:createProcedure");
        this.verifyProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getNodes().getSize(), (Matcher)Is.is((Object)7L));
        Node paramNode = procedureNode.getNode("result");
        this.verifyMixinType(paramNode, "teiidddl:procedureParameter");
        this.verifyProperty(paramNode, "teiidddl:parameterType", "OUT");
        this.verifyProperty(paramNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.XML.toDdl());
        this.verifyProperty(paramNode, "teiidddl:result", "true");
        Assert.assertThat((Object)paramNode.getNodes().getSize(), (Matcher)Is.is((Object)0L));
        procedureNode = this.statementsNode.getNode("invokeHttp");
        this.verifyMixinType(procedureNode, "teiidddl:createProcedure");
        this.verifyProperty(procedureNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)procedureNode.getNodes().getSize(), (Matcher)Is.is((Object)7L));
    }

    @Test
    public void shouldSequenceMySqlBqtDdl() throws Exception {
        this.statementsNode = this.sequenceDdl("ddl/dialect/teiid/mySqlBqt.ddl");
        Assert.assertThat((Object)this.statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)15L));
    }

    @Test
    public void shouldSequenceAlterOptionsDdl() throws Exception {
        this.statementsNode = this.sequenceDdl("ddl/dialect/teiid/alterOptions.ddl");
        Assert.assertThat((Object)this.statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)26L));
        NodeIterator itr = this.statementsNode.getNodes("myTable");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)11L));
        this.verifyMixinType(itr.nextNode(), "teiidddl:createTable");
        for (int i = 0; i < 10; ++i) {
            this.verifyMixinType(itr.nextNode(), "teiidddl:alterTable");
        }
        itr = this.statementsNode.getNodes("myView");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)11L));
        Node viewNode = itr.nextNode();
        this.verifyMixinType(viewNode, "teiidddl:createView");
        this.verifyProperty(viewNode, "teiidddl:queryExpression", "select e1, e2 from foo.bar");
        Node optionNode = viewNode.getNode("CARDINALITY");
        this.verifyMixinType(optionNode, "ddl:statementOption");
        this.verifyProperty(optionNode, "ddl:value", "12");
        Node v1ColNode = viewNode.getNode("v1");
        Node v2ColNode = viewNode.getNode("v2");
        for (int i = 0; i < 10; ++i) {
            Node alterNode = itr.nextNode();
            this.verifyMixinType(alterNode, "teiidddl:alterView");
            this.verifyProperty(alterNode, "teiidddl:reference", viewNode.getIdentifier());
            Assert.assertThat((Object)alterNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
            Node optionsListNode = alterNode.getNodes().nextNode();
            if (i < 6) {
                this.verifyMixinType(optionsListNode, "teiidddl:alterOptionsList");
                Assert.assertThat((Object)optionsListNode.hasProperty("teiidddl:dropped"), (Matcher)Is.is((Object)(i > 3 ? 1 : 0)));
                Assert.assertThat((Object)optionsListNode.hasProperty("teiidddl:reference"), (Matcher)Is.is((Object)false));
                if (i == 4) {
                    this.verifyProperty(optionsListNode, "teiidddl:dropped", "CARDINALITY");
                    Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)0L));
                    continue;
                }
                if (i == 5) {
                    this.verifyProperty(optionsListNode, "teiidddl:dropped", "FOO");
                    Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)0L));
                    continue;
                }
                Assert.assertThat((Object)optionsListNode.hasProperty("teiidddl:dropped"), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
                Node optionNode2 = optionsListNode.getNodes().nextNode();
                this.verifyMixinType(optionNode2, "ddl:statementOption");
                String name = null;
                String value = null;
                if (i == 0) {
                    name = "CARDINALITY";
                    value = "12";
                } else if (i == 1) {
                    name = "FOO";
                    value = "BAR";
                } else if (i == 2) {
                    name = "CARDINALITY";
                    value = "24";
                } else if (i == 3) {
                    name = "FOO";
                    value = "BARBAR";
                }
                Assert.assertThat((Object)optionNode2.getName(), (Matcher)Is.is((Object)name));
                this.verifyProperty(optionNode2, "ddl:value", value);
                continue;
            }
            this.verifyMixinType(alterNode.getNodes().nextNode(), "teiidddl:alterColumn");
            Assert.assertThat((Object)optionsListNode.hasProperty("teiidddl:dropped"), (Matcher)Is.is((Object)(i > 7 ? 1 : 0)));
            if (i == 6 || i == 8) {
                this.verifyProperty(optionsListNode, "teiidddl:reference", v1ColNode.getIdentifier());
            } else {
                this.verifyProperty(optionsListNode, "teiidddl:reference", v2ColNode.getIdentifier());
            }
            if (i == 8) {
                this.verifyProperty(optionsListNode, "teiidddl:dropped", "NULL_VALUE_COUNT");
                Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)0L));
                continue;
            }
            if (i == 9) {
                this.verifyProperty(optionsListNode, "teiidddl:dropped", "FOO");
                Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)0L));
                continue;
            }
            Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        }
        itr = this.statementsNode.getNodes("myProc");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)4L));
        Node procedureNode = itr.nextNode();
        this.verifyMixinType(procedureNode, "teiidddl:createProcedure");
        Assert.assertThat((Object)procedureNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        for (int i = 0; i < 3; ++i) {
            Node alterNode = itr.nextNode();
            this.verifyMixinType(alterNode, "teiidddl:alterProcedure");
            this.verifyProperty(alterNode, "teiidddl:reference", procedureNode.getIdentifier());
            Assert.assertThat((Object)alterNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
            Node optionsListNode = alterNode.getNodes().nextNode();
            if (i != 1) {
                this.verifyMixinType(optionsListNode, "teiidddl:alterOptionsList");
                Assert.assertThat((Object)optionsListNode.hasProperty("teiidddl:reference"), (Matcher)Is.is((Object)false));
                if (i == 0) {
                    Assert.assertThat((Object)optionsListNode.hasProperty("teiidddl:dropped"), (Matcher)Is.is((Object)false));
                    Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
                    Node optionNode3 = optionsListNode.getNode("NAMEINSOURCE");
                    this.verifyMixinType(optionNode3, "ddl:statementOption");
                    this.verifyProperty(optionNode3, "ddl:value", "x");
                    continue;
                }
                this.verifyProperty(optionsListNode, "teiidddl:dropped", "UPDATECOUNT");
                Assert.assertThat((Object)optionsListNode.getProperty("teiidddl:dropped").getValues()[1].getString(), (Matcher)Is.is((Object)"NAMEINSOURCE"));
                Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)0L));
                continue;
            }
            this.verifyMixinType(optionsListNode, "teiidddl:alterParameter");
            Assert.assertThat((Object)optionsListNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
            Node p2ParmNode = procedureNode.getNode("p2");
            this.verifyProperty(optionsListNode, "teiidddl:reference", p2ParmNode.getIdentifier());
            Node optionNode4 = optionsListNode.getNode("x");
            this.verifyMixinType(optionNode4, "ddl:statementOption");
            this.verifyProperty(optionNode4, "ddl:value", "y");
            optionNode4 = optionsListNode.getNode("a");
            this.verifyMixinType(optionNode4, "ddl:statementOption");
            this.verifyProperty(optionNode4, "ddl:value", "b");
        }
    }

    @Test
    public void shouldSequenceCreateTriggerDdl() throws Exception {
        this.statementsNode = this.sequenceDdl("ddl/dialect/teiid/createTrigger.ddl");
        Assert.assertThat((Object)this.statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)5L));
        NodeIterator itr = this.statementsNode.getNodes("myView");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)2L));
        Node viewNode = itr.nextNode();
        this.verifyMixinType(viewNode, "teiidddl:createView");
        this.verifyProperty(viewNode, "teiidddl:queryExpression", "select * from foo");
        Assert.assertThat((Object)viewNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
        Node triggerNode = itr.nextNode();
        this.verifyMixinType(triggerNode, "teiidddl:createTrigger");
        this.verifyProperty(triggerNode, "teiidddl:insteadOf", "INSERT");
        this.verifyProperty(triggerNode, "teiidddl:atomic", "false");
        this.verifyProperty(triggerNode, "teiidddl:tableRef", viewNode.getIdentifier());
        NodeIterator actionItr = triggerNode.getNodes();
        Assert.assertThat((Object)actionItr.getSize(), (Matcher)Is.is((Object)3L));
        Node actionNode = actionItr.nextNode();
        Assert.assertThat((Object)actionNode.getName(), (Matcher)Is.is((Object)"rowAction"));
        this.verifyMixinType(actionNode, "teiidddl:triggerRowAction");
        this.verifyProperty(actionNode, "teiidddl:action", "insert into myView (age, name) values (4, 'Lucas');");
        actionNode = actionItr.nextNode();
        Assert.assertThat((Object)actionNode.getName(), (Matcher)Is.is((Object)"rowAction"));
        this.verifyMixinType(actionNode, "teiidddl:triggerRowAction");
        this.verifyProperty(actionNode, "teiidddl:action", "insert into myView (age, name) values (6, 'Brady');");
        actionNode = actionItr.nextNode();
        Assert.assertThat((Object)actionNode.getName(), (Matcher)Is.is((Object)"rowAction"));
        this.verifyMixinType(actionNode, "teiidddl:triggerRowAction");
        this.verifyProperty(actionNode, "teiidddl:action", "insert into myView (age, name) values (11, 'Joshua');");
        itr = this.statementsNode.getNodes("HS_VIEW");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)3L));
        viewNode = itr.nextNode();
        this.verifyMixinType(viewNode, "teiidddl:createView");
        this.verifyProperty(viewNode, "teiidddl:queryExpression", "select * from Accounts.HEALTHSTATE");
        Assert.assertThat((Object)viewNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        triggerNode = itr.nextNode();
        this.verifyMixinType(triggerNode, "teiidddl:createTrigger");
        this.verifyProperty(triggerNode, "teiidddl:insteadOf", "INSERT");
        this.verifyProperty(triggerNode, "teiidddl:atomic", "true");
        this.verifyProperty(triggerNode, "teiidddl:tableRef", viewNode.getIdentifier());
        Assert.assertThat((Object)triggerNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node actionNode2 = triggerNode.getNodes().nextNode();
        Assert.assertThat((Object)actionNode2.getName(), (Matcher)Is.is((Object)"rowAction"));
        this.verifyMixinType(actionNode2, "teiidddl:triggerRowAction");
        this.verifyProperty(actionNode2, "teiidddl:action", "SELECT RepHealth(New.HEALTHTIME, New.POLICYKEY, New.OBJKEY, New.HEALTHSTATE) from HS_VIEW;");
        triggerNode = itr.nextNode();
        this.verifyMixinType(triggerNode, "teiidddl:createTrigger");
        this.verifyProperty(triggerNode, "teiidddl:insteadOf", "UPDATE");
        this.verifyProperty(triggerNode, "teiidddl:atomic", "true");
        this.verifyProperty(triggerNode, "teiidddl:tableRef", viewNode.getIdentifier());
        Assert.assertThat((Object)triggerNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        actionNode2 = triggerNode.getNodes().nextNode();
        Assert.assertThat((Object)actionNode2.getName(), (Matcher)Is.is((Object)"rowAction"));
        this.verifyMixinType(actionNode2, "teiidddl:triggerRowAction");
        this.verifyProperty(actionNode2, "teiidddl:action", "SELECT RepHealth(New.HEALTHTIME, New.POLICYKEY, New.OBJKEY, New.HEALTHSTATE) from HS_VIEW;");
    }

    @Test
    public void shouldSequenceAccountsDdl() throws Exception {
        this.statementsNode = this.sequenceDdl("ddl/dialect/teiid/accounts.ddl");
        Assert.assertThat((Object)this.statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)5L));
        Node tableNode = this.statementsNode.getNode("accounts.ACCOUNT");
        this.verifyMixinType(tableNode, "teiidddl:createTable");
        this.verifyProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        NodeIterator itr = tableNode.getNodes("ACCOUNT_ID");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)1L));
        Node columnNode = itr.nextNode();
        this.verifyProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.LONG.toDdl());
        this.verifyProperty(columnNode, "ddl:defaultValue", 0L);
        Node optionNode = columnNode.getNode("NAMEINSOURCE");
        this.verifyMixinType(optionNode, "ddl:statementOption");
        this.verifyProperty(optionNode, "ddl:value", "`ACCOUNT_ID`");
        optionNode = columnNode.getNode("NATIVE_TYPE");
        this.verifyMixinType(optionNode, "ddl:statementOption");
        this.verifyProperty(optionNode, "ddl:value", "INT");
        itr = tableNode.getNodes("SSN");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)1L));
        columnNode = itr.nextNode();
        this.verifyProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.verifyProperty(columnNode, "ddl:datatypeLength", 10L);
        itr = tableNode.getNodes("STATUS");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)1L));
        columnNode = itr.nextNode();
        this.verifyProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.verifyProperty(columnNode, "ddl:datatypeLength", 10L);
        itr = tableNode.getNodes("TYPE");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)1L));
        columnNode = itr.nextNode();
        this.verifyProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.verifyProperty(columnNode, "ddl:datatypeLength", 10L);
        itr = tableNode.getNodes("DATEOPENED");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)1L));
        columnNode = itr.nextNode();
        this.verifyProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.TIMESTAMP.toDdl());
        this.verifyProperty(columnNode, "ddl:nullable", "NOT NULL");
        this.verifyProperty(columnNode, "ddl:defaultValue", "CURRENT_TIMESTAMP");
        itr = tableNode.getNodes("DATECLOSED");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)1L));
        columnNode = itr.nextNode();
        this.verifyProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.TIMESTAMP.toDdl());
        this.verifyProperty(columnNode, "ddl:nullable", "NOT NULL");
        this.verifyProperty(columnNode, "ddl:defaultValue", "0000-00-00 00:00:00");
        Node optionNode2 = tableNode.getNode("NAMEINSOURCE");
        this.verifyMixinType(optionNode2, "ddl:statementOption");
        this.verifyProperty(optionNode2, "ddl:value", "`accounts`.`ACCOUNT`");
        optionNode2 = tableNode.getNode("UPDATABLE");
        this.verifyMixinType(optionNode2, "ddl:statementOption");
        this.verifyProperty(optionNode2, "ddl:value", "TRUE");
        tableNode = this.statementsNode.getNode("accounts.CUSTOMER");
        this.verifyMixinType(tableNode, "teiidddl:createTable");
        this.verifyProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        tableNode = this.statementsNode.getNode("accounts.HOLDINGS");
        this.verifyMixinType(tableNode, "teiidddl:createTable");
        this.verifyProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        tableNode = this.statementsNode.getNode("accounts.PRODUCT");
        this.verifyMixinType(tableNode, "teiidddl:createTable");
        this.verifyProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        tableNode = this.statementsNode.getNode("accounts.SUBSCRIPTIONS");
        this.verifyMixinType(tableNode, "teiidddl:createTable");
        this.verifyProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
    }
}

