/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.flags;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.context.Flag;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.UnnnecessaryLoadingTest;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.flags.FlagsEnabledTest")
@CleanupAfterMethod
public class FlagsEnabledTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = FlagsEnabledTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        builder.locking().writeSkewCheck(true).isolationLevel(IsolationLevel.REPEATABLE_READ).versioning().enable().scheme(VersioningScheme.SIMPLE).loaders().addStore().cacheStore((CacheStore)new UnnnecessaryLoadingTest.CountingCacheStore()).loaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).transaction().syncCommitPhase(true);
        this.createClusteredCaches(2, "replication", builder);
    }

    UnnnecessaryLoadingTest.CountingCacheStore getCacheStore(Cache cache) {
        CacheLoaderManager clm = TestingUtil.extractComponent(cache, CacheLoaderManager.class);
        ChainingCacheStore ccs = (ChainingCacheStore)clm.getCacheLoader();
        return (UnnnecessaryLoadingTest.CountingCacheStore)((Object)ccs.getStores().keySet().iterator().next());
    }

    public void testWithFlagsSemantics() {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        assert (this.getCacheStore(cache1).numLoads == 0);
        assert (this.getCacheStore(cache2).numLoads == 0);
        AdvancedCache cache1LocalOnly = cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
        cache1LocalOnly.put((Object)"key", (Object)"value1");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (((String)cache1.get((Object)"key")).equals("value1"));
        assert (((String)cache2.get((Object)"key")).equals("value2"));
        assert (this.getCacheStore(cache1).numLoads == 1);
        assert (this.getCacheStore(cache2).numLoads == 1);
        assert (this.getCacheStore((Cache)cache2) != this.getCacheStore((Cache)cache1));
        cache1.put((Object)"nonLocal", (Object)"value");
        assert ("value".equals(cache2.get((Object)"nonLocal")));
        assert (this.getCacheStore(cache1).numLoads == 2);
        assert (this.getCacheStore(cache2).numLoads == 1);
        AdvancedCache cache1SkipRemoteAndStores = cache1LocalOnly.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE});
        cache1SkipRemoteAndStores.put((Object)"again", (Object)"value");
        assert (this.getCacheStore(cache1).numLoads == 2);
        assert (this.getCacheStore(cache2).numLoads == 1);
        assert (((String)cache1.get((Object)"again")).equals("value"));
        assert (cache2.get((Object)"again") == null);
        assert (this.getCacheStore(cache1).numLoads == 2);
        assert (this.getCacheStore(cache2).numLoads == 2);
        assert (cache2.get((Object)"again") == null);
        assert (this.getCacheStore(cache2).numLoads == 3);
        assert (cache2.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get((Object)"again") == null);
        assert (this.getCacheStore(cache2).numLoads == 3);
        assert (this.getCacheStore(cache1).numLoads == 2);
        assert (cache1LocalOnly.get((Object)"localStored") == null);
        assert (this.getCacheStore(cache1).numLoads == 3);
    }

    public void testWithFlagsAndDelegateCache() {
        Object c1 = this.advancedCache(0, "replication");
        AdvancedCache c2 = this.advancedCache(1, "replication");
        c1 = new CustomDelegateCache(c1);
        c1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)1, (Object)"v1");
        AssertJUnit.assertEquals(null, (String)((String)c2.get((Object)1)));
    }

    public void testReplicateSkipCacheLoad(Method m) {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        assert (this.getCacheStore(cache1).numLoads == 0);
        assert (this.getCacheStore(cache2).numLoads == 0);
        String v = TestingUtil.v(m, 1);
        String k = TestingUtil.k(m, 1);
        cache1.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).put((Object)k, (Object)v);
        assert (v.equals(cache2.get((Object)k)));
        assert (this.getCacheStore(cache1).numLoads == 0);
        assert (this.getCacheStore(cache2).numLoads == 0);
    }

    public void testReplicateSkipCacheLoaderWithinTxInCoordinator(Method m) throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, "replication");
        AdvancedCache cache2 = this.advancedCache(1, "replication");
        this.doReplicateSkipCacheLoaderWithinTx(m, cache1, cache2);
    }

    public void testReplicateSkipCacheLoaderWithinTxInNonCoordinator(Method m) throws Exception {
        AdvancedCache cache1 = this.cache(0, "replication").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "replication").getAdvancedCache();
        this.doReplicateSkipCacheLoaderWithinTx(m, (AdvancedCache<String, String>)cache2, (AdvancedCache<String, String>)cache1);
    }

    private void doReplicateSkipCacheLoaderWithinTx(Method m, final AdvancedCache<String, String> cache1, AdvancedCache<String, String> cache2) throws Exception {
        assert (this.getCacheStore(cache1).numLoads == 0);
        assert (this.getCacheStore(cache2).numLoads == 0);
        final String v = TestingUtil.v(m, 1);
        final String k = TestingUtil.k(m, 1);
        TestingUtil.withTx(cache1.getTransactionManager(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache1.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).put((Object)k, (Object)v);
                return null;
            }
        });
        assert (v.equals(cache2.get((Object)k)));
        assert (this.getCacheStore(cache1).numLoads == 0);
        assert (this.getCacheStore(cache2).numLoads == 0);
    }

    public static class CustomDelegateCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        public CustomDelegateCache(AdvancedCache<K, V> cache) {
            super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

                public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                    return new CustomDelegateCache(cache);
                }
            });
        }
    }
}

