/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMapTestAssertions;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.APITest")
public class APITest
extends AbstractInfinispanTest {
    Cache<String, Object> cache;
    TransactionManager tm;
    private CacheContainer cacheContainer;

    @BeforeTest
    public void setUp() {
        Configuration c = new Configuration();
        c.setInvocationBatchingEnabled(true);
        this.cacheContainer = TestCacheManagerFactory.createCacheManager(c);
        this.cache = this.cacheContainer.getCache();
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterTest(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cacheContainer);
        this.cache = null;
        this.tm = null;
    }

    @AfterMethod(alwaysRun=true)
    public void clearUp() throws SystemException {
        if (this.tm.getTransaction() != null) {
            try {
                this.tm.rollback();
            }
            catch (Exception ignored) {
                this.tm.suspend();
            }
        }
        this.cache.clear();
    }

    public void testAtomicMap() {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"map");
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
        assert (this.cache.containsKey((Object)"map"));
        map.put((Object)"blah", (Object)"blah");
        assert (map.size() == 1);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"blah"));
        map.clear();
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
        assert (this.cache.containsKey((Object)"map"));
        AtomicMapLookup.removeAtomicMap(this.cache, (Object)"map");
        assert (!this.cache.containsKey((Object)"map"));
    }

    public void testReadSafetyEmptyCache() throws Exception {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"map");
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
        this.tm.begin();
        map.put((Object)"blah", (Object)"blah");
        assert (map.size() == 1);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"blah"));
        Transaction t = this.tm.suspend();
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
        this.tm.resume(t);
        this.tm.commit();
        assert (map.size() == 1);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"blah"));
        map.clear();
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
    }

    public void testReadSafetyNotEmptyCache() throws Exception {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"map");
        this.tm.begin();
        map.put((Object)"blah", (Object)"blah");
        assert (((String)map.get((Object)"blah")).equals("blah"));
        Transaction t = this.tm.suspend();
        assert (map.isEmpty());
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
        this.tm.resume(t);
        this.tm.commit();
        assert (map.size() == 1);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"blah"));
        map.clear();
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
    }

    public void testReadSafetyRollback() throws Exception {
        AtomicMap map = AtomicMapLookup.getAtomicMap(this.cache, (Object)"map");
        this.tm.begin();
        map.put((Object)"blah", (Object)"blah");
        assert (map.size() == 1);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"blah"));
        Transaction t = this.tm.suspend();
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
        this.tm.resume(t);
        this.tm.rollback();
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(this.cache, "map");
    }
}

