/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.ConfigurationUnitTest")
public class ConfigurationUnitTest {
    @Test
    public void testBuild() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.build();
    }

    @Test
    public void testCreateCache() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()));
    }

    @Test
    public void testAdapt() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        LegacyConfigurationAdaptor.adapt((Configuration)cb.build());
    }

    @Test
    public void testEvictionMaxEntries() {
        Configuration configuration = new ConfigurationBuilder().eviction().maxEntries(20).build();
        org.infinispan.config.Configuration legacy = LegacyConfigurationAdaptor.adapt((Configuration)configuration);
        Assert.assertEquals((int)legacy.getEvictionMaxEntries(), (int)20);
    }

    @Test
    public void testDistSyncAutoCommit() {
        Configuration configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).transaction().autoCommit(true).build();
        org.infinispan.config.Configuration legacy = LegacyConfigurationAdaptor.adapt((Configuration)configuration);
        Assert.assertTrue((boolean)legacy.isTransactionAutoCommit());
        Assert.assertEquals((String)legacy.getCacheMode().name(), (String)CacheMode.DIST_SYNC.name());
    }

    @Test
    public void testDummyTMGetCache() throws Exception {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.transaction().use1PcForAutoCommitTransactions(true).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                this.cm.getCache();
            }
        });
    }

    @Test
    public void testGetCache() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                this.cm.getCache();
            }
        });
    }

    @Test
    public void testDefineNamedCache() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                this.cm.defineConfiguration("foo", new ConfigurationBuilder().build());
            }
        });
    }

    @Test
    public void testGetAndPut() throws Exception {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                Cache cache = this.cm.getCache();
                cache.put((Object)"Foo", (Object)"2");
                cache.put((Object)"Bar", (Object)"4");
                Assert.assertEquals((String)((String)cache.get((Object)"Foo")), (String)"2");
                Assert.assertEquals((String)((String)cache.get((Object)"Bar")), (String)"4");
            }
        });
    }

    @Test
    public void testReplAsyncWithQueue() {
        Configuration configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_ASYNC).async().useReplQueue(true).replQueueInterval(1222L).build();
        org.infinispan.config.Configuration legacy = LegacyConfigurationAdaptor.adapt((Configuration)configuration);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testInvocationBatchingAndNonTransactional() throws Exception {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).invocationBatching().enable();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(cb)));
    }

    @Test
    public void testConsistentHash() {
        Configuration config = LegacyConfigurationAdaptor.adapt((org.infinispan.config.Configuration)new org.infinispan.config.Configuration());
        Assert.assertNull((Object)config.clustering().hash().consistentHash());
    }

    @Test
    public void testDisableL1() {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager(new ConfigurationBuilder(), new TransportFlags())){

            @Override
            public void call() {
                ConfigurationBuilder cb = new ConfigurationBuilder();
                cb.clustering().cacheMode(CacheMode.DIST_SYNC).l1().disable().disableOnRehash();
                this.cm.defineConfiguration("testConfigCache", cb.build());
                Cache cache = this.cm.getCache("testConfigCache");
                assert (!cache.getCacheConfiguration().clustering().l1().enabled());
                assert (!cache.getCacheConfiguration().clustering().l1().onRehash());
            }
        });
    }

    @Test
    public void testClearCacheLoaders() {
        Configuration c = new ConfigurationBuilder().loaders().addLoader().loaders().clearCacheLoaders().build();
        Assert.assertEquals((int)c.loaders().cacheLoaders().size(), (int)0);
    }

    @Test(expectedExceptions={ConfigurationException.class})
    public void testClusterNameNull() {
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.transport().clusterName(null).build();
    }

    @Test
    public void testSchema() throws Exception {
        FileLookup lookup = FileLookupFactory.newInstance();
        URL schemaFile = lookup.lookupFileLocation("schema/infinispan-config-5.2.xsd", Thread.currentThread().getContextClassLoader());
        StreamSource xmlFile = new StreamSource(lookup.lookupFile("configs/all.xml", Thread.currentThread().getContextClassLoader()));
        SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFile).newValidator().validate(xmlFile);
    }

    public void testEvictionWithoutStrategy() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.eviction().maxEntries(76767);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(cb)){

            @Override
            public void call() {
                Configuration cfg = this.cm.getCache().getCacheConfiguration();
                assert (cfg.eviction().maxEntries() == 76767);
                assert (cfg.eviction().strategy() != EvictionStrategy.NONE);
            }
        });
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNumOwners() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.clustering().hash().numOwners(5);
        Configuration c = cb.build();
        Assert.assertEquals((int)5, (int)c.clustering().hash().numOwners());
        cb.clustering().hash().numOwners(0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void numVirtualNodes() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().cacheMode(CacheMode.DIST_SYNC);
        cb.clustering().hash().numSegments(5);
        Configuration c = cb.build();
        Assert.assertEquals((int)5, (int)c.clustering().hash().numSegments());
        cb.clustering().hash().numSegments(0);
    }

    public void testEnableVersioning() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.versioning().enable();
        org.infinispan.config.Configuration adapt = LegacyConfigurationAdaptor.adapt((Configuration)builder.build());
        assert (adapt.isEnableVersioning());
    }

    public void testNoneIsolationLevel() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.locking().isolationLevel(IsolationLevel.NONE);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            @Override
            public void call() {
                Configuration cfg = this.cm.getCache().getCacheConfiguration();
                Assert.assertEquals((Object)IsolationLevel.NONE, (Object)cfg.locking().isolationLevel());
            }
        });
    }

    public void testNoneIsolationLevelInCluster() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.locking().isolationLevel(IsolationLevel.NONE).clustering().cacheMode(CacheMode.REPL_SYNC).build();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager(builder)){

            @Override
            public void call() {
                Configuration cfg = this.cm.getCache().getCacheConfiguration();
                Assert.assertEquals((Object)IsolationLevel.READ_COMMITTED, (Object)cfg.locking().isolationLevel());
            }
        });
    }

    public void testConfigureMarshaller() {
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.serialization().marshaller((Marshaller)new TestObjectStreamMarshaller());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(gc, new ConfigurationBuilder())){

            @Override
            public void call() {
                this.cm.getCache();
            }
        });
    }
}

