/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="container.versioning.AbstractClusteredWriteSkewTest", groups={"functional"})
public abstract class AbstractClusteredWriteSkewTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(this.getCacheMode()).versioning().enable().scheme(VersioningScheme.SIMPLE).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).transaction().lockingMode(LockingMode.OPTIMISTIC).syncCommitPhase(true);
        this.decorate(builder);
        this.createCluster(builder, this.clusterSize());
        this.waitForClusterToForm();
    }

    protected void decorate(ConfigurationBuilder builder) {
    }

    protected abstract CacheMode getCacheMode();

    protected abstract int clusterSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, description="Fails randomly, see ISPN-2264")
    public void testSharedCounter() {
        int counterMaxValue = 200;
        Cache c1 = this.cache(0);
        Cache c2 = this.cache(1);
        c1.put((Object)"counter", (Object)0);
        assert ((Integer)c1.get((Object)"counter") == 0) : "Initial value is different from zero in cache 1";
        assert ((Integer)c2.get((Object)"counter") == 0) : "Initial value is different from zero in cache 2";
        ConcurrentSkipListSet<Integer> uniqueValuesIncremented = new ConcurrentSkipListSet<Integer>();
        Future<Boolean> f1 = this.fork(new IncrementCounterTask(c1, uniqueValuesIncremented, counterMaxValue));
        Future<Boolean> f2 = this.fork(new IncrementCounterTask(c2, uniqueValuesIncremented, counterMaxValue));
        try {
            Boolean unique1 = f1.get(30L, TimeUnit.SECONDS);
            Boolean unique2 = f2.get(30L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)unique1, (String)(c1.getName() + " has put a duplicate value"));
            Assert.assertTrue((boolean)unique2, (String)(c2.getName() + " has put a duplicate value"));
        }
        catch (InterruptedException e) {
            assert (false) : "Interrupted exception while running the test";
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Exception running updater threads", (Throwable)e);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Timed out waiting for updater threads");
        }
        finally {
            f1.cancel(true);
            f2.cancel(true);
        }
        assert ((Integer)c1.get((Object)"counter") >= counterMaxValue) : "Final value is less than " + counterMaxValue + " in cache 1";
        assert ((Integer)c2.get((Object)"counter") >= counterMaxValue) : "Final value is less than " + counterMaxValue + " in cache 2";
    }

    private class IncrementCounterTask
    implements Callable<Boolean> {
        private Cache<String, Integer> cache;
        private ConcurrentSkipListSet<Integer> uniqueValuesSet;
        private TransactionManager transactionManager;
        private int lastValue;
        private boolean unique = true;
        private int counterMaxValue;

        public IncrementCounterTask(Cache<String, Integer> cache, ConcurrentSkipListSet<Integer> uniqueValuesSet, int counterMaxValue) {
            this.cache = cache;
            this.transactionManager = cache.getAdvancedCache().getTransactionManager();
            this.uniqueValuesSet = uniqueValuesSet;
            this.lastValue = 0;
            this.counterMaxValue = counterMaxValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws InterruptedException {
            int failuresCounter = 0;
            while (this.lastValue < this.counterMaxValue && !Thread.interrupted()) {
                boolean success = false;
                try {
                    this.transactionManager.begin();
                    Integer value = (Integer)this.cache.get((Object)"counter");
                    value = value + 1;
                    this.lastValue = value;
                    this.cache.put((Object)"counter", (Object)value);
                    this.transactionManager.commit();
                    this.unique = this.uniqueValuesSet.add(value);
                    success = true;
                }
                catch (Exception e) {
                    Assert.assertTrue((++failuresCounter < 10 * this.counterMaxValue ? 1 : 0) != 0, (String)"Too many failures incrementing the counter");
                }
                finally {
                    if (!success) {
                        try {
                            if (this.transactionManager.getStatus() != 6) {
                                this.transactionManager.rollback();
                            }
                        }
                        catch (Throwable t) {
                            AbstractClusteredWriteSkewTest.this.log.trace((Object)"Exception during rollback", t);
                        }
                    }
                    Assert.assertTrue((boolean)this.unique, (String)("Duplicate value found in " + AbstractClusteredWriteSkewTest.this.address(this.cache) + " (value=" + this.lastValue + ")"));
                }
            }
            return this.unique;
        }
    }
}

