/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.Iterator;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.distexec.mapreduce.Book;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.BookSearchTest")
public abstract class BookSearchTest
extends MultipleCacheManagersTest {
    public void testBookSearch() {
        Cache c1 = this.cache(0, "bookSearch");
        c1.put((Object)"1", (Object)new Book("Seam in Action", "Dan Allen", "Manning"));
        c1.put((Object)"2", (Object)new Book("Hibernate Search in Action", "Emmanuel Bernard and John Griffin", "Manning"));
        c1.put((Object)"3", (Object)new Book("Metaprogramming Ruby", "Paolo Perrotta", "The Pragmatic Programmers"));
        for (int i = 0; i < 4; ++i) {
            this.verifySearch(this.cache(i, "bookSearch"));
        }
    }

    private void verifySearch(Cache cache) {
        MapReduceTask queryTask = new MapReduceTask(cache);
        queryTask.mappedWith((Mapper)new TitleBookSearcher("Hibernate Search in Action")).reducedWith((Reducer)new BookReducer());
        Map queryResult = queryTask.execute();
        assert (queryResult.size() == 1);
        assert ("Hibernate Search in Action".equals(((Book)queryResult.values().iterator().next()).title));
    }

    static class BookReducer
    implements Reducer<String, Book> {
        private static final long serialVersionUID = 5686049814166522660L;

        BookReducer() {
        }

        public Book reduce(String reducedKey, Iterator<Book> iter) {
            return iter.next();
        }
    }

    static class TitleBookSearcher
    implements Mapper<String, Book, String, Book> {
        private static final long serialVersionUID = -7443288752468217500L;
        final String title;

        public TitleBookSearcher(String title) {
            this.title = title;
        }

        public void map(String key, Book value, Collector<String, Book> collector) {
            if (this.title.equals(value.title)) {
                collector.emit((Object)key, (Object)value);
            }
        }
    }
}

