/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.replication.AsyncAPINonTxSyncReplTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.data.Key;
import org.infinispan.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.AsyncAPINonTxSyncDistTest")
public class AsyncAPINonTxSyncDistTest
extends AsyncAPINonTxSyncReplTest {
    protected Configuration getConfig(boolean txEnabled) {
        return AsyncAPINonTxSyncDistTest.getDefaultClusteredConfig(this.sync() ? Configuration.CacheMode.DIST_SYNC : Configuration.CacheMode.DIST_ASYNC, txEnabled);
    }

    @Override
    protected void assertOnAllCaches(final Key k, final String v, final Cache c1, final Cache c2) {
        if (!this.sync()) {
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return Util.safeEquals((Object)c1.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)k), (Object)v) && Util.safeEquals((Object)c2.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)k), (Object)v);
                }
            });
        } else {
            Object real;
            assert (Util.safeEquals((Object)(real = c1.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)k)), (Object)v)) : "Error on cache 1.  Expected " + v + " and got " + real;
            assert (Util.safeEquals((Object)(real = c2.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).get((Object)k)), (Object)v)) : "Error on cache 2.  Expected " + v + " and got " + real;
        }
    }
}

