/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.OwnershipStatistics;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ch.DefaultConsistentHashFactoryTest")
public class DefaultConsistentHashFactoryTest
extends AbstractInfinispanTest {
    private int iterationCount = 0;

    protected ConsistentHashFactory createConsistentHashFactory() {
        return new DefaultConsistentHashFactory();
    }

    public void testConsistentHashDistribution() {
        int[] numSegments = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
        int[] numNodes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 100, 1000};
        int[] numOwners = new int[]{1, 2, 3, 5};
        ConsistentHashFactory chf = this.createConsistentHashFactory();
        MurmurHash3 hashFunction = new MurmurHash3();
        for (int nn : numNodes) {
            ArrayList<TestAddress> nodes = new ArrayList<TestAddress>(nn);
            for (int j = 0; j < nn; ++j) {
                nodes.add(new TestAddress(j));
            }
            for (int ns : numSegments) {
                if (nn >= ns) continue;
                for (int no : numOwners) {
                    DefaultConsistentHash ch = (DefaultConsistentHash)chf.create((Hash)hashFunction, no, ns, nodes);
                    this.checkDistribution((ConsistentHash)ch, false);
                    this.testConsistentHashModifications((ConsistentHashFactory<DefaultConsistentHash>)chf, ch);
                }
            }
        }
    }

    private void testConsistentHashModifications(ConsistentHashFactory<DefaultConsistentHash> chf, DefaultConsistentHash baseCH) {
        int[][] nodeChanges = new int[][]{{1, 0}, {2, 0}, {0, 1}, {0, 2}, {1, 1}, {1, 2}, {2, 1}, {10, 0}, {0, 10}};
        Assert.assertSame((Object)baseCH, (Object)chf.updateMembers((ConsistentHash)baseCH, baseCH.getMembers()));
        Assert.assertSame((Object)baseCH, (Object)chf.rebalance((ConsistentHash)baseCH));
        int nodeIndex = baseCH.getMembers().size();
        for (int i = 0; i < nodeChanges.length; ++i) {
            int k;
            int nodesToAdd = nodeChanges[i][0];
            int nodesToRemove = nodeChanges[i][1];
            if (nodesToRemove > baseCH.getMembers().size()) break;
            ArrayList<Address> newMembers = new ArrayList<Address>(baseCH.getMembers());
            for (k = 0; k < nodesToRemove; ++k) {
                newMembers.remove(Math.abs(baseCH.getHashFunction().hash(k) % newMembers.size()));
            }
            for (k = 0; k < nodesToAdd; ++k) {
                newMembers.add(new TestAddress(nodeIndex++));
            }
            this.log.tracef("Testing consistent hash modifications iteration %d. Initial CH is %s. New members are %s", (Object)this.iterationCount, (Object)baseCH, newMembers);
            baseCH = this.checkModificationsIteration(chf, baseCH, nodesToAdd, nodesToRemove, newMembers);
            ++this.iterationCount;
        }
    }

    private DefaultConsistentHash checkModificationsIteration(ConsistentHashFactory<DefaultConsistentHash> chf, DefaultConsistentHash baseCH, int nodesToAdd, int nodesToRemove, List<Address> newMembers) {
        int actualNumOwners = Math.min(newMembers.size(), baseCH.getNumOwners());
        DefaultConsistentHash updatedMembersCH = (DefaultConsistentHash)chf.updateMembers((ConsistentHash)baseCH, newMembers);
        if (nodesToRemove > 0) {
            for (int l = 0; l < updatedMembersCH.getNumSegments(); ++l) {
                Assert.assertTrue((updatedMembersCH.locateOwnersForSegment(l).size() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((updatedMembersCH.locateOwnersForSegment(l).size() <= actualNumOwners ? 1 : 0) != 0);
            }
        }
        DefaultConsistentHash rebalancedCH = (DefaultConsistentHash)chf.rebalance((ConsistentHash)updatedMembersCH);
        this.checkDistribution((ConsistentHash)rebalancedCH, false);
        for (int l = 0; l < rebalancedCH.getNumSegments(); ++l) {
            Assert.assertTrue((rebalancedCH.locateOwnersForSegment(l).size() >= actualNumOwners ? 1 : 0) != 0);
        }
        this.checkMovedSegments(baseCH, rebalancedCH, nodesToAdd);
        DefaultConsistentHash unionCH = (DefaultConsistentHash)chf.union((ConsistentHash)updatedMembersCH, (ConsistentHash)rebalancedCH);
        for (int l = 0; l < updatedMembersCH.getNumSegments(); ++l) {
            Assert.assertTrue((boolean)unionCH.locateOwnersForSegment(l).containsAll(updatedMembersCH.locateOwnersForSegment(l)));
            Assert.assertTrue((boolean)unionCH.locateOwnersForSegment(l).containsAll(rebalancedCH.locateOwnersForSegment(l)));
        }
        Assert.assertEquals((int)rebalancedCH.getNumSegments(), (int)baseCH.getNumSegments());
        Assert.assertEquals((int)rebalancedCH.getNumOwners(), (int)baseCH.getNumOwners());
        Assert.assertEquals((Collection)rebalancedCH.getMembers(), newMembers);
        baseCH = rebalancedCH;
        return baseCH;
    }

    private void checkDistribution(ConsistentHash ch, boolean allowExtraOwners) {
        int numSegments = ch.getNumSegments();
        List nodes = ch.getMembers();
        int numNodes = nodes.size();
        int actualNumOwners = Math.min(ch.getNumOwners(), numNodes);
        OwnershipStatistics stats = new OwnershipStatistics(nodes);
        for (int i = 0; i < numSegments; ++i) {
            List owners = ch.locateOwnersForSegment(i);
            if (!allowExtraOwners) {
                Assert.assertEquals((int)owners.size(), (int)actualNumOwners);
            } else {
                Assert.assertTrue((owners.size() >= actualNumOwners ? 1 : 0) != 0);
            }
            stats.incPrimaryOwned((Address)owners.get(0));
            for (int j = 0; j < owners.size(); ++j) {
                Address owner = (Address)owners.get(j);
                stats.incOwned(owner);
                Assert.assertEquals((int)owners.indexOf(owner), (int)j, (String)"Found the same owner twice in the owners list");
            }
        }
        int minPrimaryOwned = this.minPrimaryOwned(numSegments, numNodes);
        int maxPrimaryOwned = this.maxPrimaryOwned(numSegments, numNodes);
        int minOwned = this.minOwned(numSegments, numNodes, actualNumOwners);
        int maxOwned = this.maxOwned(numSegments, numNodes, actualNumOwners);
        for (Address node : nodes) {
            int owned;
            if (!allowExtraOwners) {
                int primaryOwned = stats.getPrimaryOwned(node);
                Assert.assertTrue((minPrimaryOwned <= primaryOwned ? 1 : 0) != 0);
                Assert.assertTrue((primaryOwned <= maxPrimaryOwned ? 1 : 0) != 0);
            }
            Assert.assertTrue((minOwned <= (owned = stats.getOwned(node)) ? 1 : 0) != 0);
            if (allowExtraOwners) continue;
            Assert.assertTrue((owned <= maxOwned ? 1 : 0) != 0);
        }
    }

    protected int minPrimaryOwned(int numSegments, int numNodes) {
        return numSegments / numNodes;
    }

    protected int maxPrimaryOwned(int numSegments, int numNodes) {
        return (int)Math.ceil((double)numSegments / (double)numNodes);
    }

    protected int minOwned(int numSegments, int numNodes, int actualNumOwners) {
        return numSegments * actualNumOwners / numNodes;
    }

    protected int maxOwned(int numSegments, int numNodes, int actualNumOwners) {
        return (int)Math.ceil((double)numSegments * (double)actualNumOwners / (double)numNodes);
    }

    protected int allowedMoves(int numSegments, int numOwners, Collection<Address> oldMembers, Collection<Address> newMembers) {
        int minMembers = Math.min(oldMembers.size(), newMembers.size());
        int maxMembers = Math.max(oldMembers.size(), newMembers.size());
        if (maxMembers > numSegments) {
            return numSegments * numOwners;
        }
        HashSet<Address> addedMembers = new HashSet<Address>(newMembers);
        addedMembers.removeAll(oldMembers);
        HashSet<Address> removedMembers = new HashSet<Address>(oldMembers);
        removedMembers.removeAll(newMembers);
        int minMoves = (addedMembers.size() + removedMembers.size()) * numSegments * numOwners / minMembers;
        int extraMoves = maxMembers % numSegments;
        return (int)(1.5 * (double)(minMoves + extraMoves));
    }

    private void checkMovedSegments(DefaultConsistentHash oldCH, DefaultConsistentHash newCH, int addedNodes) {
        int numSegments = oldCH.getNumSegments();
        int numOwners = oldCH.getNumOwners();
        List oldMembers = oldCH.getMembers();
        List newMembers = newCH.getMembers();
        int movedSegments = 0;
        for (int i = 0; i < numSegments; ++i) {
            ArrayList lostOwners = new ArrayList(oldCH.locateOwnersForSegment(i));
            lostOwners.removeAll(newCH.locateOwnersForSegment(i));
            lostOwners.retainAll(newMembers);
            movedSegments += lostOwners.size();
        }
        int expectedMoves = this.allowedMoves(numSegments, numOwners, oldMembers, newMembers);
        assert (movedSegments <= expectedMoves) : String.format("Two many moved segments between %s and %s: expected %d, got %d", oldCH, newCH, expectedMoves, movedSegments);
    }

    protected <T> Set<T> symmetricalDiff(Collection<T> set1, Collection<T> set2) {
        HashSet<T> commonMembers = new HashSet<T>(set1);
        commonMembers.retainAll(set2);
        HashSet<T> symDiffMembers = new HashSet<T>(set1);
        symDiffMembers.addAll(set2);
        symDiffMembers.removeAll(commonMembers);
        return symDiffMembers;
    }

    public void test1() {
        DefaultConsistentHashFactory chf = new DefaultConsistentHashFactory();
        TestAddress A = new TestAddress(0, "A");
        TestAddress B = new TestAddress(1, "B");
        TestAddress C = new TestAddress(2, "C");
        TestAddress D = new TestAddress(3, "D");
        DefaultConsistentHash ch1 = chf.create((Hash)new MurmurHash3(), 2, 60, Arrays.asList(A));
        System.out.println(ch1);
        DefaultConsistentHash ch2 = chf.updateMembers(ch1, Arrays.asList(A, B));
        ch2 = chf.rebalance(ch2);
        System.out.println(ch2);
        DefaultConsistentHash ch3 = chf.updateMembers(ch2, Arrays.asList(A, B, C));
        ch3 = chf.rebalance(ch3);
        System.out.println(ch3);
        DefaultConsistentHash ch4 = chf.updateMembers(ch3, Arrays.asList(A, B, C, D));
        ch4 = chf.rebalance(ch4);
        System.out.println(ch4);
    }
}

