/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.Collection;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHashFactoryTest;
import org.infinispan.distribution.ch.SyncConsistentHashFactory;
import org.infinispan.remoting.transport.Address;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ch.SyncConsistentHashFactoryTest")
public class SyncConsistentHashFactoryTest
extends DefaultConsistentHashFactoryTest {
    @Override
    protected ConsistentHashFactory createConsistentHashFactory() {
        return new SyncConsistentHashFactory();
    }

    @Override
    protected int minPrimaryOwned(int numSegments, int numNodes) {
        return (int)(0.25 * (double)super.minPrimaryOwned(numSegments, numNodes));
    }

    @Override
    protected int maxPrimaryOwned(int numSegments, int numNodes) {
        return (int)Math.ceil(3 * super.maxPrimaryOwned(numSegments, numNodes));
    }

    @Override
    protected int minOwned(int numSegments, int numNodes, int actualNumOwners) {
        return (int)(0.25 * (double)super.minOwned(numSegments, numNodes, actualNumOwners));
    }

    @Override
    protected int maxOwned(int numSegments, int numNodes, int actualNumOwners) {
        return (int)Math.ceil(3 * super.maxOwned(numSegments, numNodes, actualNumOwners));
    }

    @Override
    protected int allowedMoves(int numSegments, int numOwners, Collection<Address> oldMembers, Collection<Address> newMembers) {
        int minMembers = Math.min(oldMembers.size(), newMembers.size());
        int diffMembers = this.symmetricalDiff(oldMembers, newMembers).size();
        return numSegments * numOwners * (diffMembers / minMembers + 1);
    }
}

