/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.Cache;
import org.infinispan.distribution.rehash.RehashTestBase;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.ConcurrentJoinTest", description="See ISPN-1123")
public class ConcurrentJoinTest
extends RehashTestBase {
    List<EmbeddedCacheManager> joinerManagers;
    List<Cache<Object, String>> joiners;
    static final int NUM_JOINERS = 4;

    @Override
    void performRehashEvent(boolean offline) {
        int i;
        this.joinerManagers = new CopyOnWriteArrayList<EmbeddedCacheManager>();
        this.joiners = new CopyOnWriteArrayList<Cache>(new Cache[4]);
        for (int i2 = 0; i2 < 4; ++i2) {
            EmbeddedCacheManager joinerManager = this.addClusterEnabledCacheManager(new TransportFlags().withFD(false));
            joinerManager.defineConfiguration(this.cacheName, this.configuration.build());
            this.joinerManagers.add(joinerManager);
            this.joiners.set(i2, null);
        }
        Thread[] threads = new Thread[4];
        for (i = 0; i < 4; ++i) {
            final int ii = i;
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    EmbeddedCacheManager joinerManager = ConcurrentJoinTest.this.joinerManagers.get(ii);
                    Cache joiner = joinerManager.getCache(ConcurrentJoinTest.this.cacheName);
                    ConcurrentJoinTest.this.joiners.set(ii, (Cache<Object, String>)joiner);
                }
            }, "ConcurrentJoinTest-Worker-" + i);
        }
        for (i = 0; i < 4; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 4; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    void waitForRehashCompletion() {
        ArrayList allCacheManagers = new ArrayList(this.cacheManagers);
        TestingUtil.blockUntilViewsReceived(60000, false, allCacheManagers);
        this.waitForClusterToForm(this.cacheName);
        for (int i = 0; i < 4; ++i) {
            this.caches.add(this.joiners.get(i));
        }
    }
}

