/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distribution.group.Group;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="org.infinispan.RehashStressTest")
public class RehashStressTest
extends AbstractInfinispanTest {
    private static Logger log = Logger.getLogger((String)RehashStressTest.class.getName());
    private static final int KEY_RANGE = 10;
    private static final int TEST_THREADS = 40;
    private static final int TEST_LOOPS = 30000;
    public static final int MAX_INTERVAL_BETWEEN_TASK = 1000;
    LinkedList<EmbeddedCacheManager> cacheManagers = new LinkedList();
    Random random = new Random();

    @AfterMethod(alwaysRun=true)
    public void stopAllCacheManageres() {
        while (!this.cacheManagers.isEmpty()) {
            this.cacheManagers.poll().stop();
        }
    }

    public void testRehash() throws IOException, InterruptedException {
        int i;
        EmbeddedCacheManager cacheManager = this.buildCacheManager();
        this.cacheManagers.addLast(cacheManager);
        cacheManager.getCache("serviceGroup");
        new AddNodeTask().run();
        new AddNodeTask().run();
        new AddNodeTask().run();
        Thread.sleep(3000L);
        log.info((Object)"Start testing");
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(40);
        executor.prestartAllCoreThreads();
        for (i = 0; i < 30000; ++i) {
            executor.submit(new SimulateTask());
        }
        for (i = 0; i < 10; ++i) {
            try {
                Thread.sleep(3000L);
                if (i != 1) {
                    new AddNodeTask().run();
                    continue;
                }
                new RemoveNodeTask().run();
                continue;
            }
            catch (RuntimeException e) {
                log.warn((Object)"Error during add/remove node", (Throwable)e);
            }
        }
        log.info((Object)"Rehash phase is completed...");
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
    }

    private EmbeddedCacheManager buildCacheManager() throws IOException {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml("erm-cluster.xml");
        return cacheManager;
    }

    class AddNodeTask
    implements Runnable {
        AddNodeTask() {
        }

        @Override
        public void run() {
            try {
                log.info((Object)"Starting a new cache manager");
                EmbeddedCacheManager cacheManager = RehashStressTest.this.buildCacheManager();
                cacheManager.getCache("serviceGroup");
                RehashStressTest.this.cacheManagers.addLast(cacheManager);
            }
            catch (Exception e) {
                log.warn((Object)"Error during node addition", (Throwable)e);
            }
        }
    }

    class RemoveNodeTask
    implements Runnable {
        RemoveNodeTask() {
        }

        @Override
        public void run() {
            try {
                int size = RehashStressTest.this.cacheManagers.size();
                int index = RehashStressTest.this.random.nextInt(size);
                EmbeddedCacheManager cacheManager = RehashStressTest.this.cacheManagers.remove(index);
                log.info((Object)("Shutting down " + cacheManager.getAddress()));
                cacheManager.stop();
                log.info((Object)("Shut down " + cacheManager.getAddress() + " complete"));
            }
            catch (Exception e) {
                log.warn((Object)"Error during node removal", (Throwable)e);
            }
        }
    }

    static class TransactionTask
    implements DistributedCallable<TestKey, Integer, String>,
    Serializable {
        private Cache cache;
        private TransactionManager tm;
        private TestKey key;

        TransactionTask() {
        }

        public void setEnvironment(Cache cache, Set inputKeys) {
            log.info((Object)("Setting env..." + cache.getAdvancedCache().getCacheManager().getAddress() + ", keys: " + inputKeys));
            this.cache = cache;
            this.key = (TestKey)inputKeys.iterator().next();
            this.tm = cache.getAdvancedCache().getTransactionManager();
        }

        public String call() throws Exception {
            try {
                this.tm.begin();
                String string = this.performWork();
                return string;
            }
            catch (Exception e) {
                log.warn((Object)("error during perform work " + this.key), (Throwable)e);
                this.tm.setRollbackOnly();
                throw e;
            }
            finally {
                int status = -1;
                try {
                    status = this.tm.getStatus();
                }
                catch (Exception e) {}
                if (status == 0) {
                    this.tm.commit();
                } else {
                    this.tm.rollback();
                }
            }
        }

        private String performWork() {
            log.info((Object)("Locking " + this.key));
            this.cache.getAdvancedCache().lock(new Object[]{this.key});
            return "locked " + this.key;
        }
    }

    class SimulateTask
    implements Runnable {
        SimulateTask() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(RehashStressTest.this.random.nextInt(1000));
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            TestKey key = new TestKey(RehashStressTest.this.random.nextInt(10));
            try {
                log.info((Object)("Submitting a task " + key));
                EmbeddedCacheManager cacheManager = RehashStressTest.this.cacheManagers.get(RehashStressTest.this.random.nextInt(RehashStressTest.this.cacheManagers.size()));
                DefaultExecutorService ispnExecutor = new DefaultExecutorService(cacheManager.getCache("serviceGroup"));
                Future z = ispnExecutor.submit((Callable)((Object)new TransactionTask()), (Object[])new TestKey[]{key});
                log.info((Object)("Task result=" + (String)z.get()));
            }
            catch (Exception ex) {
                log.warn((Object)("error during executing task " + key), (Throwable)ex);
            }
        }
    }

    static class TestKey
    implements Serializable {
        int key;

        @Group
        public String getGroup() {
            return String.valueOf(this.key);
        }

        public int getKey() {
            return this.key;
        }

        public void setKey(int key) {
            this.key = key;
        }

        public TestKey(int key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestKey other = (TestKey)obj;
            return this.key == other.key;
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + this.key;
            return hash;
        }

        public String toString() {
            return "TestKey{key=" + this.key + '}';
        }
    }
}

