/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.distribution.TestTopologyAwareAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.TopologyAwareConsistentHashFactory;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="topologyaware.TopologyAwareConsistentHashFactoryTest")
public class TopologyAwareConsistentHashFactoryTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(TopologyAwareConsistentHashFactoryTest.class);
    private static final int CLUSTER_SIZE = 10;
    public int numSegments = 100;
    private TestTopologyAwareAddress[] testAddresses;
    private List<Address> chMembers;
    private ConsistentHashFactory<DefaultConsistentHash> chf;
    private DefaultConsistentHash ch;

    @BeforeMethod
    public void setUp() {
        this.chf = this.createConsistentHashFactory();
        this.chMembers = new ArrayList<Address>(10);
        this.testAddresses = new TestTopologyAwareAddress[10];
        for (int i = 0; i < 10; ++i) {
            this.testAddresses[i] = new TestTopologyAwareAddress(i * 100);
            this.testAddresses[i].setName(Character.toString((char)(65 + i)));
        }
    }

    protected ConsistentHashFactory<DefaultConsistentHash> createConsistentHashFactory() {
        return new TopologyAwareConsistentHashFactory();
    }

    public void testNumberOfOwners() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.updateConsistentHash(1);
        Assert.assertEquals((int)this.ch.locateOwners((Object)this.testAddresses[0]).size(), (int)1);
        this.updateConsistentHash(2);
        Assert.assertEquals((int)this.ch.locateOwners((Object)this.testAddresses[0]).size(), (int)1);
        this.addNode(this.testAddresses[1], "m1", null, null);
        this.updateConsistentHash(1);
        for (TestTopologyAwareAddress testAddress : this.testAddresses) {
            Assert.assertEquals((int)this.ch.locateOwners((Object)testAddress).size(), (int)1);
        }
        this.updateConsistentHash(2);
        for (TestTopologyAwareAddress testAddress : this.testAddresses) {
            Assert.assertEquals((int)this.ch.locateOwners((Object)testAddress).size(), (int)2);
        }
        this.updateConsistentHash(3);
        for (TestTopologyAwareAddress testAddress : this.testAddresses) {
            Assert.assertEquals((int)this.ch.locateOwners((Object)testAddress).size(), (int)2);
        }
        this.addNode(this.testAddresses[2], "m0", null, null);
        this.updateConsistentHash(1);
        for (TestTopologyAwareAddress testAddress : this.testAddresses) {
            Assert.assertEquals((int)this.ch.locateOwners((Object)testAddress).size(), (int)1);
        }
        this.updateConsistentHash(2);
        for (TestTopologyAwareAddress testAddress : this.testAddresses) {
            Assert.assertEquals((int)this.ch.locateOwners((Object)testAddress).size(), (int)2);
        }
        this.updateConsistentHash(3);
        for (TestTopologyAwareAddress testAddress : this.testAddresses) {
            Assert.assertEquals((int)this.ch.locateOwners((Object)testAddress).size(), (int)3);
        }
        this.updateConsistentHash(4);
        for (TestTopologyAwareAddress testAddress : this.testAddresses) {
            Assert.assertEquals((int)this.ch.locateOwners((Object)testAddress).size(), (int)3);
        }
    }

    public void testDifferentMachines() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.addNode(this.testAddresses[1], "m1", null, null);
        this.addNode(this.testAddresses[2], "m0", null, null);
        this.addNode(this.testAddresses[3], "m1", null, null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
    }

    public void testNumOwnerBiggerThanAvailableNodes() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.addNode(this.testAddresses[1], "m0", null, null);
        this.addNode(this.testAddresses[2], "m0", null, null);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
        this.assertAllLocationsWithRebalance(99);
    }

    public void testDifferentMachines2() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.addNode(this.testAddresses[1], "m0", null, null);
        this.addNode(this.testAddresses[2], "m1", null, null);
        this.addNode(this.testAddresses[3], "m1", null, null);
        this.addNode(this.testAddresses[4], "m2", null, null);
        this.addNode(this.testAddresses[5], "m2", null, null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testDifferentMachines3() {
        this.addNode(this.testAddresses[0], "primary", "primary", "primary");
        this.addNode(this.testAddresses[1], "primary", "primary", "primary");
        this.addNode(this.testAddresses[2], "secondary", "primary", "primary");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testDifferentRacksAndMachines() {
        this.addNode(this.testAddresses[0], "m0", "r0", null);
        this.addNode(this.testAddresses[1], "m1", "r0", null);
        this.addNode(this.testAddresses[2], "m2", "r1", null);
        this.addNode(this.testAddresses[3], "m3", "r2", null);
        this.addNode(this.testAddresses[4], "m2", "r1", null);
        this.addNode(this.testAddresses[5], "m2", "r2", null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testAllSameMachine() {
        this.addNode(this.testAddresses[0], "m0", null, null);
        this.addNode(this.testAddresses[1], "m0", null, null);
        this.addNode(this.testAddresses[2], "m0", null, null);
        this.addNode(this.testAddresses[3], "m0", null, null);
        this.addNode(this.testAddresses[4], "m0", null, null);
        this.addNode(this.testAddresses[5], "m0", null, null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testDifferentSites() {
        this.addNode(this.testAddresses[0], "m0", null, "s0");
        this.addNode(this.testAddresses[1], "m1", null, "s0");
        this.addNode(this.testAddresses[2], "m2", null, "s1");
        this.addNode(this.testAddresses[3], "m3", null, "s1");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testSitesMachines2() {
        this.addNode(this.testAddresses[0], "m0", null, "s0");
        this.addNode(this.testAddresses[1], "m1", null, "s1");
        this.addNode(this.testAddresses[2], "m2", null, "s0");
        this.addNode(this.testAddresses[3], "m3", null, "s2");
        this.addNode(this.testAddresses[4], "m4", null, "s1");
        this.addNode(this.testAddresses[5], "m5", null, "s1");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testSitesMachinesSameMachineName() {
        this.addNode(this.testAddresses[0], "m0", null, "r0");
        this.addNode(this.testAddresses[1], "m0", null, "r1");
        this.addNode(this.testAddresses[2], "m0", null, "r0");
        this.addNode(this.testAddresses[3], "m0", null, "r2");
        this.addNode(this.testAddresses[4], "m0", null, "r1");
        this.addNode(this.testAddresses[5], "m0", null, "r1");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testDifferentRacks() {
        this.addNode(this.testAddresses[0], "m0", "r0", null);
        this.addNode(this.testAddresses[1], "m1", "r0", null);
        this.addNode(this.testAddresses[2], "m2", "r1", null);
        this.addNode(this.testAddresses[3], "m3", "r1", null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testRacksMachines2() {
        this.addNode(this.testAddresses[0], "m0", "r0", null);
        this.addNode(this.testAddresses[1], "m1", "r1", null);
        this.addNode(this.testAddresses[2], "m2", "r0", null);
        this.addNode(this.testAddresses[3], "m3", "r2", null);
        this.addNode(this.testAddresses[4], "m4", "r1", null);
        this.addNode(this.testAddresses[5], "m5", "r1", null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testRacksMachinesSameMachineName() {
        this.addNode(this.testAddresses[0], "m0", "r0", null);
        this.addNode(this.testAddresses[1], "m0", "r1", null);
        this.addNode(this.testAddresses[2], "m0", "r0", null);
        this.addNode(this.testAddresses[3], "m0", "r2", null);
        this.addNode(this.testAddresses[4], "m0", "r1", null);
        this.addNode(this.testAddresses[5], "m0", "r1", null);
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    public void testComplexScenario() {
        this.addNode(this.testAddresses[0], "m2", "r0", "s1");
        this.addNode(this.testAddresses[1], "m1", "r0", "s0");
        this.addNode(this.testAddresses[2], "m1", "r0", "s1");
        this.addNode(this.testAddresses[3], "m1", "r1", "s0");
        this.addNode(this.testAddresses[4], "m0", "r0", "s1");
        this.addNode(this.testAddresses[5], "m0", "r1", "s1");
        this.addNode(this.testAddresses[6], "m0", "r1", "s0");
        this.addNode(this.testAddresses[7], "m0", "r0", "s1");
        this.addNode(this.testAddresses[8], "m0", "r0", "s0");
        this.addNode(this.testAddresses[9], "m0", "r0", "s0");
        this.assertAllLocationsWithRebalance(1);
        this.assertAllLocationsWithRebalance(2);
        this.assertAllLocationsWithRebalance(3);
        this.assertAllLocationsWithRebalance(4);
    }

    private void assertAllLocationsWithRebalance(int numOwners) {
        this.ch = (DefaultConsistentHash)this.chf.create((Hash)new MurmurHash3(), numOwners, this.numSegments, this.chMembers.subList(0, 1));
        this.assertAllLocations(1, 1, 1, 1);
        for (int i = 2; i < this.chMembers.size(); ++i) {
            List<Address> currentMembers = this.chMembers.subList(0, i);
            int expectedOwners = Math.min(numOwners, i);
            int expectedMachines = Math.min(expectedOwners, this.countMachines(currentMembers));
            int expectedRacks = Math.min(expectedOwners, this.countRacks(currentMembers));
            int expectedSites = Math.min(expectedOwners, this.countSites(currentMembers));
            this.ch = (DefaultConsistentHash)this.chf.updateMembers((ConsistentHash)this.ch, currentMembers);
            this.ch = (DefaultConsistentHash)this.chf.rebalance((ConsistentHash)this.ch);
            this.assertAllLocations(expectedOwners, expectedMachines, expectedRacks, expectedSites);
        }
        log.debugf("Created CH with members %s", this.chMembers);
    }

    private int countMachines(List<Address> addresses) {
        HashSet<String> machines = new HashSet<String>(addresses.size());
        for (Address a : addresses) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            machines.add(taa.getMachineId() + taa.getRackId() + taa.getSiteId());
        }
        return machines.size();
    }

    private int countRacks(List<Address> addresses) {
        HashSet<String> racks = new HashSet<String>(addresses.size());
        for (Address a : addresses) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            racks.add(taa.getRackId() + taa.getSiteId());
        }
        return racks.size();
    }

    private int countSites(List<Address> addresses) {
        HashSet<String> sites = new HashSet<String>(addresses.size());
        for (Address a : addresses) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            sites.add(taa.getSiteId());
        }
        return sites.size();
    }

    private void assertAllLocations(int expectedOwners, int expectedMachines, int expectedRacks, int expectedSites) {
        for (int segment = 0; segment < this.numSegments; ++segment) {
            this.assertSegmentLocation(segment, expectedOwners, expectedMachines, expectedRacks, expectedSites);
        }
    }

    public void testConsistencyWhenNodeLeaves() {
        this.addNode(this.testAddresses[0], "m2", "r0", "s1");
        this.addNode(this.testAddresses[1], "m1", "r0", "s0");
        this.addNode(this.testAddresses[2], "m1", "r0", "s1");
        this.addNode(this.testAddresses[3], "m1", "r1", "s0");
        this.addNode(this.testAddresses[4], "m0", "r0", "s1");
        this.addNode(this.testAddresses[5], "m0", "r1", "s1");
        this.addNode(this.testAddresses[6], "m0", "r1", "s0");
        this.addNode(this.testAddresses[7], "m0", "r0", "s3");
        this.addNode(this.testAddresses[8], "m0", "r0", "s2");
        this.addNode(this.testAddresses[9], "m0", "r0", "s0");
        this.updateConsistentHash(3);
        for (Address addr : this.chMembers) {
            log.debugf("Removing node %s" + addr, new Object[0]);
            ArrayList<Address> addressCopy = new ArrayList<Address>(this.chMembers);
            addressCopy.remove(addr);
            DefaultConsistentHash newCH = (DefaultConsistentHash)this.chf.updateMembers((ConsistentHash)this.ch, addressCopy);
            newCH = (DefaultConsistentHash)this.chf.rebalance((ConsistentHash)newCH);
            AtomicInteger movedSegmentsCount = new AtomicInteger(0);
            for (int segment = 0; segment < this.numSegments; ++segment) {
                this.checkConsistency(segment, 3, this.ch.locateOwnersForSegment(segment), addr, newCH, movedSegmentsCount);
            }
            assert (movedSegmentsCount.get() < 5) : String.format("Too many moved segments after leave: %d. CH after leave is: %s\nPrevious: %s", movedSegmentsCount.get(), newCH, this.ch);
        }
    }

    private void checkConsistency(int segment, int replCount, List<Address> originalOwners, Address removedAddress, DefaultConsistentHash newCH, AtomicInteger movedSegmentsCount) {
        List currentOwners = newCH.locateOwnersForSegment(segment);
        originalOwners = new ArrayList<Address>(originalOwners);
        originalOwners.remove(removedAddress);
        Assert.assertEquals((int)replCount, (int)currentOwners.size(), (String)currentOwners.toString());
        if (!currentOwners.containsAll(originalOwners)) {
            movedSegmentsCount.incrementAndGet();
        }
    }

    private void assertSegmentLocation(int segment, int expectedOwners, int expectedMachines, int expectedRacks, int expectedSites) {
        List received = this.ch.locateOwnersForSegment(segment);
        Assert.assertEquals((int)received.size(), (int)expectedOwners);
        HashSet receivedUnique = new HashSet(received);
        Assert.assertEquals((int)receivedUnique.size(), (int)expectedOwners);
        HashSet<String> receivedMachines = new HashSet<String>();
        for (Address a : received) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            receivedMachines.add(taa.getMachineId() + "|" + taa.getRackId() + "|" + taa.getSiteId());
        }
        Assert.assertEquals((int)receivedMachines.size(), (int)expectedMachines);
        HashSet<String> receivedRacks = new HashSet<String>();
        for (Address a : received) {
            TopologyAwareAddress taa = (TopologyAwareAddress)a;
            receivedRacks.add(taa.getRackId() + "|" + taa.getSiteId());
        }
        Assert.assertEquals((int)receivedRacks.size(), (int)expectedRacks);
        HashSet<String> receivedSites = new HashSet<String>();
        for (Address a : received) {
            receivedSites.add(((TopologyAwareAddress)a).getSiteId());
        }
        Assert.assertEquals((int)receivedSites.size(), (int)expectedSites);
    }

    private void addNode(TestTopologyAwareAddress address, String machineId, String rackId, String siteId) {
        address.setSiteId(siteId);
        address.setRackId(rackId);
        address.setMachineId(machineId);
        this.chMembers.add(address);
    }

    protected void updateConsistentHash(int numOwners) {
        this.ch = (DefaultConsistentHash)this.chf.create((Hash)new MurmurHash3(), numOwners, this.numSegments, this.chMembers);
        log.debugf("Created CH with members %s", this.chMembers);
    }
}

