/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.CacheException;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheMBeanTest")
public class CacheMBeanTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(CacheMBeanTest.class);
    public static final String JMX_DOMAIN = CacheMBeanTest.class.getSimpleName();
    private MBeanServer server;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(JMX_DOMAIN);
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        return this.cacheManager;
    }

    public void testJmxOperationMetadata() throws Exception {
        ObjectName name = TestingUtil.getCacheObjectName(JMX_DOMAIN);
        TestingUtil.checkMBeanOperationParameterNaming(name);
    }

    public void testStartStopManagedOperations() throws Exception {
        ObjectName defaultOn = TestingUtil.getCacheObjectName(JMX_DOMAIN);
        ObjectName managerON = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN);
        this.server.invoke(managerON, "startCache", new Object[0], new String[0]);
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("1"));
        this.server.invoke(defaultOn, "stop", new Object[0], new String[0]);
        assert (ComponentStatus.TERMINATED.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("0"));
        this.server.invoke(defaultOn, "start", new Object[0], new String[0]);
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("1"));
        this.server.invoke(defaultOn, "stop", new Object[0], new String[0]);
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("0"));
        assert (ComponentStatus.TERMINATED.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        this.server.invoke(defaultOn, "start", new Object[0], new String[0]);
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("1"));
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        this.server.invoke(defaultOn, "stop", new Object[0], new String[0]);
        assert (this.server.getAttribute(managerON, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(managerON, "RunningCacheCount").equals("0"));
        assert (ComponentStatus.TERMINATED.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
    }

    public void testManagerStopRemovesCacheMBean(Method m) throws Exception {
        String otherJmxDomain = TestingUtil.getMethodSpecificJmxDomain(m, JMX_DOMAIN);
        ObjectName defaultOn = TestingUtil.getCacheObjectName(otherJmxDomain);
        ObjectName galderOn = TestingUtil.getCacheObjectName(otherJmxDomain, "galder(local)");
        ObjectName managerON = TestingUtil.getCacheManagerObjectName(otherJmxDomain);
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(otherJmxDomain);
        this.server.invoke(managerON, "startCache", new Object[0], new String[0]);
        this.server.invoke(managerON, "startCache", new Object[]{"galder"}, new String[]{String.class.getName()});
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(defaultOn, "CacheStatus")));
        assert (ComponentStatus.RUNNING.toString().equals(this.server.getAttribute(galderOn, "CacheStatus")));
        otherContainer.stop();
        try {
            log.info((Object)this.server.getMBeanInfo(managerON));
            assert (false) : "Failure expected, " + managerON + " shouldn't be registered in mbean server";
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
        try {
            log.info((Object)this.server.getMBeanInfo(defaultOn));
            assert (false) : "Failure expected, " + defaultOn + " shouldn't be registered in mbean server";
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
        try {
            log.info((Object)this.server.getMBeanInfo(galderOn));
            assert (false) : "Failure expected, " + galderOn + " shouldn't be registered in mbean server";
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDuplicateJmxDomainOnlyCacheExposesJmxStatistics() throws Exception {
        EmbeddedCacheManager otherContainer;
        block4: {
            otherContainer = null;
            try {
                otherContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(JMX_DOMAIN, false, true);
                otherContainer.getCache();
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)("Failure expected, " + JMX_DOMAIN + " is a duplicate!"));
            }
            catch (CacheException e) {
                block5: {
                    try {
                        if ($assertionsDisabled || e instanceof JmxDomainConflictException) break block5;
                        throw new AssertionError();
                    }
                    catch (Throwable throwable) {
                        TestingUtil.killCacheManagers(new CacheContainer[]{otherContainer});
                        throw throwable;
                    }
                }
                TestingUtil.killCacheManagers(new CacheContainer[]{otherContainer});
            }
        }
        TestingUtil.killCacheManagers(new CacheContainer[]{otherContainer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMalformedCacheName(Method m) throws Exception {
        String otherJmxDomain = JMX_DOMAIN + '.' + m.getName();
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(otherJmxDomain);
        try {
            otherContainer.getCache("persistence.unit:unitName=#helloworld.MyRegion");
        }
        finally {
            otherContainer.stop();
        }
    }

    public void testAvoidLeakOfCacheMBeanWhenCacheStatisticsDisabled(Method m) {
        final String jmxDomain = "jmx_" + m.getName();
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(jmxDomain, false, false)){

            @Override
            public void call() {
                try {
                    this.cm.getCache();
                    ObjectName cacheObjectName = TestingUtil.getCacheObjectName(jmxDomain);
                    AssertJUnit.assertTrue((String)(cacheObjectName + " should be registered"), (boolean)CacheMBeanTest.this.server.isRegistered(cacheObjectName));
                    TestingUtil.killCacheManagers(this.cm);
                    AssertJUnit.assertFalse((String)(cacheObjectName + " should NOT be registered"), (boolean)CacheMBeanTest.this.server.isRegistered(cacheObjectName));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

