/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.ClusteredCacheManagerMBeanTest")
public class ClusteredCacheManagerMBeanTest
extends MultipleCacheManagersTest {
    public static final String JMX_DOMAIN = ClusteredCacheManagerMBeanTest.class.getSimpleName();
    public static final String JMX_DOMAIN2 = JMX_DOMAIN + "2";
    private ObjectName name1;
    private ObjectName name2;
    private MBeanServer server;

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setAllowDuplicateDomains(true);
        globalConfiguration.setJmxDomain(JMX_DOMAIN);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration);
        cacheManager1.start();
        GlobalConfiguration globalConfiguration2 = GlobalConfiguration.getClusteredDefault();
        globalConfiguration2.setExposeGlobalJmxStatistics(true);
        globalConfiguration2.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration2.setJmxDomain(JMX_DOMAIN);
        globalConfiguration2.setAllowDuplicateDomains(true);
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration2);
        cacheManager2.start();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        this.name1 = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN);
        this.name2 = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN2);
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        Configuration config = ClusteredCacheManagerMBeanTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        config.setExposeJmxStatistics(true);
        this.defineConfigurationOnAllManagers("mycache", config);
        this.manager(0).getCache("mycache");
        this.manager(1).getCache("mycache");
    }

    public void testAddressInformation() throws Exception {
        String cm1Address = this.manager(0).getAddress().toString();
        String cm2Address = this.manager(1).getAddress().toString();
        assert (this.server.getAttribute(this.name1, "NodeAddress").equals(cm1Address));
        assert (this.server.getAttribute(this.name1, "ClusterMembers").toString().contains(cm1Address));
        assert (!this.server.getAttribute(this.name1, "PhysicalAddresses").toString().equals("local"));
        assert (this.server.getAttribute(this.name1, "ClusterSize").equals(2));
        assert (this.server.getAttribute(this.name2, "NodeAddress").equals(cm2Address));
        assert (this.server.getAttribute(this.name2, "ClusterMembers").toString().contains(cm2Address));
        assert (!this.server.getAttribute(this.name2, "PhysicalAddresses").toString().equals("local"));
        assert (this.server.getAttribute(this.name2, "ClusterSize").equals(2));
    }

    public void testJGroupsInformation() throws Exception {
        ObjectName jchannelName1 = TestingUtil.getJGroupsChannelObjectName(JMX_DOMAIN, this.manager(0).getClusterName());
        ObjectName jchannelName2 = TestingUtil.getJGroupsChannelObjectName(JMX_DOMAIN2, this.manager(1).getClusterName());
        AssertJUnit.assertEquals((Object)this.server.getAttribute(this.name1, "NodeAddress"), (Object)this.server.getAttribute(jchannelName1, "Address"));
        AssertJUnit.assertEquals((Object)this.server.getAttribute(this.name2, "NodeAddress"), (Object)this.server.getAttribute(jchannelName2, "Address"));
        assert (((Boolean)this.server.getAttribute(jchannelName1, "Connected")).booleanValue());
        assert (((Boolean)this.server.getAttribute(jchannelName2, "Connected")).booleanValue());
    }
}

