/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.TxInterceptorMBeanTest")
public class TxInterceptorMBeanTest
extends MultipleCacheManagersTest {
    private static final String JMX_DOMAIN = TxInterceptorMBeanTest.class.getSimpleName();
    private ObjectName txInterceptor;
    private ObjectName txInterceptor2;
    private MBeanServer threadMBeanServer;
    private TransactionManager tm;
    private Cache cache1;
    private Cache cache2;

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setAllowDuplicateDomains(true);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration.setJmxDomain(JMX_DOMAIN);
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration);
        this.registerCacheManager(new CacheContainer[]{cacheManager1});
        GlobalConfiguration globalConfiguration2 = globalConfiguration.clone();
        globalConfiguration2.setCacheManagerName("SecondDefaultCacheManager");
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration2);
        this.registerCacheManager(new CacheContainer[]{cacheManager2});
        Configuration configuration = TxInterceptorMBeanTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        configuration.setExposeJmxStatistics(true);
        cacheManager1.defineConfiguration("test", configuration);
        cacheManager2.defineConfiguration("test", configuration.clone());
        this.cache1 = cacheManager1.getCache("test");
        this.cache2 = cacheManager2.getCache("test");
        this.txInterceptor = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(repl_sync)", "Transactions");
        this.txInterceptor2 = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(repl_sync)", "Transactions", "SecondDefaultCacheManager");
        this.threadMBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        this.tm = TestingUtil.getTransactionManager(this.cache1);
    }

    @AfterMethod(alwaysRun=true)
    public void resetStats() throws Exception {
        this.threadMBeanServer.invoke(this.txInterceptor, "resetStatistics", new Object[0], new String[0]);
        this.threadMBeanServer.invoke(this.txInterceptor2, "resetStatistics", new Object[0], new String[0]);
    }

    public void testJmxOperationMetadata() throws Exception {
        TestingUtil.checkMBeanOperationParameterNaming(this.txInterceptor);
    }

    public void testCommit() throws Exception {
        this.assertCommitRollback(0, 0, this.txInterceptor);
        this.tm.begin();
        this.tm.getTransaction().enlistResource((XAResource)new XAResourceAdapter());
        this.assertCommitRollback(0, 0, this.txInterceptor);
        this.cache1.put((Object)"key", (Object)"value");
        this.assertCommitRollback(0, 0, this.txInterceptor);
        this.tm.commit();
        this.assertCommitRollback(1, 0, this.txInterceptor);
    }

    public void testRollback() throws Exception {
        this.assertCommitRollback(0, 0, this.txInterceptor);
        this.tm.begin();
        this.assertCommitRollback(0, 0, this.txInterceptor);
        this.cache1.put((Object)"key", (Object)"value");
        this.assertCommitRollback(0, 0, this.txInterceptor);
        this.tm.rollback();
        this.assertCommitRollback(0, 1, this.txInterceptor);
    }

    public void testRemoteCommit() throws Exception {
        this.assertCommitRollback(0, 0, this.txInterceptor2);
        this.tm.begin();
        this.assertCommitRollback(0, 0, this.txInterceptor2);
        this.tm.getTransaction().enlistResource((XAResource)new XAResourceAdapter());
        this.cache2.put((Object)"key", (Object)"value");
        this.assertCommitRollback(0, 0, this.txInterceptor2);
        this.tm.commit();
        this.assertCommitRollback(1, 0, this.txInterceptor2);
    }

    public void testRemoteRollback() throws Exception {
        this.assertCommitRollback(0, 0, this.txInterceptor2);
        this.tm.begin();
        this.assertCommitRollback(0, 0, this.txInterceptor2);
        this.cache2.put((Object)"key", (Object)"value");
        this.assertCommitRollback(0, 0, this.txInterceptor2);
        this.tm.rollback();
        this.assertCommitRollback(0, 1, this.txInterceptor2);
    }

    private void assertCommitRollback(int commit, int rollback, ObjectName objectName) throws Exception {
        String commitCount = this.threadMBeanServer.getAttribute(objectName, "Commits").toString();
        assert (Integer.valueOf(commitCount) == commit) : "expecting " + commit + " commits, received " + commitCount;
        String rollbackCount = this.threadMBeanServer.getAttribute(objectName, "Rollbacks").toString();
        assert (Integer.valueOf(commitCount) == commit) : "expecting " + rollback + " rollbacks, received " + rollbackCount;
    }
}

