/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.locks.StripedLock;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="lock.StripedLockTest")
public class StripedLockTest
extends AbstractInfinispanTest {
    StripedLock stripedLock;
    public static final int CAN_ACQUIRE_WL = 1;
    public static final int CAN_ACQUIRE_RL = 2;
    public static final int ACQUIRE_WL = 3;
    public static final int ACQUIRE_RL = 4;
    private static final String KEY = "21321321321321321";

    @BeforeMethod
    public void cretateStripedLock() {
        this.stripedLock = new StripedLock(5);
    }

    public void testGlobalReadLockSimple() throws Exception {
        assert (this.canAquireWL());
        assert (this.canAquireRL());
        assert (this.stripedLock.acquireGlobalLock(false, 0L));
        assert (this.stripedLock.getTotalReadLockCount() == this.stripedLock.getSharedLockCount());
        assert (!this.canAquireWL());
        assert (this.canAquireRL());
    }

    public void testGlobalReadLockIsAtomic() throws Exception {
        assert (this.aquireWL());
        assert (1 == this.stripedLock.getTotalWriteLockCount());
        assert (!this.stripedLock.acquireGlobalLock(false, 0L));
        assert (this.stripedLock.getTotalReadLockCount() == 0) : "No read locks should be held if the operation failed";
    }

    public void testGlobalReadLockOverExistingReadLocks() throws Exception {
        assert (this.aquireRL());
        assert (this.aquireRL());
        assert (this.stripedLock.getTotalReadLockCount() == 2);
        assert (this.stripedLock.acquireGlobalLock(false, 0L));
        assert (this.stripedLock.getTotalReadLockCount() == this.stripedLock.getSharedLockCount() + 2);
    }

    public void testAquireGlobalAndRelease() {
        assert (this.stripedLock.acquireGlobalLock(false, 0L));
        assert (this.stripedLock.getTotalReadLockCount() == this.stripedLock.getSharedLockCount());
        assert (this.stripedLock.getTotalWriteLockCount() == 0);
        try {
            this.stripedLock.releaseGlobalLock(true);
            assert (false) : "this should fail as we do not have a monitor over the locks";
        }
        catch (Exception e) {
            // empty catch block
        }
        this.stripedLock.releaseGlobalLock(false);
        assert (this.stripedLock.getTotalReadLockCount() == 0);
        assert (this.stripedLock.getTotalWriteLockCount() == 0);
        assert (this.stripedLock.acquireGlobalLock(true, 0L));
        assert (this.stripedLock.getTotalReadLockCount() == 0);
        assert (this.stripedLock.getTotalWriteLockCount() == this.stripedLock.getSharedLockCount());
        try {
            this.stripedLock.releaseGlobalLock(false);
            assert (false) : "this should fail as we do not have a monitor over the locks";
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stripedLock.releaseGlobalLock(true);
        assert (this.stripedLock.getTotalReadLockCount() == 0);
        assert (this.stripedLock.getTotalWriteLockCount() == 0);
    }

    private boolean aquireWL() throws Exception {
        OtherThread otherThread = new OtherThread();
        otherThread.start();
        otherThread.operationQueue.put(3);
        return otherThread.responseQueue.take();
    }

    private boolean aquireRL() throws Exception {
        OtherThread otherThread = new OtherThread();
        otherThread.start();
        otherThread.operationQueue.put(4);
        return otherThread.responseQueue.take();
    }

    private boolean canAquireRL() throws Exception {
        OtherThread otherThread = new OtherThread();
        otherThread.start();
        otherThread.operationQueue.put(2);
        return otherThread.responseQueue.take();
    }

    private boolean canAquireWL() throws Exception {
        OtherThread otherThread = new OtherThread();
        otherThread.start();
        otherThread.operationQueue.put(1);
        return otherThread.responseQueue.take();
    }

    public class OtherThread
    extends Thread {
        volatile BlockingQueue<Integer> operationQueue = new ArrayBlockingQueue<Integer>(1);
        volatile BlockingQueue<Boolean> responseQueue = new ArrayBlockingQueue<Boolean>(1);

        @Override
        public void run() {
            try {
                Boolean response;
                int operation = this.operationQueue.take();
                switch (operation) {
                    case 2: {
                        response = StripedLockTest.this.stripedLock.acquireLock((Object)StripedLockTest.KEY, false, 0L);
                        if (!response.booleanValue()) break;
                        StripedLockTest.this.stripedLock.releaseLock((Object)StripedLockTest.KEY);
                        break;
                    }
                    case 1: {
                        response = StripedLockTest.this.stripedLock.acquireLock((Object)StripedLockTest.KEY, true, 0L);
                        if (!response.booleanValue()) break;
                        StripedLockTest.this.stripedLock.releaseLock((Object)StripedLockTest.KEY);
                        break;
                    }
                    case 4: {
                        response = StripedLockTest.this.stripedLock.acquireLock((Object)StripedLockTest.KEY, false, 0L);
                        break;
                    }
                    case 3: {
                        response = StripedLockTest.this.stripedLock.acquireLock((Object)StripedLockTest.KEY, true, 0L);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown operation: " + operation);
                    }
                }
                this.responseQueue.put(response);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

