/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.PojoWithJBossExternalize;
import org.infinispan.marshall.PojoWithSerializeWith;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.jboss.MarshallExternalPojosTest")
public class MarshallExternalPojosTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = MarshallExternalPojosTest.class.getName();

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfiguration globalCfg1 = GlobalConfiguration.getClusteredDefault();
        GlobalConfiguration globalCfg2 = GlobalConfiguration.getClusteredDefault();
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createCacheManager(globalCfg1);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createCacheManager(globalCfg2);
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
        Configuration cfg = MarshallExternalPojosTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.defineConfigurationOnAllManagers(CACHE_NAME, cfg);
        this.waitForClusterToForm(CACHE_NAME);
    }

    public void testReplicateJBossExternalizePojo(Method m) {
        PojoWithJBossExternalize pojo = new PojoWithJBossExternalize(34, TestingUtil.k(m));
        this.doReplicatePojo(m, pojo);
    }

    @Test(dependsOnMethods={"testReplicateJBossExternalizePojo"})
    public void testReplicateJBossExternalizePojoToNewJoiningNode(Method m) {
        PojoWithJBossExternalize pojo = new PojoWithJBossExternalize(48, TestingUtil.k(m));
        this.doReplicatePojoToNewJoiningNode(m, pojo);
    }

    public void testReplicateMarshallableByPojo(Method m) {
        PojoWithSerializeWith pojo = new PojoWithSerializeWith(17, TestingUtil.k(m));
        this.doReplicatePojo(m, pojo);
    }

    @Test(dependsOnMethods={"testReplicateMarshallableByPojo"})
    public void testReplicateMarshallableByPojoToNewJoiningNode(Method m) {
        PojoWithSerializeWith pojo = new PojoWithSerializeWith(85, TestingUtil.k(m));
        this.doReplicatePojoToNewJoiningNode(m, pojo);
    }

    private void doReplicatePojo(Method m, Object o) {
        Cache cache1 = this.manager(0).getCache(CACHE_NAME);
        Cache cache2 = this.manager(1).getCache(CACHE_NAME);
        cache1.put((Object)TestingUtil.k(m), o);
        AssertJUnit.assertEquals((Object)o, (Object)cache2.get((Object)TestingUtil.k(m)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReplicatePojoToNewJoiningNode(Method m, Object o) {
        Cache cache1 = this.manager(0).getCache(CACHE_NAME);
        EmbeddedCacheManager cm = this.createCacheManager();
        try {
            Cache cache3 = cm.getCache(CACHE_NAME);
            cache1.put((Object)TestingUtil.k(m), o);
            AssertJUnit.assertEquals((Object)o, (Object)cache3.get((Object)TestingUtil.k(m)));
        }
        finally {
            cm.stop();
        }
    }

    private EmbeddedCacheManager createCacheManager() {
        GlobalConfiguration globalCfg = GlobalConfiguration.getClusteredDefault();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalCfg);
        Configuration cfg = MarshallExternalPojosTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        cm.defineConfiguration(CACHE_NAME, cfg);
        return cm;
    }
}

