/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.infinispan.test.AbstractInfinispanTest;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SunReflectiveCreator;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.jboss.JBossMarshallingTest")
public class JBossMarshallingTest
extends AbstractInfinispanTest {
    private MarshallerFactory factory;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    @BeforeTest
    public void setUp() throws Exception {
        this.factory = (MarshallerFactory)Thread.currentThread().getContextClassLoader().loadClass("org.jboss.marshalling.river.RiverMarshallerFactory").newInstance();
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setCreator((Creator)new SunReflectiveCreator());
        configuration.setClassResolver((ClassResolver)new ContextClassResolver());
        this.marshaller = this.factory.createMarshaller(configuration);
        this.unmarshaller = this.factory.createUnmarshaller(configuration);
    }

    @AfterTest(alwaysRun=true)
    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerObjWithRefToSerObjectWithCustomReadObj() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        ByteOutput byteOutput = Marshalling.createByteOutput((OutputStream)baos);
        this.marshaller.start(byteOutput);
        ObjectThatContainsACustomReadObjectMethod obj = new ObjectThatContainsACustomReadObjectMethod();
        obj.anObjectWithCustomReadObjectMethod = new CustomReadObjectMethod();
        try {
            this.marshaller.writeObject((Object)obj);
        }
        finally {
            this.marshaller.finish();
        }
        byte[] bytes = baos.toByteArray();
        ByteInput byteInput = Marshalling.createByteInput((InputStream)new ByteArrayInputStream(bytes));
        this.unmarshaller.start(byteInput);
        try {
            assert (obj.equals(this.unmarshaller.readObject()));
        }
        finally {
            this.unmarshaller.finish();
        }
    }

    public static class ObjectThatContainsACustomReadObjectMethod
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public CustomReadObjectMethod anObjectWithCustomReadObjectMethod;
        Integer balance;

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ObjectThatContainsACustomReadObjectMethod)) {
                return false;
            }
            ObjectThatContainsACustomReadObjectMethod acct = (ObjectThatContainsACustomReadObjectMethod)obj;
            if (!ObjectThatContainsACustomReadObjectMethod.safeEquals(this.balance, acct.balance)) {
                return false;
            }
            return ObjectThatContainsACustomReadObjectMethod.safeEquals(this.anObjectWithCustomReadObjectMethod, acct.anObjectWithCustomReadObjectMethod);
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + ObjectThatContainsACustomReadObjectMethod.safeHashCode(this.balance);
            result = result * 31 + ObjectThatContainsACustomReadObjectMethod.safeHashCode(this.anObjectWithCustomReadObjectMethod);
            return result;
        }

        private static int safeHashCode(Object obj) {
            return obj == null ? 0 : obj.hashCode();
        }

        private static boolean safeEquals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }

    public static class CustomReadObjectMethod
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String lastName;
        String ssn;
        transient boolean deserialized;

        public CustomReadObjectMethod() {
            this("Zamarreno", "234-567-8901");
        }

        public CustomReadObjectMethod(String lastName, String ssn) {
            this.lastName = lastName;
            this.ssn = ssn;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CustomReadObjectMethod)) {
                return false;
            }
            CustomReadObjectMethod pk = (CustomReadObjectMethod)obj;
            if (!this.lastName.equals(pk.lastName)) {
                return false;
            }
            return this.ssn.equals(pk.ssn);
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + this.lastName.hashCode();
            result = result * 31 + this.ssn.hashCode();
            return result;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.deserialized = true;
        }
    }
}

