/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CustomClassLoaderListenerTest")
public class CustomClassLoaderListenerTest
extends SingleCacheManagerTest {
    private CustomClassLoader ccl;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.loaders().passivation(true).addStore(DummyInMemoryCacheStoreConfigurationBuilder.class);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testCustomClassLoaderListener() throws Exception {
        this.ccl = new CustomClassLoader(Thread.currentThread().getContextClassLoader());
        ClassLoaderListener listener = new ClassLoaderListener();
        this.cache().getAdvancedCache().with((ClassLoader)this.ccl).addListener((Object)listener);
        this.cache().put((Object)"a", (Object)"a");
        this.cache().replace((Object)"a", (Object)"b");
        this.cache().evict((Object)"a");
        this.cache().get((Object)"a");
        this.cache().remove((Object)"a");
        AssertJUnit.assertEquals((int)10, (int)listener.invocationCount);
    }

    @Listener
    public class ClassLoaderListener {
        int invocationCount = 0;

        @CacheEntryActivated
        @CacheEntryCreated
        @CacheEntriesEvicted
        @CacheEntryLoaded
        @CacheEntryModified
        @CacheEntryPassivated
        @CacheEntryRemoved
        @CacheEntryVisited
        public void handle(Event e) {
            AssertJUnit.assertEquals((Object)CustomClassLoaderListenerTest.this.ccl, (Object)Thread.currentThread().getContextClassLoader());
            if (!e.isPre()) {
                ++this.invocationCount;
            }
        }
    }

    public static class CustomClassLoader
    extends ClassLoader {
        public CustomClassLoader(ClassLoader parent) {
            super(parent);
        }
    }
}

