/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.jgroups;

import java.util.Collections;
import java.util.Properties;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.UDP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.UUID;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(testName="remoting.jgroups.ChannelLookupTest", groups={"functional"})
public class ChannelLookupTest
extends AbstractInfinispanTest {
    static Channel mockChannel = (Channel)Mockito.mock(Channel.class);
    ProtocolStack ps = (ProtocolStack)Mockito.mock(ProtocolStack.class);
    Address a = new UUID(1L, 1L);
    View v = new View(this.a, 1L, Collections.singletonList(this.a));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelLookupTest() {
        Mockito.when((Object)mockChannel.getAddress()).thenReturn((Object)this.a);
        Mockito.when((Object)mockChannel.down((Event)Matchers.isA(Event.class))).thenReturn((Object)this.a);
        Mockito.when((Object)mockChannel.getView()).thenReturn((Object)this.v);
        Mockito.when((Object)mockChannel.getProtocolStack()).thenReturn((Object)this.ps);
        Mockito.when((Object)this.ps.getTransport()).thenReturn((Object)new UDP());
        EmbeddedCacheManager cm = null;
        try {
            GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
            Properties p = new Properties();
            p.setProperty("channelLookup", DummyLookup.class.getName());
            gc.setTransportProperties(p);
            cm = TestCacheManagerFactory.createCacheManager(gc);
            cm.start();
            cm.getCache();
            GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm);
            Transport t = (Transport)gcr.getComponent(Transport.class);
            assert (t != null);
            assert (t instanceof JGroupsTransport);
            assert (!(((JGroupsTransport)t).getChannel() instanceof JChannel));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    public static class DummyLookup
    implements JGroupsChannelLookup {
        public Channel getJGroupsChannel(Properties p) {
            return mockChannel;
        }

        public boolean shouldStartAndConnect() {
            return false;
        }

        public boolean shouldStopAndDisconnect() {
            return false;
        }
    }
}

