/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@Test(testName="replication.ForceSyncAsyncFlagsTest", groups={"functional"})
@CleanupAfterMethod
public class ForceSyncAsyncFlagsTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration replSync = ForceSyncAsyncFlagsTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.createClusteredCaches(2, "replSync", replSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForceSyncAndAsyncFlagUsage() throws Exception {
        RpcManagerImpl asyncRpcManager;
        Transport originalTransport;
        block5: {
            AdvancedCache cache1 = this.cache(0, "replSync").getAdvancedCache();
            AdvancedCache cache2 = this.cache(1, "replSync").getAdvancedCache();
            this.waitForClusterToForm("replSync");
            originalTransport = null;
            RpcManagerImpl rpcManager = null;
            asyncRpcManager = null;
            Map emptyResponses = Collections.emptyMap();
            try {
                Configuration asyncCache = ForceSyncAsyncFlagsTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC);
                asyncCache.setUseAsyncMarshalling(true);
                this.defineConfigurationOnAllManagers("asyncCache", asyncCache);
                AdvancedCache asyncCache1 = this.manager(0).getCache("asyncCache").getAdvancedCache();
                AdvancedCache asyncCache2 = this.manager(1).getCache("asyncCache").getAdvancedCache();
                this.waitForClusterToForm("asyncCache");
                Transport mockTransport = (Transport)Mockito.mock(Transport.class);
                Address mockAddressOne = (Address)Mockito.mock(Address.class);
                Address mockAddressTwo = (Address)Mockito.mock(Address.class);
                LinkedList<Address> addresses = new LinkedList<Address>();
                addresses.add(mockAddressOne);
                addresses.add(mockAddressTwo);
                Mockito.when((Object)mockTransport.getAddress()).thenReturn((Object)mockAddressOne);
                Mockito.when((Object)mockTransport.getMembers()).thenReturn(addresses);
                originalTransport = TestingUtil.extractGlobalComponent((CacheContainer)cache1.getCacheManager(), Transport.class);
                rpcManager = (RpcManagerImpl)TestingUtil.extractComponent((Cache)cache1, RpcManager.class);
                rpcManager.setTransport(mockTransport);
                Mockito.when((Object)mockTransport.invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.SYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject())).thenReturn(emptyResponses);
                cache1.put((Object)"k", (Object)"v");
                ((Transport)Mockito.verify((Object)mockTransport)).invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.SYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject());
                cache1.withFlags(new Flag[]{Flag.FORCE_ASYNCHRONOUS}).put((Object)"k", (Object)"v");
                ((Transport)Mockito.verify((Object)mockTransport)).invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.ASYNCHRONOUS_WITH_SYNC_MARSHALLING), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject());
                asyncRpcManager = (RpcManagerImpl)TestingUtil.extractComponent((Cache)asyncCache1, RpcManager.class);
                asyncRpcManager.setTransport(mockTransport);
                Mockito.reset((Object[])new Transport[]{mockTransport});
                Mockito.when((Object)mockTransport.getAddress()).thenReturn((Object)mockAddressOne);
                Mockito.when((Object)mockTransport.getMembers()).thenReturn(addresses);
                Mockito.when((Object)mockTransport.invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.ASYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject())).thenReturn(emptyResponses);
                asyncCache1.put((Object)"k", (Object)"v");
                ((Transport)Mockito.verify((Object)mockTransport)).invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.ASYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject());
                asyncCache1.withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).put((Object)"k", (Object)"v");
                ((Transport)Mockito.verify((Object)mockTransport)).invokeRemotely((Collection)((List)Matchers.anyObject()), (ReplicableCommand)((CacheRpcCommand)Matchers.anyObject()), (ResponseMode)Matchers.eq((Object)ResponseMode.SYNCHRONOUS), Matchers.anyLong(), Matchers.anyBoolean(), (ResponseFilter)Matchers.anyObject());
                if (rpcManager == null) break block5;
            }
            catch (Throwable throwable) {
                if (rpcManager != null) {
                    rpcManager.setTransport(originalTransport);
                }
                if (asyncRpcManager != null) {
                    asyncRpcManager.setTransport(originalTransport);
                }
                throw throwable;
            }
            rpcManager.setTransport(originalTransport);
        }
        if (asyncRpcManager != null) {
            asyncRpcManager.setTransport(originalTransport);
        }
    }
}

