/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class CheckPoint {
    private final Lock lock = new ReentrantLock();
    private final Condition unblockCondition = this.lock.newCondition();
    private final Map<String, Integer> events = new HashMap<String, Integer>();

    CheckPoint() {
    }

    public void awaitStrict(String event, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.awaitStrict(event, 1, timeout, unit);
    }

    public boolean await(String event, long timeout, TimeUnit unit) throws InterruptedException {
        return this.await(event, 1, timeout, unit);
    }

    public void awaitStrict(String event, int count, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.await(event, count, timeout, unit)) {
            throw new TimeoutException("Timed out waiting for event " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(String event, int count, long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            long waitNanos = unit.toNanos(timeout);
            while (waitNanos > 0L) {
                Integer currentCount = this.events.get(event);
                if (currentCount != null && currentCount >= count) {
                    this.events.put(event, currentCount - count);
                    break;
                }
                waitNanos = this.unblockCondition.awaitNanos(waitNanos);
            }
            if (waitNanos <= 0L) {
                this.events.put(event, -1);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void trigger(String event) {
        this.trigger(event, 1);
    }

    public void triggerForever(String event) {
        this.trigger(event, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(String event, int count) {
        this.lock.lock();
        try {
            Integer currentCount = this.events.get(event);
            if (currentCount == null) {
                currentCount = 0;
            } else if (currentCount < 0) {
                throw new IllegalStateException("Thread already timed out waiting for event " + event);
            }
            this.events.put(event, currentCount + count);
            this.unblockCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

