/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.CheckPoint;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.Util;
import org.jgroups.protocols.DISCARD;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.ClusterTopologyManagerTest")
@CleanupAfterMethod
public class ClusterTopologyManagerTest
extends MultipleCacheManagersTest {
    public static final String CACHE_NAME = "cache";
    private ConfigurationBuilder defaultConfig;
    Cache c1;
    Cache c2;
    Cache c3;
    DISCARD d1;
    DISCARD d2;
    DISCARD d3;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.defaultConfig = ClusterTopologyManagerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.createClusteredCaches(3, this.defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        this.c1 = this.cache(0, CACHE_NAME);
        this.c2 = this.cache(1, CACHE_NAME);
        this.c3 = this.cache(2, CACHE_NAME);
        this.d1 = TestingUtil.getDiscardForCache(this.c1);
        this.d1.setExcludeItself(true);
        this.d2 = TestingUtil.getDiscardForCache(this.c2);
        this.d2.setExcludeItself(true);
        this.d3 = TestingUtil.getDiscardForCache(this.c3);
        this.d3.setExcludeItself(true);
    }

    public void testNodeAbruptLeave() throws Exception {
        this.cache(0, "cache2");
        this.cache(1, "cache2");
        this.cache(0, "cache3");
        this.cache(2, "cache3");
        this.cache(1, "cache4");
        this.cache(2, "cache4");
        this.cache(0, "cache5");
        this.cache(1, "cache5");
        this.log.debugf("Killing coordinator via discard", new Object[0]);
        this.d3.setDiscardAll(true);
        long startTime = System.currentTimeMillis();
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c1, this.c2);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c3);
        TestingUtil.waitForRehashToComplete(this.c1, this.c2);
        TestingUtil.waitForRehashToComplete(this.c3);
        TestingUtil.waitForRehashToComplete(this.cache(0, "cache2"), this.cache(1, "cache2"));
        TestingUtil.waitForRehashToComplete(this.cache(0, "cache3"));
        TestingUtil.waitForRehashToComplete(this.cache(1, "cache4"));
        TestingUtil.waitForRehashToComplete(this.cache(0, "cache5"), this.cache(1, "cache5"));
        long endTime = System.currentTimeMillis();
        this.log.debugf("Recovery took %s", (Object)Util.prettyPrintTime((long)(endTime - startTime)));
        assert (endTime - startTime < 30000L) : "Recovery took too long: " + Util.prettyPrintTime((long)(endTime - startTime));
        ConfigurationBuilder defaultConfig = ClusterTopologyManagerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.addClusterEnabledCacheManager(defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        Cache c4 = this.cache(3, CACHE_NAME);
        TestingUtil.blockUntilViewsReceived(30000L, true, this.c1, this.c2, c4);
        TestingUtil.waitForRehashToComplete(this.c1, this.c2, c4);
        this.cache(3, "cache2");
        this.cache(3, "cache3");
        this.cache(3, "cache4");
        this.cache(3, "cache5");
        TestingUtil.waitForRehashToComplete(this.cache(0, "cache2"), this.cache(1, "cache2"), this.cache(3, "cache2"));
        TestingUtil.waitForRehashToComplete(this.cache(0, "cache3"), this.cache(3, "cache3"));
        TestingUtil.waitForRehashToComplete(this.cache(1, "cache4"), this.cache(3, "cache4"));
        TestingUtil.waitForRehashToComplete(this.cache(0, "cache5"), this.cache(1, "cache5"), this.cache(3, "cache5"));
    }

    public void testClusterRecoveryAfterCoordLeave() throws Exception {
        this.log.debugf("Killing coordinator via discard", new Object[0]);
        this.d1.setDiscardAll(true);
        long startTime = System.currentTimeMillis();
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c1);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c2, this.c3);
        TestingUtil.waitForRehashToComplete(this.c1);
        TestingUtil.waitForRehashToComplete(this.c2, this.c3);
        long endTime = System.currentTimeMillis();
        this.log.debugf("Recovery took %s", (Object)Util.prettyPrintTime((long)(endTime - startTime)));
        assert (endTime - startTime < 30000L) : "Recovery took too long: " + Util.prettyPrintTime((long)(endTime - startTime));
        ConfigurationBuilder defaultConfig = ClusterTopologyManagerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.addClusterEnabledCacheManager(defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        Cache c4 = this.cache(3, CACHE_NAME);
        TestingUtil.blockUntilViewsReceived(30000L, true, this.c2, this.c3, c4);
        TestingUtil.waitForRehashToComplete(this.c2, this.c3, c4);
    }

    public void testClusterRecoveryAfterThreeWaySplit() throws Exception {
        this.log.debugf("Splitting the cluster in three", new Object[0]);
        this.d1.setDiscardAll(true);
        this.d2.setDiscardAll(true);
        this.d3.setDiscardAll(true);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c1);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c2);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c3);
        TestingUtil.waitForRehashToComplete(this.c1);
        TestingUtil.waitForRehashToComplete(this.c2);
        TestingUtil.waitForRehashToComplete(this.c3);
        this.log.debugf("Merging the cluster partitions", new Object[0]);
        this.d1.setDiscardAll(false);
        this.d2.setDiscardAll(false);
        this.d3.setDiscardAll(false);
        long startTime = System.currentTimeMillis();
        TestingUtil.blockUntilViewsReceived(30000L, this.c1, this.c2, this.c3);
        TestingUtil.waitForRehashToComplete(this.c1, this.c2, this.c3);
        long endTime = System.currentTimeMillis();
        this.log.debugf("Merge took %s", (Object)Util.prettyPrintTime((long)(endTime - startTime)));
        assert (endTime - startTime < 30000L) : "Merge took too long: " + Util.prettyPrintTime((long)(endTime - startTime));
        ConfigurationBuilder defaultConfig = ClusterTopologyManagerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.addClusterEnabledCacheManager(defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        Cache c4 = this.cache(3, CACHE_NAME);
        TestingUtil.blockUntilViewsReceived(30000L, true, this.c1, this.c2, this.c3, c4);
        TestingUtil.waitForRehashToComplete(this.c1, this.c2, this.c3, c4);
    }

    public void testClusterRecoveryAfterSplitAndCoordLeave() throws Exception {
        this.log.debugf("Splitting the cluster in three", new Object[0]);
        this.d1.setDiscardAll(true);
        this.d2.setDiscardAll(true);
        this.d3.setDiscardAll(true);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c1);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c2);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c3);
        TestingUtil.waitForRehashToComplete(this.c1);
        TestingUtil.waitForRehashToComplete(this.c2);
        TestingUtil.waitForRehashToComplete(this.c3);
        this.manager(0).stop();
        this.log.debugf("Merging the cluster partitions", new Object[0]);
        this.d2.setDiscardAll(false);
        this.d3.setDiscardAll(false);
        long startTime = System.currentTimeMillis();
        TestingUtil.blockUntilViewsReceived(30000L, this.c2, this.c3);
        TestingUtil.waitForRehashToComplete(this.c2, this.c3);
        long endTime = System.currentTimeMillis();
        this.log.debugf("Merge took %s", (Object)Util.prettyPrintTime((long)(endTime - startTime)));
        assert (endTime - startTime < 30000L) : "Merge took too long: " + Util.prettyPrintTime((long)(endTime - startTime));
        ConfigurationBuilder defaultConfig = ClusterTopologyManagerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.addClusterEnabledCacheManager(defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        Cache c4 = this.cache(3, CACHE_NAME);
        TestingUtil.blockUntilViewsReceived(30000L, true, this.c2, this.c3, c4);
        TestingUtil.waitForRehashToComplete(this.c2, this.c3, c4);
    }

    public void testClusterRecoveryWithRebalance() throws Exception {
        ArrayList members = new ArrayList(this.manager(0).getMembers());
        Collections.sort(members);
        Address mergeCoordAddress = (Address)members.get(0);
        this.log.debugf("The merge coordinator will be %s", (Object)mergeCoordAddress);
        EmbeddedCacheManager mergeCoordManager = this.manager(mergeCoordAddress);
        int mergeCoordIndex = this.cacheManagers.indexOf(mergeCoordManager);
        this.log.debugf("Splitting the cluster in three", new Object[0]);
        this.d1.setDiscardAll(true);
        this.d2.setDiscardAll(true);
        this.d3.setDiscardAll(true);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c1);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c2);
        TestingUtil.blockUntilViewsReceived(30000L, false, this.c3);
        TestingUtil.waitForRehashToComplete(this.c1);
        TestingUtil.waitForRehashToComplete(this.c2);
        TestingUtil.waitForRehashToComplete(this.c3);
        if (mergeCoordIndex == 0) {
            this.d1.setDiscardAll(false);
        }
        if (mergeCoordIndex == 1) {
            this.d2.setDiscardAll(false);
        }
        if (mergeCoordIndex == 2) {
            this.d3.setDiscardAll(false);
        }
        int viewIdAfterSplit = mergeCoordManager.getTransport().getViewId();
        LocalTopologyManager localTopologyManager = TestingUtil.extractGlobalComponent((CacheContainer)mergeCoordManager, LocalTopologyManager.class);
        final CheckPoint checkpoint = new CheckPoint();
        LocalTopologyManager spyLocalTopologyManager = (LocalTopologyManager)Mockito.spy((Object)localTopologyManager);
        ((LocalTopologyManager)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                int viewId = (Integer)invocation.getArguments()[2];
                checkpoint.trigger("rebalance" + viewId);
                ClusterTopologyManagerTest.this.log.debugf("Blocking the REBALANCE_START command on the merge coordinator", new Object[0]);
                checkpoint.awaitStrict("merge", 10L, TimeUnit.SECONDS);
                return invocation.callRealMethod();
            }
        }).when((Object)spyLocalTopologyManager)).handleRebalance((String)Matchers.eq((Object)CACHE_NAME), (CacheTopology)Matchers.any(CacheTopology.class), Matchers.anyInt());
        TestingUtil.replaceComponent((CacheContainer)mergeCoordManager, LocalTopologyManager.class, spyLocalTopologyManager, true);
        final EmbeddedCacheManager cm4 = this.addClusterEnabledCacheManager(this.defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        Future<Cache<Object, Object>> cacheFuture = this.fork(new Callable<Cache<Object, Object>>(){

            @Override
            public Cache<Object, Object> call() throws Exception {
                return cm4.getCache(ClusterTopologyManagerTest.CACHE_NAME);
            }
        });
        this.log.debugf("Waiting for the REBALANCE_START command to reach the merge coordinator", new Object[0]);
        checkpoint.awaitStrict("rebalance" + (viewIdAfterSplit + 1), 10L, TimeUnit.SECONDS);
        this.log.debugf("Merging the cluster partitions", new Object[0]);
        this.d1.setDiscardAll(false);
        this.d2.setDiscardAll(false);
        this.d3.setDiscardAll(false);
        long startTime = System.currentTimeMillis();
        TestingUtil.blockUntilViewsReceived(30000, this.cacheManagers);
        this.log.debugf("Unblocking the REBALANCE_START command on the coordinator", new Object[0]);
        checkpoint.triggerForever("merge");
        Cache<Object, Object> c4 = cacheFuture.get(30L, TimeUnit.SECONDS);
        TestingUtil.waitForRehashToComplete(this.c1, this.c2, this.c3, c4);
        long endTime = System.currentTimeMillis();
        this.log.debugf("Merge took %s", (Object)Util.prettyPrintTime((long)(endTime - startTime)));
        assert (endTime - startTime < 30000L) : "Merge took too long: " + Util.prettyPrintTime((long)(endTime - startTime));
        ConfigurationBuilder defaultConfig = ClusterTopologyManagerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        EmbeddedCacheManager cm5 = this.addClusterEnabledCacheManager(defaultConfig, new TransportFlags().withFD(true).withMerge(true));
        Cache c5 = cm5.getCache(CACHE_NAME);
        TestingUtil.blockUntilViewsReceived(30000L, true, this.c1, this.c2, this.c3, c4, c5);
        TestingUtil.waitForRehashToComplete(this.c1, this.c2, this.c3, c4, c5);
    }
}

