/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHashFactory;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.TestKey;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateProviderTest")
public class StateProviderTest {
    private static final Log log = LogFactory.getLog(StateProviderTest.class);
    private static final TestAddress A = new TestAddress(0, "A");
    private static final TestAddress B = new TestAddress(1, "B");
    private static final TestAddress C = new TestAddress(2, "C");
    private static final TestAddress D = new TestAddress(3, "D");
    private static final TestAddress E = new TestAddress(4, "E");
    private static final TestAddress F = new TestAddress(5, "F");
    private static final TestAddress G = new TestAddress(6, "G");
    private Configuration configuration;
    private ExecutorService pooledExecutorService;
    private ExecutorService mockExecutorService;
    private Cache cache;
    private RpcManager rpcManager;
    private CommandsFactory commandsFactory;
    private CacheNotifier cacheNotifier;
    private CacheLoaderManager cacheLoaderManager;
    private DataContainer dataContainer;
    private TransactionTable transactionTable;
    private StateTransferLock stateTransferLock;
    private StateConsumer stateConsumer;
    private CacheTopology cacheTopology;

    @BeforeTest
    public void setUp() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().invocationBatching().enable().clustering().cacheMode(CacheMode.DIST_SYNC).clustering().stateTransfer().timeout(10000L).versioning().enable().scheme(VersioningScheme.SIMPLE).locking().lockAcquisitionTimeout(200L).writeSkewCheck(true).isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.configuration = cb.build();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        };
        this.pooledExecutorService = new ThreadPoolExecutor(10, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        this.mockExecutorService = (ExecutorService)Mockito.mock(ExecutorService.class);
        this.cache = (Cache)Mockito.mock(Cache.class);
        Mockito.when((Object)this.cache.getName()).thenReturn((Object)"testCache");
        this.rpcManager = (RpcManager)Mockito.mock(RpcManager.class);
        this.commandsFactory = (CommandsFactory)Mockito.mock(CommandsFactory.class);
        this.cacheNotifier = (CacheNotifier)Mockito.mock(CacheNotifier.class);
        this.cacheLoaderManager = (CacheLoaderManager)Mockito.mock(CacheLoaderManager.class);
        this.dataContainer = (DataContainer)Mockito.mock(DataContainer.class);
        this.transactionTable = (TransactionTable)Mockito.mock(TransactionTable.class);
        this.stateTransferLock = (StateTransferLock)Mockito.mock(StateTransferLock.class);
        this.stateConsumer = (StateConsumer)Mockito.mock(StateConsumer.class);
        Mockito.when((Object)this.stateConsumer.getCacheTopology()).thenAnswer((Answer)new Answer<CacheTopology>(){

            public CacheTopology answer(InvocationOnMock invocation) {
                return StateProviderTest.this.cacheTopology;
            }
        });
    }

    @AfterTest
    public void tearDown() {
        this.pooledExecutorService.shutdownNow();
    }

    public void test1() throws InterruptedException {
        int numSegments = 4;
        List<Address> members1 = Arrays.asList(A, B, C, D, E, F);
        ArrayList<Address> members2 = new ArrayList<Address>(members1);
        members2.remove(A);
        members2.remove(F);
        members2.add(G);
        DefaultConsistentHashFactory chf = new DefaultConsistentHashFactory();
        DefaultConsistentHash ch1 = chf.create((Hash)new MurmurHash3(), 2, numSegments, members1);
        DefaultConsistentHash ch2 = chf.updateMembers(ch1, members2);
        Mockito.when(this.mockExecutorService.submit((Runnable)Matchers.any(Runnable.class))).thenAnswer(new Answer<Future<?>>(){

            public Future<?> answer(InvocationOnMock invocation) {
                return null;
            }
        });
        Mockito.when((Object)this.rpcManager.getAddress()).thenReturn((Object)A);
        StateProviderImpl stateProvider = new StateProviderImpl();
        stateProvider.init(this.cache, this.mockExecutorService, this.configuration, this.rpcManager, this.commandsFactory, this.cacheNotifier, this.cacheLoaderManager, this.dataContainer, this.transactionTable, this.stateTransferLock, this.stateConsumer);
        final ArrayList<ImmortalCacheEntry> cacheEntries = new ArrayList<ImmortalCacheEntry>();
        TestKey key1 = new TestKey("key1", 0, (ConsistentHash)ch1);
        TestKey key2 = new TestKey("key2", 0, (ConsistentHash)ch1);
        cacheEntries.add(new ImmortalCacheEntry((Object)key1, (Object)"value1"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key2, (Object)"value2"));
        Mockito.when((Object)this.dataContainer.iterator()).thenAnswer((Answer)new Answer<Iterator<InternalCacheEntry>>(){

            public Iterator<InternalCacheEntry> answer(InvocationOnMock invocation) {
                return cacheEntries.iterator();
            }
        });
        Mockito.when((Object)this.transactionTable.getLocalTransactions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.transactionTable.getRemoteTransactions()).thenReturn(Collections.emptyList());
        this.cacheTopology = new CacheTopology(1, (ConsistentHash)ch1, (ConsistentHash)ch1);
        stateProvider.onTopologyUpdate(this.cacheTopology, false);
        log.debug((Object)("ch1: " + ch1));
        Set segmentsToRequest = ch1.getSegmentsForOwner(members1.get(0));
        List transactions = stateProvider.getTransactionsForSegments(members1.get(0), 1, segmentsToRequest);
        Assert.assertEquals((long)0L, (long)transactions.size());
        try {
            stateProvider.getTransactionsForSegments(members1.get(0), 1, new HashSet<Integer>(Arrays.asList(2, numSegments)));
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateTransferLock});
        stateProvider.startOutboundTransfer((Address)F, 1, Collections.singleton(0));
        Assert.assertTrue((boolean)stateProvider.isStateTransferInProgress());
        log.debug((Object)("ch2: " + ch2));
        this.cacheTopology = new CacheTopology(2, (ConsistentHash)ch2, (ConsistentHash)ch2);
        stateProvider.onTopologyUpdate(this.cacheTopology, true);
        Assert.assertFalse((boolean)stateProvider.isStateTransferInProgress());
        stateProvider.startOutboundTransfer((Address)D, 1, Collections.singleton(0));
        Assert.assertTrue((boolean)stateProvider.isStateTransferInProgress());
        stateProvider.stop();
        Assert.assertFalse((boolean)stateProvider.isStateTransferInProgress());
    }

    public void test2() throws InterruptedException {
        int numSegments = 4;
        List<Address> members1 = Arrays.asList(A, B, C, D, E, F);
        ArrayList<Address> members2 = new ArrayList<Address>(members1);
        members2.remove(A);
        members2.remove(F);
        members2.add(G);
        DefaultConsistentHashFactory chf = new DefaultConsistentHashFactory();
        DefaultConsistentHash ch1 = chf.create((Hash)new MurmurHash3(), 2, numSegments, members1);
        DefaultConsistentHash ch2 = chf.updateMembers(ch1, members2);
        Mockito.when((Object)this.commandsFactory.buildStateResponseCommand((Address)Matchers.any(Address.class), Mockito.anyInt(), (Collection)Matchers.any(Collection.class))).thenAnswer((Answer)new Answer<StateResponseCommand>(){

            public StateResponseCommand answer(InvocationOnMock invocation) {
                return new StateResponseCommand("testCache", (Address)invocation.getArguments()[0], ((Integer)invocation.getArguments()[1]).intValue(), (Collection)invocation.getArguments()[2]);
            }
        });
        Mockito.when((Object)this.rpcManager.getAddress()).thenReturn((Object)A);
        ((RpcManager)Mockito.doAnswer((Answer)new Answer<Map<Address, Response>>(){

            public Map<Address, Response> answer(InvocationOnMock invocation) {
                Collection recipients = (Collection)invocation.getArguments()[0];
                ReplicableCommand rpcCommand = (ReplicableCommand)invocation.getArguments()[1];
                if (rpcCommand instanceof StateResponseCommand) {
                    HashMap<Address, Response> results = new HashMap<Address, Response>();
                    TestingUtil.sleepThread(10000L, "RpcManager mock interrupted during invokeRemotelyInFuture(..)");
                    return results;
                }
                return Collections.emptyMap();
            }
        }).when((Object)this.rpcManager)).invokeRemotelyInFuture((Collection)Matchers.any(Collection.class), (ReplicableCommand)Matchers.any(ReplicableCommand.class), Mockito.anyBoolean(), (NotifyingNotifiableFuture)Matchers.any(NotifyingNotifiableFuture.class), Mockito.anyLong());
        StateProviderImpl stateProvider = new StateProviderImpl();
        stateProvider.init(this.cache, this.pooledExecutorService, this.configuration, this.rpcManager, this.commandsFactory, this.cacheNotifier, this.cacheLoaderManager, this.dataContainer, this.transactionTable, this.stateTransferLock, this.stateConsumer);
        final ArrayList<ImmortalCacheEntry> cacheEntries = new ArrayList<ImmortalCacheEntry>();
        TestKey key1 = new TestKey("key1", 0, (ConsistentHash)ch1);
        TestKey key2 = new TestKey("key2", 0, (ConsistentHash)ch1);
        TestKey key3 = new TestKey("key3", 1, (ConsistentHash)ch1);
        TestKey key4 = new TestKey("key4", 1, (ConsistentHash)ch1);
        cacheEntries.add(new ImmortalCacheEntry((Object)key1, (Object)"value1"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key2, (Object)"value2"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key3, (Object)"value3"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key4, (Object)"value4"));
        Mockito.when((Object)this.dataContainer.iterator()).thenAnswer((Answer)new Answer<Iterator<InternalCacheEntry>>(){

            public Iterator<InternalCacheEntry> answer(InvocationOnMock invocation) {
                return cacheEntries.iterator();
            }
        });
        Mockito.when((Object)this.transactionTable.getLocalTransactions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.transactionTable.getRemoteTransactions()).thenReturn(Collections.emptyList());
        this.cacheTopology = new CacheTopology(1, (ConsistentHash)ch1, (ConsistentHash)ch1);
        stateProvider.onTopologyUpdate(this.cacheTopology, false);
        log.debug((Object)("ch1: " + ch1));
        Set segmentsToRequest = ch1.getSegmentsForOwner(members1.get(0));
        List transactions = stateProvider.getTransactionsForSegments(members1.get(0), 1, segmentsToRequest);
        Assert.assertEquals((long)0L, (long)transactions.size());
        try {
            stateProvider.getTransactionsForSegments(members1.get(0), 1, new HashSet<Integer>(Arrays.asList(2, numSegments)));
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stateTransferLock});
        stateProvider.startOutboundTransfer((Address)F, 1, Collections.singleton(0));
        Assert.assertTrue((boolean)stateProvider.isStateTransferInProgress());
        log.debug((Object)("ch2: " + ch2));
        this.cacheTopology = new CacheTopology(2, (ConsistentHash)ch2, (ConsistentHash)ch2);
        stateProvider.onTopologyUpdate(this.cacheTopology, false);
        Assert.assertFalse((boolean)stateProvider.isStateTransferInProgress());
        stateProvider.startOutboundTransfer((Address)E, 1, Collections.singleton(0));
        Assert.assertTrue((boolean)stateProvider.isStateTransferInProgress());
        stateProvider.stop();
        Assert.assertFalse((boolean)stateProvider.isStateTransferInProgress());
    }
}

