/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferCacheLoaderFunctionalTest")
public class StateTransferCacheLoaderFunctionalTest
extends StateTransferFunctionalTest {
    int id;
    ThreadLocal<Boolean> sharedCacheLoader = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public StateTransferCacheLoaderFunctionalTest() {
        super("nbst-with-loader");
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() {
        this.configurationBuilder.loaders().clearCacheLoaders();
        DummyInMemoryCacheStoreConfigurationBuilder dimcs = new DummyInMemoryCacheStoreConfigurationBuilder(this.configurationBuilder.loaders());
        dimcs.storeName("store number " + this.id++);
        dimcs.fetchPersistentState(true);
        this.configurationBuilder.loaders().addLoader((CacheLoaderConfigurationBuilder)dimcs);
        this.configurationBuilder.loaders().shared(this.sharedCacheLoader.get().booleanValue()).preload(true);
        return super.createCacheManager();
    }

    @Override
    protected void writeInitialData(Cache<Object, Object> c) {
        super.writeInitialData(c);
        c.evict((Object)"a_b_name");
        c.evict((Object)"a_b_age");
        c.evict((Object)"a_c_name");
        c.evict((Object)"a_c_age");
        c.evict((Object)"a_d_age");
        c.evict((Object)"a_d_age");
    }

    protected void verifyInitialDataOnLoader(Cache<Object, Object> c) throws Exception {
        CacheLoader l = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheLoader();
        assert (l.containsKey((Object)"a_b_age"));
        assert (l.containsKey((Object)"a_b_name"));
        assert (l.containsKey((Object)"a_c_age"));
        assert (l.containsKey((Object)"a_c_name"));
        assert (l.load((Object)"a_b_age").getValue().equals(TWENTY));
        assert (l.load((Object)"a_b_name").getValue().equals("JOE"));
        assert (l.load((Object)"a_c_age").getValue().equals(FORTY));
        assert (l.load((Object)"a_c_name").getValue().equals("BOB"));
    }

    protected void verifyNoData(Cache<Object, Object> c) {
        assert (c.isEmpty()) : "Cache should be empty!";
    }

    protected void verifyNoDataOnLoader(Cache<Object, Object> c) throws Exception {
        CacheLoader l = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheLoader();
        assert (!l.containsKey((Object)"a_b_age"));
        assert (!l.containsKey((Object)"a_b_name"));
        assert (!l.containsKey((Object)"a_c_age"));
        assert (!l.containsKey((Object)"a_c_name"));
        assert (!l.containsKey((Object)"a_d_age"));
        assert (!l.containsKey((Object)"a_d_age"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedLoader() throws Exception {
        try {
            this.sharedCacheLoader.set(true);
            Cache c1 = this.createCacheManager().getCache(this.cacheName);
            this.writeInitialData((Cache<Object, Object>)c1);
            Cache c2 = this.createCacheManager().getCache(this.cacheName);
            TestingUtil.blockUntilViewsReceived(60000L, c1, c2);
            TestingUtil.waitForRehashToComplete(c1, c2);
            this.verifyInitialDataOnLoader((Cache<Object, Object>)c1);
            this.verifyInitialData((Cache<Object, Object>)c1);
            this.verifyNoDataOnLoader((Cache<Object, Object>)c2);
            this.verifyNoData((Cache<Object, Object>)c2);
        }
        finally {
            this.sharedCacheLoader.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitialSlowPreload() throws Exception {
        try {
            this.sharedCacheLoader.set(true);
            EmbeddedCacheManager cm1 = this.createCacheManager();
            Cache cache1 = cm1.getCache(this.cacheName);
            this.verifyNoDataOnLoader((Cache<Object, Object>)cache1);
            this.verifyNoData((Cache<Object, Object>)cache1);
            cache1.put((Object)"A", (Object)new DelayedUnmarshal());
            cache1.put((Object)"B", (Object)new DelayedUnmarshal());
            cache1.put((Object)"C", (Object)new DelayedUnmarshal());
            Assert.assertEquals((int)cache1.size(), (int)3);
            cm1.stop();
            ConfigurationBuilder defaultConfigurationBuilder = StateTransferCacheLoaderFunctionalTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
            final EmbeddedCacheManager cm2 = super.createCacheManager();
            cm2.defineConfiguration("initialCache", defaultConfigurationBuilder.build());
            cm2.startCaches(new String[]{"initialCache"});
            EmbeddedCacheManager cm3 = super.createCacheManager();
            cm3.defineConfiguration("initialCache", defaultConfigurationBuilder.build());
            cm3.startCaches(new String[]{"initialCache"});
            TestingUtil.blockUntilViewsReceived(60000L, cm2.getCache("initialCache"), cm3.getCache("initialCache"));
            Thread worker = new Thread(){

                @Override
                public void run() {
                    cm2.startCaches(new String[]{StateTransferCacheLoaderFunctionalTest.this.cacheName});
                }
            };
            worker.start();
            TestingUtil.sleepThread(1000L);
            worker.join();
            cm3.startCaches(new String[]{this.cacheName});
            Assert.assertEquals((int)cm3.getCache(this.cacheName).size(), (int)3);
        }
        finally {
            this.sharedCacheLoader.set(false);
        }
    }

    public static class DelayedUnmarshal
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            TestingUtil.sleepThread(2000L);
            in.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }
    }
}

